/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport.config;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.medshare.mediport.config.Client;
import ch.medshare.mediport.config.ConfigKeys;
import ch.medshare.util.SystemProperties;
import ch.medshare.util.UtilFile;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class MPCProperties
extends Properties
implements ConfigKeys {
    private static final long serialVersionUID = -5479066172426446513L;
    private final String LOG_ENTRY_TITLE = String.valueOf(SystemProperties.LINE_SEPARATOR) + "###########################################################" + SystemProperties.LINE_SEPARATOR + "# PFADKONFIGURATION" + SystemProperties.LINE_SEPARATOR + "###########################################################" + SystemProperties.LINE_SEPARATOR + SystemProperties.LINE_SEPARATOR + "### NEUE MULTI CLIENT (SENDER) AB V01.05.00" + SystemProperties.LINE_SEPARATOR + SystemProperties.LINE_SEPARATOR;
    private final String installDir;
    private static MPCProperties props;
    private Map<Integer, Client> clientMap = new HashMap<Integer, Client>();

    private MPCProperties(String installDir) throws IOException {
        this.installDir = installDir;
        this.load();
    }

    public static MPCProperties reload(String installDir) throws IOException {
        props = installDir != null && installDir.length() > 0 ? new MPCProperties(installDir) : null;
        return props;
    }

    public static MPCProperties reload() throws IOException {
        SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);
        String installDir = prefs.getString("mpc/install_dir");
        return MPCProperties.reload(installDir);
    }

    public static MPCProperties getCurrent() throws IOException {
        if (props == null) {
            MPCProperties.reload();
        }
        return props;
    }

    private void addClientProperty(String key, String value) {
        String[] parts = key.split("[.]");
        Client client = this.clientMap.get(Integer.parseInt(parts[1]));
        if (client == null) {
            client = new Client(this.installDir);
            this.clientMap.put(Integer.parseInt(parts[1]), client);
        }
        client.add(parts, value);
    }

    public String getConfigFilenamePath() {
        return String.valueOf(this.installDir) + File.separator + "config" + File.separator + "mpcommunicator.config";
    }

    public void load() throws IOException {
        this.load(new FileInputStream(this.getConfigFilenamePath()));
        for (Object keyObj : this.keySet()) {
            String key = (String)keyObj;
            if (key == null || !key.startsWith("CLIENT.")) continue;
            this.addClientProperty(key, this.getProperty(key));
        }
    }

    public void store() throws IOException {
        boolean clientAdded = false;
        boolean skipEmptyLines = false;
        StringBuffer newContent = new StringBuffer();
        try (FilterInputStream in = null;){
            String strLine;
            FileInputStream fstream = new FileInputStream(this.getConfigFilenamePath());
            in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                if (strLine.trim().startsWith("#") || strLine.indexOf("=") < 0) {
                    if (skipEmptyLines && strLine.trim().length() <= 0) continue;
                    newContent.append(strLine);
                    newContent.append(SystemProperties.LINE_SEPARATOR);
                    skipEmptyLines = false;
                    continue;
                }
                if (strLine.trim().startsWith("CLIENT")) {
                    if (clientAdded) continue;
                    newContent.append(this.clientString());
                    clientAdded = true;
                    skipEmptyLines = true;
                    continue;
                }
                String[] parts = strLine.split("[=]");
                String value = this.getProperty(parts[0].trim());
                if (value == null) {
                    newContent.append(strLine);
                } else {
                    newContent.append(String.valueOf(parts[0]) + "=" + value);
                }
                newContent.append(SystemProperties.LINE_SEPARATOR);
                skipEmptyLines = false;
            }
            if (!clientAdded) {
                newContent.append(this.LOG_ENTRY_TITLE);
                newContent.append(this.clientString());
            }
        }
        UtilFile.writeTextFile((String)this.getConfigFilenamePath(), (String)newContent.toString());
    }

    public Client getClient(Integer num) {
        if (num == null) {
            return null;
        }
        return this.clientMap.get(num);
    }

    public int addNewClient(Client client) {
        int nextNumber = this.getNextClientKey();
        this.clientMap.put(nextNumber, client);
        return nextNumber;
    }

    private int getNextClientKey() {
        int maxNumber = 0;
        for (Integer key : this.clientMap.keySet()) {
            if (key <= maxNumber) continue;
            maxNumber = key;
        }
        return maxNumber + 1;
    }

    public List<Integer> getClientKeys() {
        Vector<Integer> keyList = new Vector<Integer>();
        for (Integer key : this.clientMap.keySet()) {
            keyList.add(key);
        }
        return keyList;
    }

    public String clientString() {
        StringBuffer buffer = new StringBuffer();
        for (Integer num : this.clientMap.keySet()) {
            Client client = this.getClient(num);
            buffer.append(client.toString(num));
            buffer.append(SystemProperties.LINE_SEPARATOR);
        }
        return buffer.toString();
    }
}

