/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport.config;

import ch.elexis.core.data.util.SortedList;
import ch.medshare.mediport.config.AbstractConfigKeyModel;
import ch.medshare.mediport.config.ClientParam;
import ch.medshare.mediport.util.MediPortHelper;
import ch.medshare.util.SystemProperties;
import ch.medshare.util.UtilMisc;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Client
extends AbstractConfigKeyModel {
    private String ean = "";
    private String send_dir = "data/send";
    private String receive_dir = "data/receive";
    private String receivetest_dir = "data/receive/test";
    private String error_dir = "data/error";
    private String docstat_dir = "data/docstatus";
    private String partner_file = "data/partner/partnerinfo.txt";
    private String stylesheet = "";
    public Map<Integer, ClientParam> paramMap = new HashMap<Integer, ClientParam>();

    public Client(String installDir) {
        if (installDir != null && installDir.length() > 0) {
            this.setSend_dir(String.valueOf(installDir) + "/" + this.send_dir);
            this.setReceive_dir(String.valueOf(installDir) + "/" + this.receive_dir);
            this.setReceivetest_dir(String.valueOf(installDir) + "/" + this.receivetest_dir);
            this.setError_dir(String.valueOf(installDir) + "/" + this.error_dir);
            this.setDocstat_dir(String.valueOf(installDir) + "/" + this.docstat_dir);
            this.setPartner_file(String.valueOf(installDir) + "/" + this.partner_file);
        }
        this.setStylesheet(UtilMisc.replaceWithForwardSlash((String)(String.valueOf(MediPortHelper.getPluginDirectory("ch.medshare.mediport")) + File.separator + "rsc" + File.separator + "mediport_response.xsl")));
    }

    public void add(String[] parts, String value) {
        if ("DIR".equals(parts[2])) {
            Integer num = Integer.parseInt(parts[3]);
            ClientParam param = this.paramMap.get(num);
            if (param == null) {
                param = new ClientParam(num.toString());
                this.paramMap.put(num, param);
            }
            param.add(parts, value);
        } else {
            this.add(parts[2], value);
        }
    }

    public void add(String key, String value) {
        if ("EAN".equals(key)) {
            this.setEan(value);
        } else if ("SEND_DIR".equals(key)) {
            this.setSend_dir(value);
        } else if ("RECEIVE_DIR".equals(key)) {
            this.setReceive_dir(value);
        } else if ("RECEIVETEST_DIR".equals(key)) {
            this.setReceivetest_dir(value);
        } else if ("ERROR_DIR".equals(key)) {
            this.setError_dir(value);
        } else if ("DOCSTAT_DIR".equals(key)) {
            this.setDocstat_dir(value);
        } else if ("PARTNER_FILE".equals(key)) {
            this.setPartner_file(value);
        }
    }

    public int addNewParam(ClientParam param) {
        int nextNumber = this.getNextParamKey();
        this.paramMap.put(nextNumber, param);
        return nextNumber;
    }

    private int getNextParamKey() {
        int maxNumber = 0;
        for (Integer key : this.paramMap.keySet()) {
            if (key <= maxNumber) continue;
            maxNumber = key;
        }
        return maxNumber + 1;
    }

    public ClientParam getParam(Integer pNum) {
        if (pNum == null) {
            return null;
        }
        return this.paramMap.get(pNum);
    }

    public Integer getParamKey(String paramBez) {
        if (paramBez == null) {
            return null;
        }
        for (Integer paramNum : this.paramMap.keySet()) {
            ClientParam param = this.paramMap.get(paramNum);
            if (!paramBez.equals(param.getName())) continue;
            return paramNum;
        }
        return null;
    }

    public List<String> getParamNames() {
        SortedList nameList = new SortedList((Comparator)new StringComparator());
        for (ClientParam param : this.paramMap.values()) {
            nameList.add((Object)param.getName());
        }
        nameList.sort();
        return nameList;
    }

    public List<Integer> getParamKeys() {
        Vector<Integer> keyList = new Vector<Integer>();
        for (Integer key : this.paramMap.keySet()) {
            keyList.add(key);
        }
        return keyList;
    }

    public String toString(Integer num) {
        StringBuffer buffer = new StringBuffer();
        String clientPrefix = "CLIENT." + num + ".";
        buffer.append(String.valueOf(clientPrefix) + "EAN" + "=" + this.getEan());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "SEND_DIR" + "=" + this.getSend_dir());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "RECEIVE_DIR" + "=" + this.getReceive_dir());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "RECEIVETEST_DIR" + "=" + this.receivetest_dir);
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "ERROR_DIR" + "=" + this.getError_dir());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "DOCSTAT_DIR" + "=" + this.getDocstat_dir());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        buffer.append(String.valueOf(clientPrefix) + "PARTNER_FILE" + "=" + this.getPartner_file());
        buffer.append(SystemProperties.LINE_SEPARATOR);
        for (Integer pNum : this.paramMap.keySet()) {
            ClientParam param = this.getParam(pNum);
            buffer.append(param.toString(clientPrefix, pNum));
        }
        return buffer.toString();
    }

    public String getEan() {
        return this.ean;
    }

    public void setEan(String ean) {
        String oldValue = this.ean;
        this.ean = ean;
        this.propertyChanged(ean, oldValue);
    }

    public String getSend_dir() {
        return this.send_dir;
    }

    public void setSend_dir(String send_dir) {
        String oldValue = this.send_dir;
        this.send_dir = send_dir;
        this.propertyChanged(send_dir, oldValue);
    }

    public String getReceive_dir() {
        return this.receive_dir;
    }

    public void setReceive_dir(String receive_dir) {
        String oldValue = this.receive_dir;
        this.receive_dir = receive_dir;
        this.propertyChanged(receive_dir, oldValue);
    }

    public String getReceivetest_dir() {
        return this.receivetest_dir;
    }

    public void setReceivetest_dir(String receivetest_dir) {
        String oldValue = this.receivetest_dir;
        this.receivetest_dir = receivetest_dir;
        this.propertyChanged(receivetest_dir, oldValue);
    }

    public String getError_dir() {
        return this.error_dir;
    }

    public void setError_dir(String error_dir) {
        String oldValue = this.error_dir;
        this.error_dir = error_dir;
        this.propertyChanged(error_dir, oldValue);
    }

    public String getDocstat_dir() {
        return this.docstat_dir;
    }

    public void setDocstat_dir(String docstat_dir) {
        String oldValue = this.docstat_dir;
        this.docstat_dir = docstat_dir;
        this.propertyChanged(docstat_dir, oldValue);
    }

    public String getPartner_file() {
        return this.partner_file;
    }

    public void setPartner_file(String partner_file) {
        String oldValue = this.partner_file;
        this.partner_file = partner_file;
        this.propertyChanged(partner_file, oldValue);
    }

    public String getStylesheet() {
        return this.stylesheet;
    }

    public void setStylesheet(String stylesheet) {
        String oldValue = this.stylesheet;
        this.stylesheet = stylesheet;
        this.propertyChanged(stylesheet, oldValue);
    }

    private class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

