/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.medshare.mediport.Messages;
import ch.medshare.mediport.config.Client;
import ch.medshare.mediport.config.ClientParam;
import ch.medshare.mediport.config.MPCProperties;
import ch.medshare.mediport.util.MediPortHelper;
import ch.medshare.util.UtilFile;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediportOutputter
extends XMLExporter {
    protected static String TIER_PAYANT = "TP";
    protected static String TIER_GARANT = "TG";
    private static final int OUTPUT_MEDIPORT = 0;
    private static final int OUTPUT_ALTERNATIVE = 1;
    private static final int OUTPUT_ERROR = 2;
    private static Logger log = LoggerFactory.getLogger(MediportOutputter.class);
    static Combo cbParamNames;
    private boolean alternativeRun = false;
    MPCProperties props = null;
    ClientParam selectedParam;
    SettingsPreferenceStore prefs = new SettingsPreferenceStore(CoreHub.globalCfg);

    public Control createSettingsControl(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        MPCProperties props = this.getProperties();
        if (props != null) {
            Client client = MediPortHelper.getCurrentClient();
            if (client == null) {
                this.addMessage(ret, Messages.MediportOutputter_error_msg1_NoMPCClient, Messages.MediportOutputter_error_msg2_NoMPCClient);
            } else if (client.getParamNames().size() == 0) {
                this.addMessage(ret, Messages.MediportOutputter_error_msg1_NoMPCParam, Messages.MediportOutputter_error_msg2_NoMPCParam);
            } else {
                Label lblParam = new Label(ret, 0);
                lblParam.setText(Messages.MediportOutputter_lbl_Parameter);
                cbParamNames = new Combo(ret, 2056);
                cbParamNames.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                for (String name : client.getParamNames()) {
                    cbParamNames.add(name);
                }
                if (client.getParamNames().size() > 0) {
                    cbParamNames.select(0);
                }
                cbParamNames.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false));
            }
        } else {
            this.addMessage(ret, Messages.MediportOutputter_error_msg1_NoMPCConfig, Messages.MediportOutputter_error_msg2_NoMPCConfig);
        }
        return ret;
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, final Properties props) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final Result res = new Result();
        final ClientParam param = this.getSelectedParam();
        if (param == null) {
            return res;
        }
        IRnOutputter alternativeAusgabe = null;
        if (!this.alternativeRun) {
            if (!this.clientParamsOk(param)) {
                return res;
            }
            String selectedOutput = this.prefs.getString("mpc/ausgabe");
            if (selectedOutput != null) {
                List<IRnOutputter> lo = MediPortHelper.getRnOutputter();
                for (IRnOutputter ro : lo) {
                    if (!selectedOutput.equals(ro.getDescription())) continue;
                    alternativeAusgabe = ro;
                }
            }
        }
        final boolean alternativeIsMediPort = alternativeAusgabe instanceof MediportOutputter;
        final Vector alternativeRnn = new Vector();
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.MediportOutputter_info_exportiereRechnungen, rnn.size());
                    Log log = Log.get((String)"MediPortOutputter");
                    for (Rechnung rn : rnn) {
                        boolean isMediPortParticipant = MediportOutputter.this.partnerInfoContainsEan(MediportOutputter.this.getRecipientEAN(rn));
                        boolean fromDefaultOutputter = "asDefault".equals(props.getProperty("OutputMethod"));
                        int outputMethod = 0;
                        if (!(fromDefaultOutputter || isMediPortParticipant || alternativeIsMediPort)) {
                            outputMethod = 2;
                        }
                        if (fromDefaultOutputter && !isMediPortParticipant && !alternativeIsMediPort) {
                            outputMethod = 1;
                        }
                        log.log("doLicensedOutput: rn.getNr()=" + rn.getNr() + "; getRecipientEAN(rn)=" + MediportOutputter.this.getRecipientEAN(rn) + "; TarmedRequirements.getEAN(getKostentraeger(rn))=" + TarmedRequirements.getEAN((Kontakt)MediportOutputter.this.getKostentraeger(rn)) + "; partnerInfoContainsEan(getRecipientEAN(rn))=" + MediportOutputter.this.partnerInfoContainsEan(MediportOutputter.this.getRecipientEAN(rn)) + "; isMediPortParticipant=" + isMediPortParticipant + "; fromDefaultOutputter=" + fromDefaultOutputter + "; alternativeRun=" + MediportOutputter.this.alternativeRun + "; alternativeIsMediPort=" + alternativeIsMediPort + "; outputMethod=" + outputMethod, 5);
                        if (outputMethod == 1) {
                            log.log("MediPortOutputter.doLicensedOutput: alternativeRun=" + MediportOutputter.this.alternativeRun, 5);
                            alternativeRnn.add(rn);
                        }
                        if (outputMethod == 2) {
                            log.log("MediPortOutputter.doLicensedOutput: isMediPortParticipant=" + isMediPortParticipant, 5);
                            String errorMsg = Messages.MediportOutputter_error_NotMediPortParticipant;
                            if (rn.getStatus() == 4) {
                                rn.reject(RnStatus.REJECTCODE.INTERNAL_ERROR, errorMsg);
                            } else {
                                String title = Messages.MediportOutputter_error_Rechnung;
                                title = String.valueOf(title) + " " + rn.getNr();
                                MessageDialog.openError((Shell)new Shell(), (String)title, (String)errorMsg);
                            }
                        }
                        if (outputMethod == 0) {
                            String billFilenamePath = String.valueOf(param.getDir()) + File.separator + rn.getNr() + ".xml";
                            log.log("doLicensedOutput: rn.getNr()=" + rn.getNr() + "; billFilenamePath=" + billFilenamePath, 5);
                            if (MediportOutputter.this.checkTier(rn, param.getDocattr())) {
                                if (MediportOutputter.this.doExport(rn, billFilenamePath, type, true) == null) {
                                    res.add(Result.SEVERITY.ERROR, 1, String.valueOf(Messages.MediportOutputter_error_Rechnung) + rn.getNr(), (Object)rn, true);
                                }
                            } else {
                                String errorMsg = Messages.MediportOutputter_error_WrongTier;
                                if (rn.getStatus() == 4) {
                                    rn.reject(RnStatus.REJECTCODE.INTERNAL_ERROR, errorMsg);
                                } else {
                                    String title = Messages.MediportOutputter_error_Rechnung;
                                    title = String.valueOf(title) + " " + rn.getNr();
                                    MessageDialog.openError((Shell)new Shell(), (String)title, (String)errorMsg);
                                }
                            }
                            log.log("MediPortOutputter.doLicensedOutput: rn.getStatus()=" + rn.getStatus(), 5);
                            if (rn.getStatus() == 22) {
                                res.add(Result.SEVERITY.ERROR, 1, String.valueOf(Messages.MediportOutputter_error_Rechnung) + rn.getNr(), (Object)rn, true);
                            }
                            monitor.worked(1);
                            if (monitor.isCanceled()) break;
                        }
                        monitor.done();
                    }
                }
            }, null);
            Log log = Log.get((String)"MediPortOutputter");
            if (alternativeAusgabe != null && alternativeRnn.size() > 0) {
                boolean abort = false;
                log.log("doLicensedOutput: alternativeAusgabe.doOutput alternativeRnn.size()=" + alternativeRnn.size() + "; type=" + type.toString(), 5);
                if (alternativeAusgabe instanceof MediportOutputter) {
                    ((MediportOutputter)alternativeAusgabe).setAlternative();
                } else {
                    final IRnOutputter iro = alternativeAusgabe;
                    SWTHelper.SimpleDialog dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

                        public Control getControl(Composite parent) {
                            parent.getShell().setText(iro.getDescription());
                            return (Control)iro.createSettingsControl((Object)parent);
                        }

                        public void beforeClosing() {
                            iro.saveComposite();
                        }
                    });
                    if (dlg.open() != 0) {
                        abort = true;
                    }
                }
                if (!abort) {
                    alternativeAusgabe.doOutput(type, alternativeRnn, props);
                }
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
        }
        if (!res.isOK()) {
            ErrorDialog.openError(null, (String)Messages.MediportOutputter_error_Output, (String)Messages.MediportOutputter_error_MediPortTransmit, (IStatus)ResultAdapter.getResultAsStatus((Result)res));
        }
        return res;
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public String getDescription() {
        return Messages.MediportOutputter_description_MediPortTransmit;
    }

    public void saveComposite() {
        super.saveComposite();
        String paramName = null;
        if (cbParamNames != null && !cbParamNames.isDisposed()) {
            if (cbParamNames.getSelectionIndex() >= 0) {
                paramName = cbParamNames.getItem(cbParamNames.getSelectionIndex());
            }
            this.selectedParam = MediPortHelper.getCurrentParam(paramName);
        }
    }

    protected String getIntermediateEAN(Fall fall) {
        String retVal = this.prefs.getString("mpc/inter_ean");
        if (retVal == null) {
            retVal = super.getIntermediateEAN(fall);
        }
        return retVal;
    }

    protected String getRole(Fall fall) {
        String retVal = this.prefs.getString("mpc/server");
        if (retVal == null) {
            retVal = super.getRole(fall);
        }
        return retVal;
    }

    protected Element buildGuarantor(Kontakt garant, Kontakt patient) {
        Element guarantor = new Element("guarantor", nsinvoice);
        guarantor.addContent((Content)XMLExporterUtil.buildAdressElement((Kontakt)patient, (boolean)true));
        return guarantor;
    }

    protected String getSenderEAN(Mandant actMandant) {
        String senderEan = null;
        MPCProperties props = this.getProperties();
        if (props != null) {
            Client client = MediPortHelper.getCurrentClient();
            senderEan = client.getEan();
        }
        if (senderEan == null) {
            senderEan = TarmedRequirements.getEAN((Kontakt)actMandant);
        }
        return senderEan;
    }

    private MPCProperties getProperties() {
        if (this.props == null) {
            try {
                this.props = MPCProperties.getCurrent();
            }
            catch (IOException e) {
                log.warn(e.getMessage());
            }
        }
        return this.props;
    }

    private void addMessage(Composite parent, String msg1, String msg2) {
        Label lblConfigError1 = new Label(parent, 0);
        lblConfigError1.setText(msg1);
        Label lblConfigError2 = new Label(parent, 0);
        lblConfigError2.setText(msg2);
    }

    private ClientParam getSelectedParam() {
        SWTHelper.SimpleDialog dlg;
        if (this.selectedParam == null && (dlg = new SWTHelper.SimpleDialog(new SWTHelper.IControlProvider(){

            public Control getControl(Composite parent) {
                parent.getShell().setText(MediportOutputter.this.getDescription());
                return MediportOutputter.this.createSettingsControl(parent);
            }

            public void beforeClosing() {
                MediportOutputter.this.saveComposite();
            }
        })).open() != 0) {
            return null;
        }
        return this.selectedParam;
    }

    private boolean clientParamsOk(ClientParam param) {
        if (param == null) {
            MessageDialog.openError((Shell)new Shell(), (String)this.getDescription(), (String)Messages.MediportOutputter_error_msg_unknownParameter);
            return false;
        }
        String message = null;
        MPCProperties props = this.getProperties();
        if (props != null) {
            String serverIp = props.getProperty("mpcommunicator.mediport.ip");
            if ("212.243.92.199".equals(serverIp)) {
                message = Messages.MediportOutputter_info_testServer;
            } else if ("test".equals(this.prefs.getString("mpc/server"))) {
                message = Messages.MediportOutputter_info_test;
            }
        }
        if (message != null) {
            return MessageDialog.openQuestion((Shell)new Shell(), (String)this.getDescription(), (String)(String.valueOf(message) + "\n" + Messages.MediportOutputter_question_Fortfahren));
        }
        return true;
    }

    private String getRecipientEAN(Rechnung rn) {
        String retVal = TarmedRequirements.getRecipientEAN((Kontakt)this.getKostentraeger(rn));
        if (retVal.equals("unknown")) {
            retVal = TarmedRequirements.getEAN((Kontakt)this.getKostentraeger(rn));
        }
        return retVal;
    }

    private boolean partnerInfoContainsEan(String ean) {
        Client client = MediPortHelper.getCurrentClient();
        if (client != null) {
            log.debug("partnerInfoContainsEan: client.getPartner_file()=" + client.getPartner_file());
            File partnerInfoFile = new File(client.getPartner_file());
            if (partnerInfoFile.exists()) {
                try {
                    String content = UtilFile.readTextFile((String)partnerInfoFile.getAbsolutePath());
                    log.debug("partnerInfoContainsEan: ean=" + ean + "; content.indexOf(ean)=" + content.indexOf(ean));
                    return content.indexOf(ean) >= 0;
                }
                catch (IOException e) {
                    log.warn(e.getMessage());
                }
            }
        }
        log.debug("partnerInfoContainsEan: return false");
        return false;
    }

    private boolean checkTier(Rechnung rn, String mediPortTiers) {
        String tierRn = this.getTier(rn);
        String tierMP = "XX";
        if ("Tiers_Payant".equals(mediPortTiers)) {
            tierMP = TIER_PAYANT;
        } else if ("Tiers_Garant_Manuell".equals(mediPortTiers)) {
            tierMP = TIER_GARANT;
        } else if ("Tiers_Garant_Direct".equals(mediPortTiers)) {
            tierMP = TIER_GARANT;
        }
        return tierRn == tierMP;
    }

    private void setAlternative() {
        this.alternativeRun = true;
    }

    private Kontakt getKostentraeger(Rechnung rn) {
        Fall tempFall = rn.getFall();
        Patient tempPatient = tempFall.getPatient();
        Kontakt kostentraeger = tempFall.getCostBearer();
        Kontakt rnAdressat = tempFall.getGarant();
        if (kostentraeger == null || !kostentraeger.isValid()) {
            kostentraeger = rnAdressat;
        }
        if (kostentraeger == null) {
            kostentraeger = tempPatient;
        }
        return kostentraeger;
    }

    private String getTier(Rechnung rn) {
        Fall tempFall = rn.getFall();
        Kontakt kostentraeger = tempFall.getCostBearer();
        Kontakt rnAdressat = tempFall.getGarant();
        String tiers = TIER_GARANT;
        tiers = kostentraeger != null && kostentraeger.isValid() ? (rnAdressat.equals((Object)kostentraeger) ? TIER_PAYANT : TIER_GARANT) : TIER_GARANT;
        return tiers;
    }
}

