/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport;

import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.medshare.mediport.MediPortAbstractPrefPage;
import ch.medshare.mediport.Messages;
import ch.medshare.mediport.config.MPCProperties;
import ch.medshare.mediport.util.MediPortHelper;
import ch.medshare.swt.widgets.DirectoryText;
import ch.medshare.util.UtilFile;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class MediportMainPrefPage
extends MediPortAbstractPrefPage {
    private static Log log = Log.get((String)"MediportMainPrefPage");
    DirectoryText txtInstallDir;
    Combo cbServer;
    Combo cbServerIp;
    Combo cbAusgabe;
    Text txtIntermediaerEAN;
    Text txtSenderEAN;
    Text txtSenderDN;
    Button btnInit;
    private boolean overwriteRunning = false;
    private boolean installChanged = false;

    private void fillData() {
        String installDir = this.getPrefString("mpc/install_dir");
        this.txtInstallDir.setText(installDir);
        this.cbAusgabe.setText(this.getPrefString("mpc/ausgabe"));
        this.cbServer.setText(this.getPrefString("mpc/server"));
        String interEAN = this.getPrefString("mpc/inter_ean");
        if (interEAN == null || interEAN.length() == 0) {
            interEAN = "7601001304307";
        }
        this.txtIntermediaerEAN.setText(interEAN);
        try {
            this.props = MPCProperties.reload(installDir);
            if (this.props != null) {
                this.txtSenderEAN.setText(this.props.getProperty("mpcommunicator.sender.ean"));
                this.txtSenderDN.setText(this.props.getProperty("mediport.dn"));
                String serverIp = this.props.getProperty("mpcommunicator.mediport.ip");
                if ("212.243.92.201".equals(serverIp)) {
                    this.cbServerIp.setText(LBL_SERVER_URL_PRODUKTIV);
                } else if ("212.243.92.199".equals(serverIp)) {
                    this.cbServerIp.setText(LBL_SERVER_URL_TEST);
                } else {
                    this.cbServerIp.setText(serverIp);
                }
            }
        }
        catch (IOException e) {
            Log.get((String)((Object)((Object)this)).getClass().getName()).log(e.getMessage(), 3);
        }
        this.installChanged = false;
    }

    private void installDirChanged() {
        if (this.installChanged && !this.overwriteRunning) {
            this.overwriteRunning = true;
            try {
                try {
                    String installDir = this.txtInstallDir.getText();
                    File installFile = new File(installDir);
                    if (installFile.exists() && installFile.isDirectory()) {
                        this.props = MPCProperties.reload(installDir);
                        if (this.props != null) {
                            boolean overwrite = false;
                            String ean = this.props.getProperty("mpcommunicator.sender.ean", "");
                            String dn = this.props.getProperty("mediport.dn", "");
                            String ip = this.props.getProperty("mpcommunicator.mediport.ip", "");
                            if (!("".equals(this.txtSenderEAN.getText()) && "".equals(this.txtSenderDN.getText()) && "".equals(this.cbServerIp.getText()))) {
                                if (!(ean.equals(this.txtSenderEAN.getText()) && dn.equals(this.txtSenderDN.getText()) && ip.equals(this.cbServerIp.getText()))) {
                                    String msg = MessageFormat.format(Messages.MediportMainPrefPage_question_msg_differentData, this.props.getConfigFilenamePath());
                                    if (MessageDialog.openQuestion((Shell)this.getShell(), (String)msg, (String)Messages.MediportMainPrefPage_question_msg_DatenUebernehmen)) {
                                        overwrite = true;
                                    }
                                }
                            } else {
                                overwrite = true;
                            }
                            if (overwrite) {
                                if (this.txtIntermediaerEAN.getText() == null || this.txtIntermediaerEAN.getText().length() == 0) {
                                    this.txtIntermediaerEAN.setText(ean);
                                }
                                this.txtSenderEAN.setText(ean);
                                this.txtSenderDN.setText(dn);
                                this.cbServerIp.setText(ip);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    this.overwriteRunning = false;
                    this.installChanged = false;
                }
            }
            finally {
                this.overwriteRunning = false;
                this.installChanged = false;
            }
        }
    }

    private void btnInitAbCDPressed() {
        block12: {
            FileDialog fileDialog = new FileDialog(this.getShell());
            fileDialog.setFilterExtensions(new String[]{"*.re", "*.*"});
            String filenamePath = fileDialog.open();
            if (filenamePath != null) {
                try {
                    String content = UtilFile.readTextFile((String)filenamePath);
                    int start = content.indexOf("uid=");
                    if (start >= 0) {
                        String uid;
                        int end = content.indexOf(",", start);
                        if (end < 0) {
                            end = content.length() - 1;
                        }
                        if ((uid = content.substring(start + 4, end)).length() > 3 && uid.toUpperCase().startsWith("EAN")) {
                            uid = uid.substring(3);
                        }
                        log.log("INIT: Content = " + uid, 5);
                        log.log("INIT: UID = " + uid, 5);
                        this.txtSenderEAN.setText(uid);
                        this.txtSenderDN.setText(content);
                        String keystoreFilename = "EAN" + uid + "_mpg.keystore";
                        File keystoreFile = new File(String.valueOf(UtilFile.getFilepath((String)filenamePath)) + File.separator + keystoreFilename);
                        File toDir = new File(String.valueOf(this.prefs.getString("mpc/install_dir")) + File.separator + "config");
                        log.log("INIT: Check Keystorefile = " + keystoreFile.getCanonicalPath(), 5);
                        log.log("INIT: Check config path = " + toDir.getCanonicalPath(), 5);
                        String msg = "";
                        if (!keystoreFile.exists()) {
                            msg = String.valueOf(Messages.MediportMainPrefPage_error_msg_InitAbCD_SrcNotFound) + keystoreFile.getCanonicalPath();
                        }
                        if (!toDir.exists()) {
                            msg = String.valueOf(Messages.MediportMainPrefPage_error_msg_InitAbCD_DstNotFound) + toDir.getCanonicalPath();
                        }
                        if (keystoreFile.exists() && toDir.exists()) {
                            log.log("INIT: Keystorefile gefunden", 5);
                            String toPath = String.valueOf(toDir.getCanonicalPath()) + File.separator + keystoreFilename;
                            log.log("INIT: Keystorefile wird kopiert. Ziel: " + toPath, 5);
                            UtilFile.deleteFile((String)(String.valueOf(toPath) + ".old"));
                            UtilFile.moveFile((String)toPath, (String)(String.valueOf(toPath) + ".old"));
                            UtilFile.copyFile((String)keystoreFile.getCanonicalPath(), (String)toPath);
                            if (new File(toPath).exists()) {
                                log.log("INIT: Keystorefile wurde erfolgreich kopiert", 5);
                            } else {
                                log.log("INIT: " + toPath + " existiert nicht...", 5);
                                MessageDialog.openError((Shell)this.getShell(), (String)Messages.MediportMainPrefPage_error_title_InitAbCD, (String)(String.valueOf(Messages.MediportMainPrefPage_error_msg_InitAbCD) + "\r" + msg));
                            }
                        } else {
                            log.log("INIT: " + msg, 5);
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MediportMainPrefPage_error_title_InitAbCD, (String)(String.valueOf(Messages.MediportMainPrefPage_error_msg_InitAbCD) + "\r" + msg));
                        }
                        break block12;
                    }
                    throw new IOException(Messages.MediportMainPrefPage_error_msg_Dateiformat);
                }
                catch (IOException ex) {
                    ExHandler.handle((Throwable)ex);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.MediportMainPrefPage_error_title_InitAbCD, (String)ex.getMessage());
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(3, false));
        comp.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Label lblInstallDir = new Label(comp, 0);
        lblInstallDir.setText(Messages.MediportMainPrefPage_lbl_Installationsverzeichnis);
        this.txtInstallDir = new DirectoryText(comp, 2048);
        this.txtInstallDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Label lblServer = new Label(comp, 0);
        lblServer.setText(Messages.MediportMainPrefPage_lbl_Uebermittlung);
        this.cbServer = new Combo(comp, 2056);
        this.cbServer.add("production");
        this.cbServer.add("test");
        this.cbServer.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        Label lblServerIp = new Label(comp, 0);
        lblServerIp.setText(Messages.MediportMainPrefPage_lbl_MediportServerURL);
        this.cbServerIp = new Combo(comp, 2048);
        this.cbServerIp.add(LBL_SERVER_URL_PRODUKTIV);
        this.cbServerIp.add(LBL_SERVER_URL_TEST);
        this.cbServerIp.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        Label lblAusgabe = new Label(comp, 0);
        lblAusgabe.setText(Messages.MediportMainPrefPage_lbl_Rechnungsausgabe);
        this.cbAusgabe = new Combo(comp, 2056);
        this.cbAusgabe.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
        Label lblIntermediaerEAN = new Label(comp, 0);
        lblIntermediaerEAN.setText(Messages.MediportMainPrefPage_lbl_IntermediaerEAN);
        this.txtIntermediaerEAN = new Text(comp, 2048);
        this.txtIntermediaerEAN.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        Group senderComp = new Group(comp, 0);
        senderComp.setText(Messages.MediportMainPrefPage_mediport_Sender);
        senderComp.setLayout((Layout)new GridLayout(2, false));
        senderComp.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label lblSenderEAN = new Label((Composite)senderComp, 0);
        lblSenderEAN.setText(Messages.MediportMainPrefPage_mediport_EAN);
        this.txtSenderEAN = new Text((Composite)senderComp, 2048);
        this.txtSenderEAN.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Label lblSenderDN = new Label((Composite)senderComp, 0);
        lblSenderDN.setText(Messages.MediportMainPrefPage_mediport_DN);
        this.txtSenderDN = new Text((Composite)senderComp, 2048);
        this.txtSenderDN.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.btnInit = new Button((Composite)senderComp, 8);
        this.btnInit.setText(Messages.MediportMainPrefPage_btn_InitAbCD);
        this.btnInit.setLayoutData((Object)new GridData(2));
        this.btnInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MediportMainPrefPage.this.btnInitAbCDPressed();
            }
        });
        this.txtInstallDir.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MediportMainPrefPage.this.installDirChanged();
            }

            public void focusGained(FocusEvent e) {
                MediportMainPrefPage.this.installDirChanged();
            }
        });
        this.txtInstallDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MediportMainPrefPage.this.installChanged = true;
            }
        });
        List<IRnOutputter> lo = MediPortHelper.getRnOutputter();
        for (IRnOutputter ro : lo) {
            this.cbAusgabe.add(ro.getDescription());
        }
        this.cbAusgabe.select(0);
        this.cbServer.select(0);
        this.cbServerIp.select(0);
        this.fillData();
        return parent;
    }

    @Override
    protected boolean storeAll() {
        this.putPrefString("mpc/install_dir", this.txtInstallDir.getText());
        this.putPrefString("mpc/ausgabe", this.cbAusgabe.getItem(this.cbAusgabe.getSelectionIndex()));
        this.putPrefString("mpc/server", this.cbServer.getItem(this.cbServer.getSelectionIndex()));
        this.putPrefString("mpc/inter_ean", this.txtIntermediaerEAN.getText());
        this.storePrefs();
        String installDir = this.txtInstallDir.getText();
        if (installDir != null && installDir.length() > 0) {
            String configFilename = "";
            try {
                if (!("".equals(this.txtSenderEAN.getText()) && "".equals(this.txtSenderDN.getText()) && "".equals(this.cbServerIp.getText()))) {
                    this.props = MPCProperties.reload(installDir);
                    configFilename = this.props.getConfigFilenamePath();
                    this.props.put("mpcommunicator.sender.ean", this.txtSenderEAN.getText());
                    this.props.put("mediport.dn", this.txtSenderDN.getText());
                    String lblServerIp = this.cbServerIp.getText();
                    if (LBL_SERVER_URL_PRODUKTIV.equals(lblServerIp)) {
                        this.props.put("mpcommunicator.mediport.ip", "212.243.92.201");
                    } else if (LBL_SERVER_URL_TEST.equals(lblServerIp)) {
                        this.props.put("mpcommunicator.mediport.ip", "212.243.92.199");
                    } else {
                        this.props.put("mpcommunicator.mediport.ip", lblServerIp);
                    }
                    this.props.put("keystore.name", "config/EAN" + this.txtSenderEAN.getText() + "_mpg.keystore");
                    this.props.store();
                }
                this.installChanged = false;
            }
            catch (Exception e) {
                ExHandler.handle((Throwable)e);
                String msg = MessageFormat.format(Messages.MediportMainPrefPage_error_title_SaveConfig, configFilename);
                MessageDialog.openError((Shell)this.getShell(), (String)msg, (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.MediportMainPrefPage_message);
        this.setDescription(Messages.MediportMainPrefPage_description);
    }
}

