/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.mediport;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.medshare.awt.Desktop;
import ch.medshare.mediport.MediPortAbstractPrefPage;
import ch.medshare.mediport.Messages;
import ch.medshare.mediport.config.Client;
import ch.medshare.mediport.config.ClientParam;
import ch.medshare.mediport.config.MPCProperties;
import ch.medshare.mediport.util.MediPortHelper;
import ch.medshare.swt.widgets.DirectoryText;
import ch.medshare.swt.widgets.FileText;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;

public class MediportClientSetsPrefPage
extends MediPortAbstractPrefPage {
    String prefsKey;
    Combo cbMandant;
    Group clientComp;
    Combo cbMKey;
    Text txtSenderEan;
    Button cxWieMandant;
    DirectoryText txtSendDir;
    DirectoryText txtReceiveDir;
    DirectoryText txtReceiveTestDir;
    DirectoryText txtErrorDir;
    DirectoryText txtDocStatDir;
    FileText txtPartnerFile;
    Group paramComp;
    Combo cbNKey;
    Text txtName;
    DirectoryText txtClientDir;
    Combo cbDocAttr;
    Combo cbDocPrinted;
    Combo cbDistType;
    Combo cbPrintLanguage;
    Text txtTrustCenterEAN;
    Integer currentClientNum;
    Integer currentParamNum;
    Map<String, Mandant> mandantMap = new Hashtable<String, Mandant>();

    private Client mapClientValues(Client mappedClient) {
        if (mappedClient == null) {
            return null;
        }
        mappedClient.setEan(this.txtSenderEan.getText());
        mappedClient.setSend_dir(this.txtSendDir.getText());
        mappedClient.setReceive_dir(this.txtReceiveDir.getText());
        mappedClient.setReceivetest_dir(this.txtReceiveTestDir.getText());
        mappedClient.setError_dir(this.txtErrorDir.getText());
        mappedClient.setPartner_file(this.txtPartnerFile.getText());
        mappedClient.setDocstat_dir(this.txtDocStatDir.getText());
        return mappedClient;
    }

    private ClientParam mapParamValues(ClientParam mappedParam) {
        if (mappedParam == null) {
            return null;
        }
        mappedParam.setName(this.txtName.getText());
        mappedParam.setDir(this.txtClientDir.getText());
        String selDocAttr = this.cbDocAttr.getItem(this.cbDocAttr.getSelectionIndex());
        mappedParam.setDocattr(selDocAttr);
        String selDocPrinted = this.cbDocPrinted.getItem(this.cbDocPrinted.getSelectionIndex());
        if (LBL_DOC_PRINT_COPY.equals(selDocPrinted)) {
            mappedParam.setDocprinted("false");
        } else {
            mappedParam.setDocprinted("true");
        }
        String selDistType = this.cbDistType.getItem(this.cbDistType.getSelectionIndex());
        if (LBL_DIST_TYPE_A.equals(selDistType)) {
            mappedParam.setDisttype("1");
        } else {
            mappedParam.setDisttype("0");
        }
        String selLanguage = this.cbPrintLanguage.getItem(this.cbPrintLanguage.getSelectionIndex());
        if (LBL_LANGUAGE_F.equals(selLanguage)) {
            mappedParam.setPrintlanguage("F");
        } else if (LBL_LANGUAGE_I.equals(selLanguage)) {
            mappedParam.setPrintlanguage("I");
        } else {
            mappedParam.setPrintlanguage("D");
        }
        mappedParam.setTrustcenterean(this.txtTrustCenterEAN.getText());
        return mappedParam;
    }

    private Mandant getSelectedMandant() {
        return this.mandantMap.get(this.cbMandant.getText());
    }

    private Integer getSelectedNum(Combo cbKey) {
        Integer key = null;
        String keyStr = cbKey.getText();
        if (keyStr != null && keyStr.length() > 0 && !LBL_NEW_KEY.equals(keyStr)) {
            try {
                key = Integer.parseInt(cbKey.getText());
            }
            catch (NumberFormatException e) {
                Log.get((String)((Object)((Object)this)).getClass().getName()).log(e.getMessage(), 3);
            }
        }
        return key;
    }

    private Integer getSelectedClientNum() {
        return this.getSelectedNum(this.cbMKey);
    }

    private Integer getSelectedParamNum() {
        return this.getSelectedNum(this.cbNKey);
    }

    private void fillMKey(Integer clientNum) {
        String clientNumStr = null;
        if (clientNum != null) {
            Client client = this.props.getClient(clientNum);
            if (client != null) {
                clientNumStr = clientNum.toString();
            } else {
                clientNum = null;
            }
        }
        this.cbMKey.removeAll();
        this.cbMKey.add(LBL_NEW_KEY);
        for (String key : this.getFreeClientKeys(this.props, this.getSelectedMandant(), this.mandantMap.values())) {
            this.cbMKey.add(key);
            if (!key.equals(clientNumStr)) continue;
            clientNumStr = null;
        }
        if (clientNum != null) {
            if (clientNumStr != null) {
                this.cbMKey.add(clientNumStr);
            }
            this.cbMKey.setText(clientNum.toString());
        } else {
            this.cbMKey.setText(LBL_NEW_KEY);
        }
        this.currentClientNum = this.getSelectedClientNum();
    }

    private void fillNKey(Client client, Integer paramNum) {
        String paramNumStr = null;
        if (paramNum != null) {
            paramNumStr = paramNum.toString();
        }
        this.cbNKey.removeAll();
        this.cbNKey.add(LBL_NEW_KEY);
        if (client != null) {
            for (Integer key : client.getParamKeys()) {
                this.cbNKey.add(key.toString());
                if (!key.toString().equals(paramNumStr)) continue;
                paramNumStr = null;
            }
        }
        if (paramNum == null) {
            this.cbNKey.select(0);
        } else {
            if (paramNumStr != null) {
                this.cbNKey.add(paramNumStr);
            }
            this.cbNKey.setText(paramNum.toString());
        }
        this.currentParamNum = this.getSelectedParamNum();
    }

    private void fillClient(Mandant mandant, Integer clientNum) {
        Client client = this.props.getClient(clientNum);
        if (client == null) {
            client = new Client(this.getPrefString("mpc/install_dir"));
        }
        if ((client.getEan() == null || client.getEan().length() == 0) && mandant != null) {
            client.setEan(TarmedRequirements.getEAN((Kontakt)mandant));
        }
        this.fillMKey(clientNum);
        String mandantEan = TarmedRequirements.getEAN((Kontakt)mandant);
        String senderEan = client.getEan();
        if (senderEan == null && mandantEan != null) {
            senderEan = mandantEan;
        }
        this.txtSenderEan.setText(senderEan);
        this.cxWieMandant.setSelection(mandantEan == null && senderEan == null || senderEan != null && senderEan.equals(mandantEan));
        this.txtSenderEan.setEnabled(!this.cxWieMandant.getSelection());
        this.txtSendDir.setText(client.getSend_dir());
        this.txtReceiveDir.setText(client.getReceive_dir());
        this.txtReceiveTestDir.setText(client.getReceivetest_dir());
        this.txtErrorDir.setText(client.getError_dir());
        this.txtDocStatDir.setText(client.getDocstat_dir());
        this.txtPartnerFile.setText(client.getPartner_file());
        Integer firstParamKey = null;
        if (client.getParamKeys().size() > 0) {
            firstParamKey = client.getParamKeys().get(0);
        }
        this.fillParam(clientNum, firstParamKey);
    }

    private void fillParam(Integer clientNum, Integer paramNum) {
        Client client = this.props.getClient(clientNum);
        ClientParam param = new ClientParam(Messages.MediportClientSetsPrefPage_default_paramName);
        if (client != null && paramNum != null) {
            param = client.getParam(paramNum);
        }
        this.fillNKey(client, paramNum);
        this.txtName.setText(param.getName());
        this.txtClientDir.setText(param.getDir());
        this.cbDocAttr.setText(param.getDocattr());
        if ("true".equals(param.getDocprinted())) {
            this.cbDocPrinted.select(0);
        } else {
            this.cbDocPrinted.select(1);
        }
        if ("0".equals(param.getDisttype())) {
            this.cbDistType.select(0);
        } else {
            this.cbDistType.select(1);
        }
        if ("F".equals(param.getPrintlanguage())) {
            this.cbPrintLanguage.select(1);
        } else if ("I".equals(param.getPrintlanguage())) {
            this.cbPrintLanguage.select(2);
        } else {
            this.cbPrintLanguage.select(0);
        }
        this.txtTrustCenterEAN.setText(param.getTrustcenterean());
    }

    private void writeClient() {
        Integer clientNum = this.currentClientNum;
        Client client = null;
        if (clientNum != null) {
            client = this.props.getClient(clientNum);
        }
        if (client == null) {
            client = new Client(this.getPrefString("mpc/install_dir"));
            clientNum = this.props.addNewClient(client);
            this.fillMKey(clientNum);
        }
        this.mapClientValues(client);
        this.putPrefString(this.prefsKey, String.valueOf(clientNum));
        this.storePrefs();
    }

    private void writeParam() {
        Integer clientNum = this.currentClientNum;
        ClientParam param = new ClientParam("");
        if (clientNum != null) {
            Client client = this.props.getClient(clientNum);
            Integer paramNum = this.currentParamNum;
            if (paramNum != null) {
                param = client.getParam(paramNum);
            } else {
                paramNum = client.addNewParam(param);
                this.fillNKey(client, paramNum);
            }
        }
        this.mapParamValues(param);
    }

    private boolean storeParam() {
        this.writeParam();
        try {
            this.props.store();
        }
        catch (IOException ex) {
            ExHandler.handle((Throwable)ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MediportClientSetsPrefPage_error_title_saveConfig, (String)ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    protected boolean storeAll() {
        if (this.props != null) {
            this.writeClient();
            return this.storeParam();
        }
        return true;
    }

    private void clientChanged() {
        if (this.currentClientNum != null) {
            Client client = this.props.getClient(this.currentClientNum);
            if ((client = this.mapClientValues(client)) != null && client.hasChanged()) {
                this.storeAll();
            }
        }
        Integer clientNum = this.getSelectedClientNum();
        Mandant mandant = this.getSelectedMandant();
        this.prefsKey = MediPortHelper.getMandantPrefix(mandant.getLabel());
        String numString = this.getPrefString(this.prefsKey);
        if (numString != null && numString.length() > 0) {
            clientNum = Integer.parseInt(numString);
        }
        this.fillClient(mandant, clientNum);
    }

    private void mKeyChanged() {
        if (this.currentClientNum != null) {
            Client client = this.props.getClient(this.currentClientNum);
            if ((client = this.mapClientValues(client)) != null && client.hasChanged()) {
                this.storeAll();
            }
        }
        this.currentClientNum = this.getSelectedClientNum();
        this.fillClient(this.getSelectedMandant(), this.currentClientNum);
    }

    private void nKeyChanged() {
        Integer clientNum = this.getSelectedClientNum();
        if (clientNum != null && this.currentParamNum != null) {
            Client client = this.props.getClient(clientNum);
            ClientParam param = client.getParam(this.currentParamNum);
            if ((param = this.mapParamValues(param)) != null && param.hasChanged()) {
                this.storeAll();
            }
        }
        this.currentParamNum = this.getSelectedParamNum();
        this.fillParam(clientNum, this.currentParamNum);
    }

    private List<String> getFreeClientKeys(MPCProperties props, Mandant currentMandant, Collection<Mandant> mandanten) {
        Vector<String> allocatedKeyList = new Vector<String>();
        for (Mandant m : mandanten) {
            String key;
            if (m.equals((Object)currentMandant) || (key = this.getPrefString(MediPortHelper.getMandantPrefix(m.getLabel()))) == null || key.length() <= 0) continue;
            allocatedKeyList.add(key);
        }
        Vector<String> retList = new Vector<String>();
        for (Integer key : props.getClientKeys()) {
            String keyStr = key.toString();
            if (allocatedKeyList.contains(keyStr)) continue;
            retList.add(keyStr);
        }
        return retList;
    }

    protected Control createContents(Composite parent) {
        if (this.props != null) {
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)new GridLayout(2, false));
            this.cbMandant = new Combo(comp, 12);
            this.cbMandant.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.clientComp = new Group(comp, 0);
            this.clientComp.setText(Messages.MediportClientSetsPrefPage_lbl_title_config);
            this.clientComp.setLayout((Layout)new GridLayout(3, false));
            this.clientComp.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
            Label lblMKey = new Label((Composite)this.clientComp, 0);
            lblMKey.setText(Messages.MediportClientSetsPrefPage_lbl_mKey);
            this.cbMKey = new Combo((Composite)this.clientComp, 12);
            this.cbMKey.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
            Label lblEan = new Label((Composite)this.clientComp, 0);
            lblEan.setText(Messages.MediportClientSetsPrefPage_lbl_SenderEAN);
            this.txtSenderEan = new Text((Composite)this.clientComp, 2048);
            this.txtSenderEan.setEnabled(false);
            this.txtSenderEan.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.cxWieMandant = new Button((Composite)this.clientComp, 32);
            this.cxWieMandant.setText(Messages.MediportClientSetsPrefPage_lbl_WieMandant);
            Label lblSendDir = new Label((Composite)this.clientComp, 0);
            lblSendDir.setText(Messages.MediportClientSetsPrefPage_lbl_Sendeverzeichnis);
            this.txtSendDir = new DirectoryText((Composite)this.clientComp, 2048);
            this.txtSendDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblReceiveDir = new Label((Composite)this.clientComp, 0);
            lblReceiveDir.setText(Messages.MediportClientSetsPrefPage_lbl_Empfangsverzeichnis);
            this.txtReceiveDir = new DirectoryText((Composite)this.clientComp, 2048);
            this.txtReceiveDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblReceiveTestDir = new Label((Composite)this.clientComp, 0);
            lblReceiveTestDir.setText(Messages.MediportClientSetsPrefPage_lbl_EmpfangsverzeichnisTest);
            this.txtReceiveTestDir = new DirectoryText((Composite)this.clientComp, 2048);
            this.txtReceiveTestDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblErrorDir = new Label((Composite)this.clientComp, 0);
            lblErrorDir.setText(Messages.MediportClientSetsPrefPage_lbl_Fehlerverzeichnis);
            this.txtErrorDir = new DirectoryText((Composite)this.clientComp, 2048);
            this.txtErrorDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblDocStatDir = new Label((Composite)this.clientComp, 0);
            lblDocStatDir.setText(Messages.MediportClientSetsPrefPage_lbl_DokumentstatusVerzeichnis);
            this.txtDocStatDir = new DirectoryText((Composite)this.clientComp, 2048);
            this.txtDocStatDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblPartnerFile = new Label((Composite)this.clientComp, 0);
            lblPartnerFile.setText(Messages.MediportClientSetsPrefPage_lbl_Partnerfile);
            this.txtPartnerFile = new FileText((Composite)this.clientComp, 2048);
            this.txtPartnerFile.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Button btnPartnerFile = new Button((Composite)this.clientComp, 8);
            btnPartnerFile.setText(Messages.MediportClientSetsPrefPage_btn_PartnerinfoAnzeigen);
            btnPartnerFile.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            this.paramComp = new Group((Composite)this.clientComp, 0);
            this.paramComp.setText(Messages.MediportClientSetsPrefPage_lbl_title_Parameter);
            this.paramComp.setLayout((Layout)new GridLayout(3, false));
            this.paramComp.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)true));
            Label lblNKey = new Label((Composite)this.paramComp, 0);
            lblNKey.setText(Messages.MediportClientSetsPrefPage_lbl_nKey);
            this.cbNKey = new Combo((Composite)this.paramComp, 12);
            this.cbNKey.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)false, (int)1, (boolean)false));
            Label lblParam = new Label((Composite)this.paramComp, 0);
            lblParam.setText(Messages.MediportClientSetsPrefPage_lbl_Bezeichnung);
            this.txtName = new Text((Composite)this.paramComp, 2048);
            this.txtName.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lblClientDir = new Label((Composite)this.paramComp, 0);
            lblClientDir.setText(Messages.MediportClientSetsPrefPage_lbl_Ausgabeverzeichnis);
            this.txtClientDir = new DirectoryText((Composite)this.paramComp, 2048);
            this.txtClientDir.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Label lblDocAttr = new Label((Composite)this.paramComp, 0);
            lblDocAttr.setText(Messages.MediportClientSetsPrefPage_lbl_Workflow);
            this.cbDocAttr = new Combo((Composite)this.paramComp, 2056);
            this.cbDocAttr.add("Tiers_Payant");
            this.cbDocAttr.add("Tiers_Garant_Manuell");
            this.cbDocAttr.add("Tiers_Garant_Direct");
            this.cbDocAttr.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lblDocPrinted = new Label((Composite)this.paramComp, 0);
            lblDocPrinted.setText(Messages.MediportClientSetsPrefPage_lbl_Rechnungskopie);
            this.cbDocPrinted = new Combo((Composite)this.paramComp, 2056);
            this.cbDocPrinted.add(LBL_DOC_NO_PRINT);
            this.cbDocPrinted.add(LBL_DOC_PRINT_COPY);
            this.cbDocPrinted.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lblDistType = new Label((Composite)this.paramComp, 0);
            lblDistType.setText(Messages.MediportClientSetsPrefPage_lbl_Versandart);
            this.cbDistType = new Combo((Composite)this.paramComp, 2056);
            this.cbDistType.add(LBL_DIST_TYPE_B);
            this.cbDistType.add(LBL_DIST_TYPE_A);
            this.cbDistType.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lblPrintLanguage = new Label((Composite)this.paramComp, 0);
            lblPrintLanguage.setText(Messages.MediportClientSetsPrefPage_lbl_Drucksprache);
            this.cbPrintLanguage = new Combo((Composite)this.paramComp, 2056);
            this.cbPrintLanguage.add(LBL_LANGUAGE_D);
            this.cbPrintLanguage.add(LBL_LANGUAGE_F);
            this.cbPrintLanguage.add(LBL_LANGUAGE_I);
            this.cbPrintLanguage.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            Label lblTrustEan = new Label((Composite)this.paramComp, 0);
            lblTrustEan.setText(Messages.MediportClientSetsPrefPage_lbl_TrustcenterEAN);
            this.txtTrustCenterEAN = new Text((Composite)this.paramComp, 2048);
            this.txtTrustCenterEAN.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
            this.cbMandant.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediportClientSetsPrefPage.this.clientChanged();
                }
            });
            this.cbMKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediportClientSetsPrefPage.this.mKeyChanged();
                }
            });
            this.cxWieMandant.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediportClientSetsPrefPage.this.txtSenderEan.setEnabled(!MediportClientSetsPrefPage.this.cxWieMandant.getSelection());
                    MediportClientSetsPrefPage.this.txtSenderEan.setText(TarmedRequirements.getEAN((Kontakt)MediportClientSetsPrefPage.this.getSelectedMandant()));
                }
            });
            this.cbNKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MediportClientSetsPrefPage.this.nKeyChanged();
                }
            });
            btnPartnerFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        File partnerFile = new File(MediportClientSetsPrefPage.this.txtPartnerFile.getText());
                        Desktop.open(partnerFile);
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        MessageDialog.openError((Shell)MediportClientSetsPrefPage.this.getShell(), (String)Messages.MediportClientSetsPrefPage_error_msg_PartnerdateiOeffnen, (String)ex.getMessage());
                    }
                }
            });
            Query qbe = new Query(Mandant.class);
            List list = qbe.execute();
            for (Mandant m : list) {
                this.cbMandant.add(m.getLabel());
                this.mandantMap.put(m.getLabel(), m);
            }
            String actMandantLabel = CoreHub.actMandant.getLabel();
            this.cbMandant.setText(actMandantLabel);
            this.cxWieMandant.setSelection(true);
            this.cbDocAttr.select(0);
            this.cbDocPrinted.select(0);
            this.cbDistType.select(0);
            String defaultLang = Locale.getDefault().getLanguage();
            if (Locale.FRENCH.getLanguage().equals(defaultLang)) {
                this.cbPrintLanguage.select(1);
            } else if (Locale.ITALIAN.getLanguage().equals(defaultLang)) {
                this.cbPrintLanguage.select(2);
            } else {
                this.cbPrintLanguage.select(0);
            }
            this.clientChanged();
            return comp;
        }
        Composite form = new Composite(parent, 0);
        form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        form.setLayout((Layout)new FillLayout());
        new Label(form, 64).setText(Messages.MediportClientSetsPrefPage_error_msg_missingConfiguration);
        return form;
    }

    @Override
    protected void showReloadInfo() {
        if (this.props != null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.MediportClientSetsPrefPage_info_title_MediPortCommunicator, (String)(String.valueOf(Messages.MediportClientSetsPrefPage_info_reloadInfo1) + Messages.MediportClientSetsPrefPage_info_reloadInfo2));
        }
    }

    public void init(IWorkbench workbench) {
        this.setMessage(Messages.MediportClientSetsPrefPage_message);
    }
}

