/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.util;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class UtilXml {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public static List<String> validateSchema(String xmlDocumentUrl) {
        return UtilXml.validateSchema(null, xmlDocumentUrl);
    }

    public static List<String> validateSchema(String schemaUrl, String xmlDocumentUrl) {
        MyErrorHandler errorHandler = new MyErrorHandler();
        try {
            SchemaFactory factory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            Schema schema = factory.newSchema();
            if (schemaUrl != null) {
                File schemaLocation = new File(schemaUrl);
                schema = factory.newSchema(schemaLocation);
            }
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(xmlDocumentUrl);
            validator.setErrorHandler(errorHandler);
            validator.validate(source);
        }
        catch (Exception ex) {
            errorHandler.exception(ex);
        }
        return errorHandler.getMessageList();
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        public List<Exception> exceptions = new Vector<Exception>();

        private MyErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exceptions.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        public void exception(Exception exception) {
            this.exceptions.add(exception);
        }

        public List<String> getMessageList() {
            Vector<String> messageList = new Vector<String>();
            for (Exception ex : this.exceptions) {
                String msg = ex.getMessage();
                if (msg == null || msg.length() == 0) {
                    msg = ex.toString();
                }
                messageList.add(msg);
            }
            return messageList;
        }
    }
}

