/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class UtilSecurity {
    public static Charset CHARSET = Charset.forName("UTF-8");

    private static String getProvider() {
        Provider prov = Security.getProvider("BC");
        if (prov == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        return "BC";
    }

    public static String toMD5(String input) throws NoSuchAlgorithmException, NoSuchProviderException, UnsupportedEncodingException {
        MessageDigest md = null;
        byte[] byteHash = null;
        StringBuffer resultString = new StringBuffer();
        md = MessageDigest.getInstance("MD5", UtilSecurity.getProvider());
        md.reset();
        md.update(input.getBytes(CHARSET.name()));
        byteHash = md.digest();
        int i = 0;
        while (i < byteHash.length) {
            resultString.append(Integer.toHexString(0xFF & byteHash[i]));
            ++i;
        }
        return resultString.toString();
    }

    public static KeyPair getNewAsymmetricKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", UtilSecurity.getProvider());
        keyGen.initialize(2048);
        return keyGen.genKeyPair();
    }

    public static SecretKey getNewSymmetricKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyGenerator.getInstance("DES", UtilSecurity.getProvider()).generateKey();
    }

    public static byte[] encryptAsym(String input, Key key) throws GeneralSecurityException, IOException, ClassNotFoundException {
        Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING", UtilSecurity.getProvider());
        cipher.init(1, key);
        return cipher.doFinal(input.getBytes(CHARSET.name()));
    }

    public static String decryptAsym(byte[] input, Key key) throws GeneralSecurityException, IOException, ClassNotFoundException {
        Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1PADDING", UtilSecurity.getProvider());
        cipher.init(2, key);
        return new String(cipher.doFinal(input), CHARSET.name());
    }

    public static byte[] encryptSym(String input, SecretKey key) throws GeneralSecurityException, IOException, ClassNotFoundException {
        Cipher cipher = Cipher.getInstance("DES", UtilSecurity.getProvider());
        cipher.init(1, key);
        return cipher.doFinal(input.getBytes(CHARSET.name()));
    }

    public static String decryptSym(byte[] input, SecretKey key) throws GeneralSecurityException, IOException, ClassNotFoundException {
        Cipher cipher = Cipher.getInstance("DES", UtilSecurity.getProvider());
        cipher.init(2, key);
        return new String(cipher.doFinal(input), CHARSET.name());
    }
}

