/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.util;

import ch.medshare.util.Messages;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.zip.GZIPInputStream;

public class UtilFile {
    public static String DIRECTORY_SEPARATOR = File.separator;
    public static final String ZIP_EXTENSION = ".gz";

    private static String getCorrectSeparators(String pathOrFilename) {
        return pathOrFilename.replace("\\", DIRECTORY_SEPARATOR).replace("//", DIRECTORY_SEPARATOR).replace("/", DIRECTORY_SEPARATOR);
    }

    private static String removeMultipleSeparators(String pathOrFilename) {
        String doubleSeparator = String.valueOf(DIRECTORY_SEPARATOR) + DIRECTORY_SEPARATOR;
        if (pathOrFilename.indexOf(doubleSeparator) >= 0) {
            pathOrFilename = pathOrFilename.replace(doubleSeparator, DIRECTORY_SEPARATOR);
        }
        return pathOrFilename;
    }

    public static String getCorrectPath(String path) throws IllegalArgumentException {
        if (path == null) {
            return "";
        }
        path = UtilFile.getCorrectSeparators(path);
        if (!(path = UtilFile.removeMultipleSeparators(path)).endsWith(DIRECTORY_SEPARATOR)) {
            path = String.valueOf(path) + DIRECTORY_SEPARATOR;
        }
        return path;
    }

    public static boolean doesFileExist(String filePathName) {
        File file = new File(filePathName);
        return file.isFile() && file.exists();
    }

    public static boolean isRootDir(String dir) {
        return dir.startsWith(DIRECTORY_SEPARATOR) || dir.indexOf(":") > 0;
    }

    public static boolean deleteFile(String filePathName) throws IllegalArgumentException {
        if (UtilFile.doesFileExist(filePathName)) {
            File file = new File(filePathName);
            return file.delete();
        }
        return true;
    }

    public static Object readObject(String fileNamePath) throws IOException, ClassNotFoundException {
        FileInputStream fis = null;
        try (ObjectInputStream in = null;){
            fis = new FileInputStream(fileNamePath);
            in = new ObjectInputStream(fis);
            Object object = in.readObject();
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readZippedFile(String filenamePath) throws IOException {
        byte[] daten = new byte[1024];
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                byte[] byArray;
                block16: {
                    GZIPInputStream in = new GZIPInputStream(new FileInputStream(filenamePath));
                    try {
                        int read = 0;
                        while (true) {
                            if ((read = in.read(daten, 0, 1024)) == -1) {
                                byArray = out.toByteArray();
                                return byArray;
                            }
                            out.write(daten, 0, read);
                        }
                    }
                    finally {
                        if (in == null) break block16;
                        in.close();
                    }
                }
                if (out != null) {
                    out.close();
                }
                return byArray;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static byte[] readFile(String fileNamePath) throws IOException {
        byte[] daten = null;
        try (FileInputStream input = null;){
            input = new FileInputStream(fileNamePath);
            daten = new byte[input.available()];
            input.read(daten);
        }
        return daten;
    }

    public static String readTextFile(String fileNamePath) throws IOException {
        return UtilFile.readTextFile(fileNamePath, Charset.defaultCharset().name());
    }

    public static String readTextFile(String fileNamePath, String charsetName) throws IOException {
        byte[] text = UtilFile.readFile(fileNamePath);
        return new String(text, charsetName);
    }

    public static void writeObject(String fileNamePath, Object obj) throws IOException {
        FileOutputStream fos = null;
        try (ObjectOutputStream out = null;){
            fos = new FileOutputStream(fileNamePath);
            out = new ObjectOutputStream(fos);
            out.writeObject(obj);
        }
    }

    public static void writeFile(String fileNamePath, byte[] daten) throws IOException {
        try (FileOutputStream output = null;){
            output = new FileOutputStream(fileNamePath);
            output.write(daten);
        }
    }

    public static void writeTextFile(String fileNamePath, String text) throws IOException {
        if (text != null) {
            try (BufferedWriter bw = null;){
                bw = new BufferedWriter(new FileWriter(fileNamePath));
                bw.write(text);
            }
        }
    }

    public static void copyFile(String from, String to) throws IOException {
        byte[] daten = UtilFile.readFile(from);
        UtilFile.writeFile(to, daten);
    }

    public static boolean moveFile(String from, String to) throws IOException {
        byte[] daten = UtilFile.readFile(from);
        UtilFile.writeFile(to, daten);
        return UtilFile.deleteFile(from);
    }

    public static String getFilepath(String filenamePath) {
        String correctFilenamePath = UtilFile.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return "";
        }
        return correctFilenamePath.substring(0, correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR));
    }

    public static String getFilename(String filenamePath) {
        String correctFilenamePath = UtilFile.getCorrectSeparators(filenamePath);
        if (correctFilenamePath.indexOf(DIRECTORY_SEPARATOR) < 0) {
            return filenamePath;
        }
        return correctFilenamePath.substring(correctFilenamePath.lastIndexOf(DIRECTORY_SEPARATOR) + 1, correctFilenamePath.length());
    }

    public static String getNakedFilename(String filenamePath) {
        String filename = UtilFile.getFilename(filenamePath);
        if (filename.lastIndexOf(".") > 0) {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }

    public static String getFileExtension(String filenamePath) {
        String filename = UtilFile.getFilename(filenamePath);
        if (filename.lastIndexOf(".") > 0) {
            return filename.substring(filename.lastIndexOf("."), filename.length());
        }
        return "";
    }

    public static String concatenatePath(String sPart1, String sPart2) {
        if (sPart1 == null || sPart2 == null) {
            System.err.println("cannot concatenate nulls, part1: " + sPart1 + " part2: " + sPart2);
            return null;
        }
        if (!sPart1.endsWith(DIRECTORY_SEPARATOR)) {
            sPart1 = String.valueOf(sPart1) + DIRECTORY_SEPARATOR;
        }
        if (sPart2.startsWith(DIRECTORY_SEPARATOR)) {
            sPart2 = sPart2.substring(1);
        }
        return String.valueOf(sPart1) + sPart2;
    }

    public static String concatenatePaths(String[] parts) {
        StringBuilder sb = new StringBuilder();
        if (parts != null) {
            int i = 0;
            while (i < parts.length) {
                String sPart = parts[i];
                if (!sPart.endsWith(DIRECTORY_SEPARATOR) && i != parts.length - 1) {
                    sPart = String.valueOf(sPart) + DIRECTORY_SEPARATOR;
                }
                sb.append(sPart);
                ++i;
            }
        }
        return sb.toString();
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    UtilFile.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    public static void checkCreatePath(String path) throws IllegalArgumentException {
        File dir = new File(path);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException(Messages.UtilFile_error_msg_invalidPath, null);
            }
        } else if (!dir.mkdirs()) {
            String msg = MessageFormat.format(Messages.UtilFile_error_msg_creationFailed, path);
            throw new IllegalArgumentException(msg, null);
        }
    }
}

