/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.swt.widgets;

import ch.medshare.swt.widgets.AbstractBrowseText;
import ch.medshare.util.UtilMisc;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileText
extends AbstractBrowseText {
    private String[] extensions = new String[0];

    public FileText(Composite parent, int style) {
        super(parent, style);
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    private static File getFile(Shell shell, String[] extensions, File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(shell, 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if (extensions != null) {
            dialog.setFilterExtensions(extensions);
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    @Override
    protected SelectionAdapter getBrowseSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File d;
                File f = new File(FileText.this.getText());
                if (!f.exists()) {
                    f = null;
                }
                if ((d = FileText.getFile(FileText.this.getShell(), FileText.this.extensions, f)) != null) {
                    FileText.this.setText(UtilMisc.replaceWithForwardSlash(d.getAbsolutePath()));
                    FileText.this.setFocus();
                }
            }
        };
    }
}

