/*
 * Decompiled with CFR 0.152.
 */
package ch.medshare.swt.widgets;

import ch.medshare.swt.widgets.AbstractBrowseText;
import ch.medshare.util.UtilMisc;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;

public class DirectoryText
extends AbstractBrowseText {
    public DirectoryText(Composite parent, int style) {
        super(parent, style);
    }

    private static File getDirectory(Shell shell, File startingDirectory) {
        String dir;
        DirectoryDialog fileDialog = new DirectoryDialog(shell, 4096);
        if (startingDirectory != null) {
            fileDialog.setFilterPath(startingDirectory.getPath());
        }
        if ((dir = fileDialog.open()) != null && (dir = dir.trim()).length() > 0) {
            return new File(dir);
        }
        return null;
    }

    @Override
    protected SelectionAdapter getBrowseSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File d;
                File f = new File(DirectoryText.this.getText());
                if (!f.exists()) {
                    f = null;
                }
                if ((d = DirectoryText.getDirectory(DirectoryText.this.getShell(), f)) != null) {
                    DirectoryText.this.setText(UtilMisc.replaceWithForwardSlash(d.getAbsolutePath()));
                    DirectoryText.this.setFocus();
                }
            }
        };
    }
}

