/*
 * Decompiled with CFR 0.152.
 */
package ch.itmed.lmz.risch.laborder.ui.preferences;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.itmed.lmz.risch.laborder.preferences.PreferenceConstants;
import ch.rgw.io.Settings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class RiboxPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Settings settingsProvider = CoreHub.userCfg;
    private Combo settingsProviderCombo;
    private Text clientCertPath;
    private Text certPassword;
    private Text riboxIP;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        this.settingsProvider = CoreHub.mandantCfg;
        Label description = new Label(composite, 0);
        description.setText("Spezifizieren Sie die Einstellungen f\u00fcr das Login am LabOrder Portal.");
        description.setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        new Label(composite, 258).setLayoutData((Object)SWTHelper.getFillGridData((int)4, (boolean)true, (int)1, (boolean)false));
        new Label(composite, 0).setText("Einstellungen f\u00fcr:");
        String[] comboItems = new String[]{"aktueller Benutzer", "aktueller Mandant", "Global"};
        this.settingsProviderCombo = new Combo(composite, 8);
        this.settingsProviderCombo.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.settingsProviderCombo.setItems(comboItems);
        this.settingsProviderCombo.select(this.setComboSelection(this.settingsProviderCombo, comboItems, CoreHub.localCfg.get(PreferenceConstants.SETTINGS_PROVIDER, "aktueller Benutzer")));
        this.settingsProviderCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RiboxPreferences.this.setSettingsProvider();
                RiboxPreferences.this.updateFields();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setSettingsProvider();
        new Label(composite, 0).setText("Client Zertifikat:");
        new Label(composite, 0);
        new Label(composite, 0);
        new Label(composite, 0);
        this.clientCertPath = new Text(composite, 2048);
        this.clientCertPath.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        this.clientCertPath.setText(this.settingsProvider.get(PreferenceConstants.CLIENT_CERTIFICATE, ""));
        Button clientCertFileDialog = new Button(composite, 8);
        clientCertFileDialog.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        clientCertFileDialog.setText("Client Zertifikat Datei w\u00e4hlen");
        clientCertFileDialog.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(RiboxPreferences.this.getShell(), 8192);
                dialog.setFilterNames(new String[]{"Client Zertifikat", "Alle Dateien (*.*)"});
                dialog.setFilterExtensions(new String[]{"*.p12", "*.*"});
                String certPath = dialog.open();
                if (certPath != null) {
                    RiboxPreferences.this.clientCertPath.setText(certPath);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        new Label(composite, 0).setText("Privater Schl\u00fcssel:");
        this.certPassword = new Text(composite, 0x400800);
        this.certPassword.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.certPassword.setText(this.settingsProvider.get(PreferenceConstants.CERTIFICATE_PASSWORD, ""));
        new Label(composite, 0).setText("Ribox IP/DNS:");
        this.riboxIP = new Text(composite, 2048);
        this.riboxIP.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.riboxIP.setText(this.settingsProvider.get(PreferenceConstants.RIBOX_IP, ""));
        return composite;
    }

    public boolean performOk() {
        CoreHub.localCfg.set(PreferenceConstants.SETTINGS_PROVIDER, this.settingsProviderCombo.getText());
        this.settingsProvider.set(PreferenceConstants.CLIENT_CERTIFICATE, this.clientCertPath.getText());
        this.settingsProvider.set(PreferenceConstants.CERTIFICATE_PASSWORD, this.certPassword.getText());
        this.settingsProvider.set(PreferenceConstants.RIBOX_IP, this.riboxIP.getText());
        return super.performOk();
    }

    private void updateFields() {
        this.clientCertPath.setText(this.settingsProvider.get(PreferenceConstants.CLIENT_CERTIFICATE, ""));
        this.certPassword.setText(this.settingsProvider.get(PreferenceConstants.CERTIFICATE_PASSWORD, ""));
        this.riboxIP.setText(this.settingsProvider.get(PreferenceConstants.RIBOX_IP, ""));
    }

    public int setComboSelection(Combo combo, String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void setSettingsProvider() {
        if (this.settingsProviderCombo.getText().equals("aktueller Benutzer")) {
            this.settingsProvider.flush();
            this.settingsProvider = CoreHub.userCfg;
        } else if (this.settingsProviderCombo.getText().equals("aktueller Mandant")) {
            this.settingsProvider.flush();
            this.settingsProvider = CoreHub.mandantCfg;
        } else if (this.settingsProviderCombo.getText().equals("Global")) {
            this.settingsProvider.flush();
            this.settingsProvider = CoreHub.globalCfg;
        }
    }
}

