/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.stickynotes.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.stickynotes.Messages;
import ch.elexis.stickynotes.data.StickyNote;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class StickyNotesView
extends ViewPart
implements IActivationListener,
Heartbeat.HeartListener {
    private ScrolledForm form;
    EnhancedTextField etf;
    Patient actPatient;
    StickyNote actNote;
    SettingsPreferenceStore prefs;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            if (ev.getType() == 16) {
                StickyNotesView.this.doSelect((Patient)ev.getObject());
            } else if (ev.getType() == 32) {
                StickyNotesView.this.deselect();
            }
        }
    };
    private final ElexisEventListenerImpl eeli_user = new ElexisEventListenerImpl(Anwender.class, 64){

        public void catchElexisEvent(ElexisEvent ev) {
            StickyNotesView.this.prefs = new SettingsPreferenceStore(CoreHub.userCfg);
        }
    };

    public void createPartControl(Composite parent) {
        this.prefs = new SettingsPreferenceStore(CoreHub.userCfg);
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.etf = new EnhancedTextField(body);
        this.etf.connectGlobalActions(this.getViewSite());
        this.etf.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
        this.etf.setFocus();
    }

    public void activation(boolean mode) {
        if (!mode && this.etf.isDirty() && this.actPatient != null) {
            if (this.actNote == null) {
                this.actNote = StickyNote.load(this.actPatient);
            }
            this.actNote.setText(this.etf.getContentsAsXML());
        }
    }

    public void visible(boolean mode) {
        if (mode) {
            this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
            this.eeli_user.catchElexisEvent(ElexisEvent.createUserEvent());
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    private void deselect() {
        this.actNote = null;
        this.actPatient = null;
        this.etf.setText("");
        this.setPartName(Messages.StickyNotesView_StickyNotesName);
    }

    private void doSelect(Patient pat) {
        if (pat == null) {
            this.deselect();
        } else {
            this.actPatient = pat;
            this.actNote = StickyNote.load(this.actPatient);
            this.etf.setText(this.actNote.getText());
            this.setPartName(String.valueOf(Messages.StickyNotesView_StickyNotesNameDash) + this.actPatient.getLabel());
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.prefs, (String)"sticky_notes/col_background");
            UiDesk.getColorRegistry().put("sticky_notes/col_background", rgb);
            Color back = UiDesk.getColorRegistry().get("sticky_notes/col_background");
            rgb = PreferenceConverter.getColor((IPreferenceStore)this.prefs, (String)"sticky_notes/col_foreground");
            UiDesk.getColorRegistry().put("sticky_notes/col_foreground", rgb);
            Color fore = UiDesk.getColorRegistry().get("sticky_notes/col_foreground");
            this.etf.getControl().setBackground(back);
            this.etf.getControl().setForeground(fore);
        }
    }

    public void heartbeat() {
        if (this.actPatient == null) {
            this.actPatient = ElexisEventDispatcher.getSelectedPatient();
        }
        if (this.actPatient != null && this.actNote == null) {
            this.actNote = StickyNote.load(this.actPatient);
        }
    }
}

