/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.stickynotes.data;

import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.StringTool;

public class StickyNote
extends PersistentObject {
    private static final String TABLENAME = "CH_ELEXIS_STICKYNOTES";
    public static final String VERSION = "1.0.0";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_STICKYNOTES (ID\t\tVARCHAR(25) primary key,lastupdate\tBIGINT,deleted\tCHAR(1) default '0',PatientID\tVARCHAR(25),contents\tBLOB);INSERT INTO CH_ELEXIS_STICKYNOTES (ID,PatientID) VALUES('VERSION','1.0.0');CREATE INDEX CH_ELEXIS_STICKYNOTES1 ON CH_ELEXIS_STICKYNOTES (PatientID);";

    static {
        StickyNote.addMapping((String)TABLENAME, (String[])new String[]{"PatientID", "text=S:C:contents"});
        StickyNote note = StickyNote.load("VERSION");
        if (!note.exists()) {
            StickyNote.createOrModifyTable((String)createDB);
        }
    }

    public StickyNote(Patient p) {
        this.create(null);
        this.set("PatientID", p.getId());
    }

    public Patient getPatient() {
        Patient pat = Patient.load((String)StickyNote.checkNull((Object)this.get("PatientID")));
        if (!pat.exists()) {
            return null;
        }
        return pat;
    }

    public void setText(String t) {
        this.set("text", t);
    }

    public String getText() {
        return StickyNote.checkNull((Object)this.get("text"));
    }

    public String getLabel() {
        Patient p = this.getPatient();
        if (p == null) {
            return "??";
        }
        return String.valueOf(p.getLabel()) + ":" + StringTool.limitLength((String)this.getText(), (int)25);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static StickyNote load(Patient p) {
        StickyNote ret;
        String id = new Query(StickyNote.class).findSingle("PatientID", "=", p.getId());
        if (id != null && (ret = StickyNote.load(id)).exists()) {
            return ret;
        }
        return new StickyNote(p);
    }

    public static StickyNote load(String id) {
        return new StickyNote(id);
    }

    protected StickyNote() {
    }

    protected StickyNote(String id) {
        super(id);
    }
}

