/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.privatrechnung.rechnung;

import ch.elexis.base.ch.ebanking.esr.ESR;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.elexis.privatrechnung.rechnung.PrivaterechnungTextTemplateRequirement;
import ch.rgw.tools.Money;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class RnPrintView
extends ViewPart {
    public static final String VAT_ISMANDANTVAT = "at.medevit.medelexis.vat_ch/IsMandantVat";
    public static final String VAT_MANDANTVATNUMBER = "at.medevit.medelexis.vat_ch/MandantVatNumber";
    private static NumberFormat nf = NumberFormat.getInstance(Locale.getDefault());
    static final String ID = "ch.elexis.privatrechnung.view";
    TextContainer tc;
    Fall fall;

    public void createPartControl(Composite parent) {
        this.tc = new TextContainer(parent.getShell());
        this.tc.getPlugin().createContainer(parent, new ITextPlugin.ICallback(){

            public void save() {
            }

            public boolean saveAs() {
                return false;
            }
        });
    }

    public void setFocus() {
    }

    public Result<Rechnung> doPrint(Rechnung rn) {
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(2);
        Result ret = new Result();
        this.fall = rn.getFall();
        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)this.fall);
        Kontakt adressat = this.fall.getGarant();
        if (!adressat.isValid()) {
            adressat = this.fall.getPatient();
        }
        this.tc.createFromTemplateName(null, PrivaterechnungTextTemplateRequirement.getBillTemplate(), "Rechnung", adressat, rn.getNr());
        this.fillFields();
        List kons = rn.getKonsultationen();
        Collections.sort(kons, new Comparator<Konsultation>(){
            TimeTool t0 = new TimeTool();
            TimeTool t1 = new TimeTool();

            @Override
            public int compare(Konsultation arg0, Konsultation arg1) {
                this.t0.set(arg0.getDatum());
                this.t1.set(arg1.getDatum());
                return this.t0.compareTo((Calendar)this.t1);
            }
        });
        Object pos = null;
        pos = this.tc.getPlugin().insertText("[Leistungen]", "", 16384);
        Money sum = new Money();
        VatRateSum vatSummer = new VatRateSum();
        for (Konsultation k : kons) {
            this.tc.getPlugin().setStyle(1);
            pos = this.tc.getPlugin().insertText(pos, String.valueOf(new TimeTool(k.getDatum()).toString(4)) + "\n", 16384);
            this.tc.getPlugin().setStyle(0);
            StringBuilder header = new StringBuilder();
            header.append("Anzahl").append("\t").append("MWSt.").append("\t").append("Einzelpreis").append("\t").append("Betrag").append("\n\n");
            pos = this.tc.getPlugin().insertText(pos, header.toString(), 16384);
            for (Verrechnet vv : k.getLeistungen()) {
                this.tc.getPlugin().setStyle(1);
                pos = this.tc.getPlugin().insertText(pos, "- " + vv.getText() + "\n", 16384);
                this.tc.getPlugin().setStyle(0);
                Money preis = vv.getNettoPreis();
                int zahl = vv.getZahl();
                Money subtotal = new Money(preis);
                subtotal.multiply((double)zahl);
                StringBuilder sb = new StringBuilder();
                sb.append(zahl).append("\t").append(this.getVatRate(vv, subtotal, vatSummer)).append("\t").append(preis.getAmountAsString()).append("\t").append(subtotal.getAmountAsString()).append("\n");
                pos = this.tc.getPlugin().insertText(pos, sb.toString(), 16384);
                sum.addMoney(subtotal);
            }
        }
        pos = this.tc.getPlugin().insertText(pos, "____________________________________________________________________\nTotal:\t\t\t" + sum.getAmountAsString(), 16384);
        String vatNumber = rn.getMandant().getRechnungssteller().getInfoString(VAT_MANDANTVATNUMBER);
        this.tc.getPlugin().setStyle(1);
        pos = this.tc.getPlugin().insertText(pos, "\n\nMWSt.Nr. \t", 16384);
        this.tc.getPlugin().setStyle(0);
        pos = vatNumber != null && vatNumber.length() > 0 ? this.tc.getPlugin().insertText(pos, String.valueOf(vatNumber) + "\n", 16384) : this.tc.getPlugin().insertText(pos, "keine\n", 16384);
        this.tc.getPlugin().setStyle(1);
        pos = this.tc.getPlugin().insertText(pos, "\nSatz\tBetrag\tMWSt\n", 16384);
        this.tc.getPlugin().setStyle(0);
        Object[] vatValues = vatSummer.rates.values().toArray(new VatRateSum.VatRateElement[0]);
        Arrays.sort(vatValues);
        Object[] objectArray = vatValues;
        int n = vatValues.length;
        int vv = 0;
        while (vv < n) {
            Object rate = objectArray[vv];
            StringBuilder sb = new StringBuilder();
            sb.append(nf.format(((VatRateSum.VatRateElement)rate).scale)).append("\t").append(nf.format(((VatRateSum.VatRateElement)rate).sumamount)).append("\t").append(nf.format(((VatRateSum.VatRateElement)rate).sumvat)).append("\n");
            pos = this.tc.getPlugin().insertText(pos, sb.toString(), 16384);
            ++vv;
        }
        this.tc.getPlugin().setStyle(1);
        pos = this.tc.getPlugin().insertText(pos, "\nTotal\t" + sum.getAmountAsString() + "\t" + nf.format(vatSummer.sumvat) + "\n", 16384);
        this.tc.getPlugin().setStyle(0);
        String toPrinter = CoreHub.localCfg.get("Drucker/A4/Name", null);
        this.tc.getPlugin().print(toPrinter, null, false);
        this.tc.createFromTemplateName(null, PrivaterechnungTextTemplateRequirement.getESRTemplate(), "Rechnung", adressat, rn.getNr());
        this.fillFields();
        ESR esr = new ESR(CoreHub.globalCfg.get("privatrechnung_basic/esrIdentity", ""), CoreHub.globalCfg.get("privatrechnung_basic/esrUser", ""), rn.getRnId(), 27);
        Kontakt bank = Kontakt.load((String)CoreHub.globalCfg.get("privatrechnung_basic/bank", ""));
        if (!bank.isValid()) {
            SWTHelper.showError((String)"Keine Bank", (String)"Bitte geben Sie eine Bank f\u00fcr die Zahlungen ein");
        }
        esr.printBESR(bank, adressat, (Kontakt)rn.getMandant(), sum.getCentsAsString(), this.tc);
        this.tc.replace("\\[Leistungen\\]", sum.getAmountAsString());
        this.tc.getPlugin().print(CoreHub.localCfg.get("Drucker/A4ESR/Name", null), null, false);
        this.tc.getPlugin().setFont(null, 0, 0.0f);
        return ret;
    }

    private void fillFields() {
        Kontakt versicherung = Kontakt.load((String)this.fall.getInfoString("Versicherung"));
        if (versicherung.isValid()) {
            this.tc.replace("\\?\\?Versicherung\\.Name\\?\\?]", versicherung.getLabel());
            this.tc.replace("\\?\\?Versicherung\\.Anschrift\\?\\?", versicherung.getPostAnschrift(true));
        }
    }

    private String getVatRate(Verrechnet verrechnet, Money amount, VatRateSum vatsum) {
        String vatScale;
        Boolean isVat = (Boolean)verrechnet.getKons().getMandant().getRechnungssteller().getInfoElement(VAT_ISMANDANTVAT);
        double value = 0.0;
        if (isVat != null && isVat.booleanValue() && (vatScale = verrechnet.getDetail("vat_scale")) != null && vatScale.length() > 0) {
            value = Double.parseDouble(vatScale);
        }
        vatsum.add(value, amount.doubleValue());
        return Double.toString(value);
    }

    class VatRateSum {
        HashMap<Double, VatRateElement> rates = new HashMap();
        double sumvat = 0.0;

        VatRateSum() {
        }

        public void add(double scale, double amount) {
            VatRateElement element = this.rates.get(scale);
            if (element == null) {
                element = new VatRateElement(scale);
                this.rates.put(new Double(scale), element);
            }
            element.add(amount);
            this.sumvat += amount / (100.0 + scale) * scale;
        }

        class VatRateElement
        implements Comparable<VatRateElement> {
            double scale;
            double sumamount;
            double sumvat;

            VatRateElement(double scale) {
                this.scale = scale;
                this.sumamount = 0.0;
                this.sumvat = 0.0;
            }

            void add(double amount) {
                this.sumamount += amount;
                this.sumvat += amount / (100.0 + this.scale) * this.scale;
            }

            @Override
            public int compareTo(VatRateElement other) {
                if (this.scale < other.scale) {
                    return -1;
                }
                if (this.scale > other.scale) {
                    return 1;
                }
                return 0;
            }
        }
    }
}

