/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.privatrechnung.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.elexis.data.RnStatus;
import ch.elexis.privatrechnung.rechnung.RnPrintView;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RechnungsDrucker
implements IRnOutputter {
    String templateESR;
    String templateBill;

    public boolean canBill(Fall fall) {
        return true;
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public Control createSettingsControl(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        new Label(ret, 0).setText("Formatvorlage f\u00fcr Rechnung (ESR-Seite)");
        final Text tVorlageESR = new Text(ret, 2048);
        tVorlageESR.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        tVorlageESR.setText(CoreHub.globalCfg.get("privatrechnung_basic/templateESR", "privatrechnung_ESR"));
        tVorlageESR.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent ev) {
                RechnungsDrucker.this.templateESR = tVorlageESR.getText();
                CoreHub.globalCfg.set("privatrechnung_basic/templateESR", RechnungsDrucker.this.templateESR);
            }
        });
        new Label(ret, 0).setText("Formatvorlage f\u00fcr Rechnung (Folgeseiten)");
        final Text tVorlageRn = new Text(ret, 2048);
        tVorlageRn.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        tVorlageRn.setText(CoreHub.globalCfg.get("privatrechnung_basic/templateBill", "privatrechnung_S2"));
        tVorlageRn.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent ev) {
                RechnungsDrucker.this.templateBill = tVorlageRn.getText();
                CoreHub.globalCfg.set("privatrechnung_basic/templateBill", RechnungsDrucker.this.templateBill);
            }
        });
        tVorlageESR.setText(CoreHub.globalCfg.get("privatrechnung_basic/templateESR", "privatrechnung_ESR"));
        tVorlageRn.setText(CoreHub.globalCfg.get("privatrechnung_basic/templateBill", "privatrechnung_S2"));
        return ret;
    }

    public Result<Rechnung> doOutput(IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        final Result result = new Result();
        IWorkbenchPage rnPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final Result res = new Result();
        try {
            final RnPrintView rnp = (RnPrintView)rnPage.showView("ch.elexis.privatrechnung.view");
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Drucke Rechnungen", rnn.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rnn) {
                        try {
                            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)rn);
                            result.add(rnp.doPrint(rn));
                            monitor.worked(10);
                            if (!result.isOK()) {
                                String errms = "Rechnung " + rn.getNr() + "konnte nicht gedruckt werden";
                                res.add(Result.SEVERITY.ERROR, 1, errms, (Object)rn, true);
                                ++errors;
                                continue;
                            }
                            int status_vorher = rn.getStatus();
                            if (status_vorher == 4 || status_vorher == 6 || status_vorher == 8 || status_vorher == 10) {
                                rn.setStatus(status_vorher + 1);
                            }
                            rn.addTrace("Ausgegeben", String.valueOf(RechnungsDrucker.this.getDescription()) + ": " + RnStatus.getStatusText((int)rn.getStatus()));
                        }
                        catch (Exception ex) {
                            SWTHelper.showError((String)("Fehler beim Drucken der Rechnung " + rn.getRnId()), (String)ex.getMessage());
                            ++errors;
                        }
                    }
                    monitor.done();
                    if (errors == 0) {
                        SWTHelper.showInfo((String)"OK", (String)"OK");
                    } else {
                        SWTHelper.showError((String)"Fehler", (String)"Fehler");
                    }
                }
            }, null);
            rnPage.hideView((IViewPart)rnp);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            ErrorDialog.openError(null, (String)"Exception", (String)"Exception", (IStatus)ResultAdapter.getResultAsStatus((Result)res));
            return res;
        }
        if (!result.isOK()) {
            ResultAdapter.displayResult((Result)result, (String)"Fehler beim Rechnungsdruck");
        }
        return result;
    }

    public String getDescription() {
        return "Privatrechnung auf Drucker";
    }

    public void saveComposite() {
    }

    public Object createSettingsControl(Object parent) {
        return null;
    }
}

