/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.privatrechnung.data;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.ExcelWrapper;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Query;
import ch.elexis.privatrechnung.data.Leistung;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class Importer
extends ImporterPage {
    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fbi = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fbi.setFilter(new String[]{"*.csv", "*.xls", "*"}, new String[]{"Character Separated Values", "Microsoft Excel 97", "All Files"});
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return fbi;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        Result<String> res;
        File file = new File(this.results[0]);
        if (!file.canRead()) {
            this.log.log("Can't read " + this.results[0], 2);
            return new Status(4, "ch.elexis.privatrechnung", "Can't read " + this.results[0]);
        }
        if (this.results[0].endsWith(".xls")) {
            res = this.importExcel(file.getAbsolutePath(), monitor);
        } else if (this.results[0].endsWith(".csv")) {
            res = this.importCSV(file.getAbsolutePath(), monitor);
        } else {
            return new Status(4, "ch.elexis.privatrechnung", "Unsupported file format");
        }
        res.isOK();
        return ResultAdapter.getResultAsStatus(res);
    }

    public String getDescription() {
        return "Import aus CSV und Excel";
    }

    public String getTitle() {
        return "Privatleistungen";
    }

    private Result<String> importExcel(String file, IProgressMonitor mon) {
        ExcelWrapper xl = new ExcelWrapper();
        if (!xl.load(file, 0)) {
            return new Result(Result.SEVERITY.ERROR, 1, "Bad file format", (Object)file, true);
        }
        xl.setFieldTypes(new Class[]{String.class, String.class, String.class, Integer.class, Integer.class, Integer.class, TimeTool.class, TimeTool.class, Double.class});
        int i = xl.getFirstRow();
        while (i <= xl.getLastRow()) {
            List row = xl.getRow(i);
            this.importLine(row.toArray(new String[0]));
            ++i;
        }
        return new Result((Object)"OK");
    }

    private Result<String> importCSV(String file, IProgressMonitor mon) {
        try {
            String[] line;
            CSVReader cr = new CSVReader((Reader)new FileReader(file));
            while ((line = cr.readNext()) != null) {
                this.importLine(line);
            }
            return new Result((Object)"OK");
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Result(Result.SEVERITY.ERROR, 1, "Could not read " + file, (Object)ex.getMessage(), true);
        }
    }

    private void importLine(String[] line) {
        if (line.length == 9) {
            if (line[6].equals("")) {
                line[6] = "19700101";
            }
            if (line[7].equals("")) {
                line[7] = "20380118";
            }
            Query qbe = new Query(Leistung.class);
            qbe.add("Kuerzel", "=", line[1]);
            List res = qbe.execute();
            if (res.size() > 0) {
                Leistung lst = (Leistung)((Object)res.get(0));
                lst.set(new String[]{"parent", "Name", "Kosten", "Preis", "Zeit", "DatumVon", "DatumBis"}, new String[]{line[0], line[2], line[3], line[4], line[5], line[6], line[7]});
            } else {
                new Leistung(null, line[0], line[2], line[1], line[3], line[4], line[5], line[6], line[7]);
            }
        }
    }
}

