/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockRequestingRestrictedAction;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.omnivore.data.AutomaticBilling;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.ui.Messages;
import ch.elexis.omnivore.ui.views.FileImportDialog;
import ch.elexis.omnivore.ui.views.OmnivoreViewerComparator;
import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmnivoreView
extends ViewPart
implements IRefreshable {
    private TreeViewer viewer;
    private Tree table;
    RestrictedAction editAction;
    RestrictedAction deleteAction;
    RestrictedAction importAction;
    public static String importAction_ID = "ch.elexis.omnivore.data.OmnivoreView.importAction";
    private Action exportAction;
    private Action doubleClickAction;
    private Action flatViewAction;
    private final String[] colLabels = new String[]{"", Messages.OmnivoreView_categoryColumn, Messages.OmnivoreView_dateColumn, Messages.OmnivoreView_titleColumn, Messages.OmnivoreView_keywordsColumn};
    private final String colWidth = "20,80,80,150,500";
    private final String sortSettings = "0,1,-1,false";
    private boolean bFlat = false;
    private String searchTitle = "";
    private String searchKW = "";
    static Logger log = LoggerFactory.getLogger(OmnivoreView.class);
    private OmnivoreViewerComparator ovComparator;
    private Patient actPatient;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this){

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (this.isMatchingPart(partRef)) {
                OmnivoreView.this.saveColumnWidthSettings();
                OmnivoreView.this.saveSortSettings();
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl((Control)OmnivoreView.this.table) && OmnivoreView.this.actPatient != ev.getObject()) {
                OmnivoreView.this.viewer.refresh();
                OmnivoreView.this.actPatient = (Patient)ev.getObject();
            }
        }
    };
    private final ElexisUiEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
            OmnivoreView.this.viewer.refresh();
            OmnivoreView.this.importAction.reflectRight();
            OmnivoreView.this.editAction.reflectRight();
            OmnivoreView.this.deleteAction.reflectRight();
        }
    };
    private final ElexisUiEventListenerImpl eeli_dochandle = new ElexisUiEventListenerImpl(DocHandle.class, 7){

        public void runInUi(ElexisEvent ev) {
            if (this.isActiveControl((Control)OmnivoreView.this.table)) {
                OmnivoreView.this.viewer.refresh();
            }
        }
    };

    public OmnivoreView() {
        DocHandle.load((String)"1");
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        Label lSearchTitle = new Label(parent, 0);
        lSearchTitle.setText(Messages.OmnivoreView_searchTitleLabel);
        lSearchTitle.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Text tSearchTitle = new Text(parent, 4);
        tSearchTitle.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lSearchKW = new Label(parent, 0);
        lSearchKW.setText(Messages.OmnivoreView_searchKeywordsLabel);
        lSearchKW.setLayoutData((Object)new GridData(16384, 128, false, false));
        final Text tSearchKW = new Text(parent, 4);
        tSearchKW.setLayoutData((Object)new GridData(4, 128, true, false));
        ModifyListener searchListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OmnivoreView.this.searchKW = tSearchKW.getText();
                OmnivoreView.this.searchTitle = tSearchTitle.getText();
                OmnivoreView.this.refresh();
            }
        };
        tSearchTitle.addModifyListener(searchListener);
        tSearchKW.addModifyListener(searchListener);
        this.table = new Tree(parent, 66306);
        TreeColumn[] cols = new TreeColumn[this.colLabels.length];
        int i = 0;
        while (i < this.colLabels.length) {
            cols[i] = new TreeColumn(this.table, 0);
            cols[i].setText(this.colLabels[i]);
            cols[i].setData((Object)new Integer(i));
            ++i;
        }
        this.applyUsersColumnWidthSetting();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        this.viewer = new TreeViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setUseHashlookup(true);
        this.makeActions();
        this.ovComparator = new OmnivoreViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.ovComparator);
        TreeColumn[] treeCols = this.viewer.getTree().getColumns();
        int i2 = 0;
        while (i2 < treeCols.length) {
            TreeColumn tc = treeCols[i2];
            tc.addSelectionListener(this.getSelectionAdapter(tc, i2));
            ++i2;
        }
        this.applySortDirection();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        final Transfer[] dropTransferTypes = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDropSupport(1, dropTransferTypes, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                if (dropTransferTypes[0].isSupportedType(event.currentDataType)) {
                    String[] files = (String[])event.data;
                    String category = null;
                    if (event.item != null && event.item.getData() instanceof DocHandle) {
                        DocHandle dh = (DocHandle)event.item.getData();
                        category = dh.getCategory();
                    }
                    String[] stringArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String file = stringArray[n2];
                        final DocHandle handle = DocHandle.assimilate((String)file, (String)category);
                        if (handle != null) {
                            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)handle, (ILockHandler)new ILockHandler(){

                                public void lockFailed() {
                                    handle.delete();
                                }

                                public void lockAcquired() {
                                    if (AutomaticBilling.isEnabled()) {
                                        AutomaticBilling billing = new AutomaticBilling(handle);
                                        billing.bill();
                                    }
                                }
                            });
                        }
                        OmnivoreView.this.viewer.refresh();
                        ++n2;
                    }
                }
            }
        });
        Transfer[] dragTransferTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
        this.viewer.addDragSupport(1, dragTransferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OmnivoreView.this.viewer.getSelection();
                for (Object object : selection.toList()) {
                    DocHandle dh = (DocHandle)object;
                    if (!dh.isCategory()) continue;
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OmnivoreView.this.viewer.getSelection();
                if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                    String[] files = new String[selection.size()];
                    int index = 0;
                    while (index < selection.size()) {
                        DocHandle dh = (DocHandle)selection.toList().get(index);
                        File file = dh.createTemporaryFile(dh.getTitle());
                        files[index] = file.getAbsolutePath();
                        log.debug("dragSetData; isSupportedType {} data {}", (Object)file.getAbsolutePath(), event.data);
                        ++index;
                    }
                    event.data = files;
                } else {
                    StringBuilder sb = new StringBuilder();
                    int index = 0;
                    while (index < selection.size()) {
                        DocHandle dh = (DocHandle)selection.toList().get(index);
                        sb.append(dh.storeToString()).append(",");
                        log.debug("dragSetData; unsupported dataType {} returning {}", (Object)event.dataType, (Object)sb.toString().replace(",$", ""));
                        ++index;
                    }
                    event.data = sb.toString().replace(",$", "");
                }
            }
        });
        this.eeli_user.catchElexisEvent(ElexisEvent.createUserEvent());
        this.viewer.setInput((Object)this.getViewSite());
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user, this.eeli_dochandle});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private SelectionListener getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OmnivoreView.this.ovComparator.setColumn(index);
                OmnivoreView.this.ovComparator.setFlat(OmnivoreView.this.bFlat);
                OmnivoreView.this.viewer.getTree().setSortDirection(OmnivoreView.this.ovComparator.getDirection());
                OmnivoreView.this.viewer.getTree().setSortColumn(column);
                OmnivoreView.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void applySortDirection() {
        String[] usrSortSettings = "0,1,-1,false".split(",");
        if (CoreHub.userCfg.get("ch.elexis.omnivore//savesortdirection", false)) {
            String sortSet = CoreHub.userCfg.get("ch.elexis.omnivore//sortdirection", "0,1,-1,false");
            usrSortSettings = sortSet.split(",");
        }
        int propertyIdx = Integer.parseInt(usrSortSettings[0]);
        int direction = Integer.parseInt(usrSortSettings[1]);
        int catDirection = Integer.parseInt(usrSortSettings[2]);
        this.bFlat = Boolean.valueOf(usrSortSettings[3]);
        this.flatViewAction.setChecked(this.bFlat);
        if (!this.bFlat && catDirection != -1) {
            this.sortViewer(1, catDirection);
            this.ovComparator.setCategoryDirection(catDirection);
        }
        if (propertyIdx != 0) {
            this.sortViewer(propertyIdx, direction);
        }
    }

    private void sortViewer(int propertyIdx, int direction) {
        TreeColumn column = this.viewer.getTree().getColumn(propertyIdx);
        this.ovComparator.setColumn(propertyIdx);
        this.ovComparator.setDirection(direction);
        this.ovComparator.setFlat(this.bFlat);
        this.viewer.getTree().setSortDirection(this.ovComparator.getDirection());
        this.viewer.getTree().setSortColumn(column);
        this.viewer.refresh();
    }

    private void applyUsersColumnWidthSetting() {
        TreeColumn[] treeColumns = this.table.getColumns();
        String[] userColWidth = "20,80,80,150,500".split(",");
        if (CoreHub.userCfg.get("ch.elexis.omnivore//savecolwidths", false)) {
            String ucw = CoreHub.userCfg.get("ch.elexis.omnivore//columnwidths", "20,80,80,150,500");
            userColWidth = ucw.split(",");
        }
        int i = 0;
        while (i < treeColumns.length && i < userColWidth.length) {
            treeColumns[i].setWidth(Integer.parseInt(userColWidth[i]));
            ++i;
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user, this.eeli_dochandle});
        this.saveSortSettings();
        super.dispose();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OmnivoreView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        MenuManager mnSources = new MenuManager(Messages.OmnivoreView_dataSources);
        manager.add((IAction)this.importAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.editAction);
        manager.add((IAction)this.deleteAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.flatViewAction);
    }

    private void makeActions() {
        this.importAction = new RestrictedAction(AccessControlDefaults.DOCUMENT_CREATE, Messages.OmnivoreView_importActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_importActionToolTip);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void doRun() {
                if (ElexisEventDispatcher.getSelectedPatient() == null) {
                    return;
                }
                FileDialog fd = new FileDialog(OmnivoreView.this.getViewSite().getShell(), 4096);
                String filename = fd.open();
                if (filename != null) {
                    final DocHandle handle = DocHandle.assimilate((String)filename);
                    if (handle != null) {
                        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)handle, (ILockHandler)new ILockHandler(){

                            public void lockFailed() {
                                handle.delete();
                            }

                            public void lockAcquired() {
                            }
                        });
                    }
                    OmnivoreView.this.viewer.refresh();
                }
            }
        };
        this.deleteAction = new LockRequestingRestrictedAction<DocHandle>(AccessControlDefaults.DOCUMENT_DELETE, Messages.OmnivoreView_deleteActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_deleteActionToolTip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public DocHandle getTargetedObject() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                return (DocHandle)((IStructuredSelection)selection).getFirstElement();
            }

            public void doRun(DocHandle dh) {
                if (dh.isCategory()) {
                    if (CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE)) {
                        ListDialog ld = new ListDialog(OmnivoreView.this.getViewSite().getShell());
                        Query qbe = new Query(DocHandle.class);
                        qbe.add("Mimetype", "=", "text/category");
                        qbe.add("id", "<>", dh.getId());
                        List mainCategories = qbe.execute();
                        ld.setInput((Object)mainCategories);
                        ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                        ld.setLabelProvider((ILabelProvider)new DefaultLabelProvider());
                        ld.setTitle(MessageFormat.format("Kategorie {0} l\u00f6schen", dh.getLabel()));
                        ld.setMessage("Geben Sie bitte an, in welche andere Kategorie die Dokumente dieser Kategorie verschoben werden sollen");
                        int open = ld.open();
                        if (open == 0) {
                            Object[] selection = ld.getResult();
                            if (selection != null && selection.length > 0) {
                                String label = ((DocHandle)selection[0]).getLabel();
                                DocHandle.removeCategory((String)dh.getLabel(), (String)label);
                            }
                            OmnivoreView.this.viewer.refresh();
                        }
                    } else {
                        SWTHelper.showError((String)"Insufficient Rights", (String)"You have insufficient rights to delete document categories");
                    }
                } else if (SWTHelper.askYesNo((String)Messages.OmnivoreView_reallyDeleteCaption, (String)MessageFormat.format(Messages.OmnivoreView_reallyDeleteContents, dh.getTitle()))) {
                    dh.delete();
                    OmnivoreView.this.viewer.refresh();
                }
            }
        };
        this.editAction = new LockRequestingRestrictedAction<DocHandle>(AccessControlDefaults.DOCUMENT_DELETE, Messages.OmnivoreView_editActionCaption){
            {
                this.setToolTipText(Messages.OmnivoreView_editActionTooltip);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public DocHandle getTargetedObject() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                return (DocHandle)((IStructuredSelection)selection).getFirstElement();
            }

            public void doRun(DocHandle dh) {
                if (dh.isCategory()) {
                    if (CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE)) {
                        InputDialog id = new InputDialog(OmnivoreView.this.getViewSite().getShell(), MessageFormat.format("Kategorie {0} umbenennen.", dh.getLabel()), "Geben Sie bitte einen neuen Namen f\u00fcr die Kategorie ein", dh.getLabel(), null);
                        if (id.open() == 0) {
                            String nn = id.getValue();
                            DocHandle.renameCategory((String)dh.getTitle(), (String)nn);
                            OmnivoreView.this.viewer.refresh();
                        }
                    } else {
                        SWTHelper.showError((String)"Insufficient Rights", (String)"You have insufficient rights to delete document categories");
                    }
                } else {
                    FileImportDialog fid = new FileImportDialog(dh);
                    if (fid.open() == 0) {
                        OmnivoreView.this.viewer.refresh(true);
                    }
                }
            }
        };
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                DocHandle dh = (DocHandle)obj;
                if (dh.isCategory()) {
                    if (OmnivoreView.this.viewer.getExpandedState((Object)dh)) {
                        OmnivoreView.this.viewer.collapseToLevel((Object)dh, -1);
                    } else {
                        OmnivoreView.this.viewer.expandToLevel((Object)dh, -1);
                    }
                } else {
                    dh.execute();
                }
            }
        };
        this.exportAction = new Action(Messages.OmnivoreView_exportActionCaption){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText(Messages.OmnivoreView_exportActionTooltip);
            }

            public void run() {
                ISelection selection = OmnivoreView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj == null) {
                    return;
                }
                DocHandle dh = (DocHandle)obj;
                String mime = dh.get("Mimetype");
                FileDialog fd = new FileDialog(OmnivoreView.this.getSite().getShell(), 8192);
                fd.setFileName(mime);
                String fname = fd.open();
                if (fname != null && !dh.storeExternal(fname)) {
                    SWTHelper.showError((String)Messages.OmnivoreView_configErrorCaption, (String)Messages.OmnivoreView_configErrorText);
                }
            }
        };
        this.flatViewAction = new Action(Messages.OmnivoreView_flatActionCaption, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.OmnivoreView_flatActionTooltip);
            }

            public void run() {
                OmnivoreView.this.bFlat = this.isChecked();
                OmnivoreView.this.viewer.refresh();
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OmnivoreView.this.doubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
        this.refresh();
    }

    private void saveColumnWidthSettings() {
        TreeColumn[] treeColumns = this.viewer.getTree().getColumns();
        StringBuilder sb = new StringBuilder();
        TreeColumn[] treeColumnArray = treeColumns;
        int n = treeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            sb.append(tc.getWidth());
            sb.append(",");
            ++n2;
        }
        CoreHub.userCfg.set("ch.elexis.omnivore//columnwidths", sb.toString());
    }

    private void saveSortSettings() {
        int propertyIdx = this.ovComparator.getPropertyIndex();
        int direction = this.ovComparator.getDirectionDigit();
        int catDirection = this.ovComparator.getCategoryDirection();
        CoreHub.userCfg.set("ch.elexis.omnivore//sortdirection", String.valueOf(propertyIdx) + "," + direction + "," + catDirection + "," + this.bFlat);
    }

    public void refresh() {
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.omnivoredirect", (String)path);
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private void addFilters(Query<DocHandle> qbe) {
            qbe.add("Titel", "LIKE", "%" + OmnivoreView.this.searchTitle + "%");
            String[] stringArray = OmnivoreView.this.searchKW.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                qbe.add("Keywords", "LIKE", "%" + kw + "%");
                ++n2;
            }
        }

        private boolean filterMatches(String[] kws, DocHandle h) {
            if (!h.getTitle().toLowerCase().contains(OmnivoreView.this.searchTitle.toLowerCase())) {
                return false;
            }
            String dkw = h.getKeywords().toLowerCase();
            String[] stringArray = kws;
            int n = kws.length;
            int n2 = 0;
            while (n2 < n) {
                String kw = stringArray[n2];
                if (!dkw.contains(kw)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        private List<DocHandle> filterList(List<DocHandle> list) {
            LinkedList<DocHandle> result = new LinkedList<DocHandle>();
            String[] kws = OmnivoreView.this.searchKW.toLowerCase().split(" ");
            for (DocHandle dh : list) {
                if (!this.filterMatches(kws, dh)) continue;
                result.add(dh);
            }
            return result;
        }

        public Object[] getElements(Object parent) {
            LinkedList<DocHandle> ret = new LinkedList<DocHandle>();
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            if (!OmnivoreView.this.bFlat && pat != null) {
                List cats = DocHandle.getMainCategories();
                for (DocHandle dh : cats) {
                    if (this.filterList(dh.getMembers(pat)).size() <= 0) continue;
                    ret.add(dh);
                }
                Query qbe = new Query(DocHandle.class);
                qbe.add("PatID", "=", pat.getId());
                qbe.add("Cat", "", null);
                this.addFilters((Query<DocHandle>)qbe);
                List root = qbe.execute();
                ret.addAll(root);
            } else if (pat != null) {
                Query qbe = new Query(DocHandle.class);
                qbe.add("PatID", "=", pat.getId());
                this.addFilters((Query<DocHandle>)qbe);
                List docs = qbe.execute();
                for (DocHandle dh : docs) {
                    if (dh.isCategory()) continue;
                    ret.add(dh);
                }
            }
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            Patient pat = ElexisEventDispatcher.getSelectedPatient();
            if (!OmnivoreView.this.bFlat && pat != null && parentElement instanceof DocHandle) {
                DocHandle dhParent = (DocHandle)parentElement;
                return this.filterList(dhParent.getMembers(pat)).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (!OmnivoreView.this.bFlat && element instanceof DocHandle) {
                DocHandle dh = (DocHandle)element;
                return dh.getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof DocHandle) {
                DocHandle dh = (DocHandle)element;
                return dh.isCategory();
            }
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            DocHandle dh = (DocHandle)obj;
            switch (index) {
                case 0: {
                    return "";
                }
                case 1: {
                    if (OmnivoreView.this.bFlat) {
                        return dh.getCategoryName();
                    }
                    return dh.isCategory() ? dh.getTitle() : "";
                }
                case 2: {
                    return dh.isCategory() ? "" : dh.getDate();
                }
                case 3: {
                    return dh.isCategory() ? "" : dh.getTitle();
                }
                case 4: {
                    return dh.isCategory() ? "" : dh.get("Keywords");
                }
            }
            return "?";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

