/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.ui.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.ui.Messages;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileImportDialog
extends TitleAreaDialog {
    String file;
    DocHandle dh;
    DatePickerCombo dDate;
    Text tTitle;
    Text tKeywords;
    Combo cbCategories;
    public Date date;
    public String title;
    public String keywords;
    public String category;
    private String preSelectedCategory;

    public FileImportDialog(DocHandle dh) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.dh = dh;
        this.file = dh.get("Titel");
    }

    public FileImportDialog(String name) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
    }

    public FileImportDialog(String name, String preSelectedCategory) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
        this.preSelectedCategory = preSelectedCategory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        if (Preferences.getDateModifiable()) {
            new Label(ret, 0).setText(Messages.FileImportDialog_dateLabel);
            this.dDate = new DatePickerCombo(ret, 0);
            if (this.dh == null) {
                this.dDate.setDate(new Date());
            } else {
                this.dDate.setDate(new TimeTool(this.dh.getDate()).getTime());
            }
        }
        new Label(ret, 0).setText(Messages.FileImportDialog_categoryLabel);
        Composite cCats = new Composite(ret, 0);
        cCats.setFocus();
        cCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCats.setLayout((Layout)new RowLayout(256));
        this.cbCategories = new Combo(cCats, 4);
        RowData rd = new RowData(200, -1);
        this.cbCategories.setLayoutData((Object)rd);
        Button bNewCat = new Button(cCats, 8);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), Messages.FileImportDialog_newCategoryCaption, Messages.FileImportDialog_newCategoryText, null, null);
                if (id.open() == 0) {
                    DocHandle.addMainCategory((String)id.getValue());
                    FileImportDialog.this.cbCategories.add(id.getValue());
                    FileImportDialog.this.cbCategories.setText(id.getValue());
                }
            }
        });
        Button bEditCat = new Button(cCats, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setToolTipText("Kategorie umbenennen");
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String old = FileImportDialog.this.cbCategories.getText();
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), MessageFormat.format("Kategorie '{0}' umbenennen.", old), "Geben Sie bitte einen neuen Namen f\u00fcr die Kategorie ein", old, null);
                if (id.open() == 0) {
                    String nn = id.getValue();
                    DocHandle.renameCategory((String)old, (String)nn);
                    FileImportDialog.this.cbCategories.remove(old);
                    FileImportDialog.this.cbCategories.add(nn);
                }
            }
        });
        Button bDeleteCat = new Button(cCats, 8);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText("Kategorie l\u00f6schen");
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                String old = FileImportDialog.this.cbCategories.getText();
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), MessageFormat.format("Kategorie {0}l\u00f6schen", old), "Geben Sie bitte an, in welche andere Kategorie die Dokumente dieser Kategorie verschoben werden sollen", "", null);
                if (id.open() == 0) {
                    DocHandle.removeCategory((String)old, (String)id.getValue());
                    FileImportDialog.this.cbCategories.remove(id.getValue());
                }
            }
        });
        List cats = DocHandle.getMainCategoryNames();
        if (cats.size() > 0) {
            Collections.sort(cats);
            this.cbCategories.setItems(cats.toArray(new String[0]));
            if (this.preSelectedCategory == null) {
                this.cbCategories.select(0);
            } else {
                String[] items = this.cbCategories.getItems();
                int i = 0;
                while (i < items.length) {
                    if (items[i].equals(this.preSelectedCategory)) {
                        this.cbCategories.select(i);
                    }
                    ++i;
                }
            }
        }
        new Label(ret, 0).setText(Messages.FileImportDialog_titleLabel);
        this.tTitle = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        new Label(ret, 0).setText(Messages.FileImportDialog_keywordsLabel);
        this.tKeywords = SWTHelper.createText((Composite)ret, (int)4, (int)0);
        this.tTitle.setText(this.file);
        if (this.dh != null) {
            this.tKeywords.setText(this.dh.get("Keywords"));
            this.cbCategories.setText(this.dh.getCategoryName());
        }
        bEditCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE));
        bDeleteCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE));
        bNewCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATCREATE));
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.file);
        this.getShell().setText(Messages.FileImportDialog_importCaption);
        this.setMessage(Messages.FileImportDialog_importFileText);
    }

    protected void okPressed() {
        if (this.dDate != null) {
            this.date = this.dDate.getDate();
        }
        if (this.date == null) {
            this.date = new Date();
        }
        this.keywords = this.tKeywords.getText();
        this.title = this.tTitle.getText();
        this.category = this.cbCategories.getText();
        if (this.dh != null) {
            this.dh.setDate(this.date);
            if (this.category.length() > 0) {
                this.dh.set("Cat", this.category);
            }
            this.dh.set("Titel", this.title);
            this.dh.set("Keywords", this.keywords);
        }
        super.okPressed();
    }
}

