/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.dialog;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.dialog.Messages;
import ch.rgw.tools.TimeTool;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileImportDialog
extends TitleAreaDialog {
    String file;
    DocHandle dh;
    DatePickerCombo saveDatePicker;
    DatePickerCombo originDatePicker;
    Text tTitle;
    Text tKeywords;
    Combo cbCategories;
    public Date saveDate;
    public Date originDate;
    public String title;
    public String keywords;
    public String category;
    public String preSelectedCategory;

    public FileImportDialog(DocHandle dh) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.dh = dh;
        this.file = dh.get("Titel");
    }

    public FileImportDialog(String name) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
    }

    public FileImportDialog(String name, String preSelectedCategory) {
        super(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.file = name;
        this.preSelectedCategory = preSelectedCategory;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        if (Preferences.getDateModifiable()) {
            Composite dateComposite = new Composite(ret, 0);
            dateComposite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            dateComposite.setLayout((Layout)new RowLayout(256));
            new Label(dateComposite, 0).setText(Messages.OmnivoreView_dateSavedColumn);
            this.saveDatePicker = new DatePickerCombo(dateComposite, 0);
            if (this.dh == null) {
                this.saveDatePicker.setDate(new Date());
            } else {
                this.saveDatePicker.setDate(new TimeTool(this.dh.getDate()).getTime());
            }
            new Label(dateComposite, 0).setText(Messages.OmnivoreView_dateOriginColumn);
            this.originDatePicker = new DatePickerCombo(dateComposite, 0);
            if (this.dh == null) {
                this.originDatePicker.setDate(new Date());
            } else {
                this.originDatePicker.setDate(new TimeTool(this.dh.getCreationDate()).getTime());
            }
        }
        new Label(ret, 0).setText("Kategorie");
        Composite cCats = new Composite(ret, 0);
        cCats.setFocus();
        cCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCats.setLayout((Layout)new RowLayout(256));
        this.cbCategories = new Combo(cCats, 12);
        RowData rd = new RowData(200, -1);
        this.cbCategories.setLayoutData((Object)rd);
        Button bNewCat = new Button(cCats, 8);
        bNewCat.setImage(Images.IMG_NEW.getImage());
        bNewCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), "Neue Kategorie", "Geben Sie bitte einen Namen f\u00fcr die neue Kategorie ein", null, null);
                if (id.open() == 0) {
                    DocHandle.addMainCategory(id.getValue());
                    FileImportDialog.this.cbCategories.add(id.getValue());
                    FileImportDialog.this.cbCategories.setText(id.getValue());
                }
            }
        });
        Button bEditCat = new Button(cCats, 8);
        bEditCat.setImage(Images.IMG_EDIT.getImage());
        bEditCat.setToolTipText("Kategorie umbenennen");
        bEditCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String old = FileImportDialog.this.cbCategories.getText();
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), MessageFormat.format("Kategorie '{0}' umbenennen.", old), "Geben Sie bitte einen neuen Namen f\u00fcr die Kategorie ein", old, null);
                if (id.open() == 0) {
                    String nn = id.getValue();
                    DocHandle.renameCategory(old, nn);
                    FileImportDialog.this.cbCategories.remove(old);
                    FileImportDialog.this.cbCategories.add(nn);
                }
            }
        });
        Button bDeleteCat = new Button(cCats, 8);
        bDeleteCat.setImage(Images.IMG_DELETE.getImage());
        bDeleteCat.setToolTipText("Kategorie l\u00f6schen");
        bDeleteCat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                String old = FileImportDialog.this.cbCategories.getText();
                InputDialog id = new InputDialog(FileImportDialog.this.getShell(), MessageFormat.format("Kategorie {0} l\u00f6schen", old), "Geben Sie bitte an, in welche andere Kategorie die Dokumente dieser Kategorie verschoben werden sollen", "", null);
                if (id.open() == 0) {
                    DocHandle.removeCategory(old, id.getValue());
                    FileImportDialog.this.cbCategories.remove(id.getValue());
                }
            }
        });
        List<String> cats = DocHandle.getMainCategoryNames();
        if (cats.size() > 0) {
            Collections.sort(cats);
            this.cbCategories.setItems(cats.toArray(new String[0]));
            this.cbCategories.select(0);
        }
        new Label(ret, 0).setText("Titel");
        this.tTitle = SWTHelper.createText((Composite)ret, (int)1, (int)0);
        new Label(ret, 0).setText("Stichw\u00f6rter");
        this.tKeywords = SWTHelper.createText((Composite)ret, (int)4, (int)0);
        this.tTitle.setText(this.file);
        if (this.dh != null) {
            this.tKeywords.setText(this.dh.get("Keywords"));
            this.cbCategories.setText(this.dh.getCategoryName());
        }
        bEditCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE));
        bDeleteCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATDELETE));
        bNewCat.setEnabled(CoreHub.acl.request(AccessControlDefaults.DOCUMENT_CATCREATE));
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.file);
        this.getShell().setText("Datei importieren");
        this.setMessage("Geben Sie bitte einen Titel und ggf. einige Stichw\u00f6rter f\u00fcr dieses Dokument ein");
    }

    protected void okPressed() {
        this.setDateValues();
        this.keywords = this.tKeywords.getText();
        this.title = this.tTitle.getText();
        this.category = this.cbCategories.getText();
        if (this.dh != null) {
            this.dh.setDate(this.saveDate);
            this.dh.setCreationDate(this.originDate);
            this.dh.set(new String[]{"Cat", "Titel", "Keywords"}, new String[]{this.category, this.title, this.keywords});
        }
        super.okPressed();
    }

    private void setDateValues() {
        if (this.saveDatePicker != null) {
            this.saveDate = this.saveDatePicker.getDate();
        }
        if (this.originDatePicker != null) {
            this.originDate = this.originDatePicker.getDate();
        }
        if (this.saveDate == null && this.originDate != null) {
            this.saveDate = this.originDate;
        } else if (this.originDate == null && this.saveDate != null) {
            this.originDate = this.saveDate;
        } else if (this.saveDate == null && this.originDate == null) {
            this.saveDate = new Date();
            this.originDate = new Date();
        }
    }
}

