/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data.service.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ITag;
import ch.elexis.core.services.IDocumentStore;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.dto.CategoryDocumentDTO;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.data.dto.DocHandleDocumentDTO;
import ch.rgw.tools.JdbcLink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, property={"storeid=ch.elexis.data.store.omnivore"})
public class OmnivoreDocumentStore
implements IDocumentStore {
    private static final String STORE_ID = "ch.elexis.data.store.omnivore";
    private static Logger log = LoggerFactory.getLogger(OmnivoreDocumentStore.class);

    public String getId() {
        return STORE_ID;
    }

    public String getName() {
        return "Omnivore";
    }

    public List<IDocument> getDocuments(String patientId, String authorId, ICategory category, List<ITag> tag) {
        Query query = new Query(DocHandle.class);
        query.add("PatID", "=", patientId);
        if (category != null) {
            query.add("Cat", "=", category.getName(), true);
        }
        if (tag != null) {
            query.startGroup();
            for (ITag t : tag) {
                query.add("Keywords", "=", t.getName());
                query.or();
            }
            query.endGroup();
        }
        List docs = query.execute();
        ArrayList<IDocument> results = new ArrayList<IDocument>();
        for (DocHandle doc : docs) {
            results.add((IDocument)new DocHandleDocumentDTO(doc, STORE_ID));
        }
        return results;
    }

    public List<ICategory> getCategories() {
        JdbcLink.Stm stm = PersistentObject.getDefaultConnection().getStatement();
        ResultSet rs = stm.query("select distinct category from CH_ELEXIS_OMNIVORE_DATA where deleted = '0' order by category");
        ArrayList<ICategory> categories = new ArrayList<ICategory>();
        try {
            while (rs.next()) {
                String typ = rs.getString("Category");
                if (typ == null) continue;
                categories.add((ICategory)new CategoryDocumentDTO(typ));
            }
        }
        catch (SQLException e) {
            log.error("Error executing distinct docHandle category selection", (Throwable)e);
        }
        PersistentObject.getDefaultConnection().releaseStatement(stm);
        return categories;
    }

    public Optional<IDocument> loadDocument(String id) {
        DocHandle doc = DocHandle.load(id);
        if (doc.exists()) {
            return Optional.of(new DocHandleDocumentDTO(doc, STORE_ID));
        }
        return Optional.empty();
    }

    public void removeDocument(IDocument document) {
        DocHandle doc = DocHandle.load(document.getId());
        if (doc.exists()) {
            doc.delete();
        }
    }

    public IDocument saveDocument(IDocument document) throws ElexisException {
        return this.save(document, null);
    }

    public IDocument saveDocument(IDocument document, InputStream content) throws ElexisException {
        return this.save(document, content);
    }

    private IDocument save(IDocument document, InputStream content) throws ElexisException {
        try {
            String category;
            DocHandle doc = DocHandle.load(document.getId());
            String string = category = document.getCategory() != null ? document.getCategory().getName() : null;
            if (doc.exists()) {
                String[] fetch = new String[]{"PatID", "Titel", "Mimetype", "Cat", "Keywords"};
                String[] data = new String[]{document.getPatientId(), document.getTitle(), document.getMimeType(), category, document.getKeywords()};
                doc.set(fetch, data);
            } else {
                doc = new DocHandle(category, new byte[1], Patient.load((String)document.getPatientId()), document.getCreated(), document.getTitle(), document.getMimeType(), document.getKeywords());
            }
            if (content != null) {
                doc.storeContent(IOUtils.toByteArray((InputStream)content));
            }
            DocHandleDocumentDTO docHandleDocumentDTO = new DocHandleDocumentDTO(doc, STORE_ID);
            return docHandleDocumentDTO;
        }
        catch (PersistenceException | IOException e) {
            throw new ElexisException("cannot save", e);
        }
        finally {
            if (content != null) {
                IOUtils.closeQuietly((InputStream)content);
            }
        }
    }

    public Optional<InputStream> loadContent(IDocument document) {
        DocHandle doc = DocHandle.load(document.getId());
        if (doc.exists()) {
            try {
                byte[] buf = doc.getContentsAsBytes();
                if (buf != null) {
                    return Optional.of(new ByteArrayInputStream(buf));
                }
            }
            catch (ElexisException e) {
                log.error("Cannot load contents of document id: " + document.getId(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public IDocument createDocument(String patientId, String title, String categoryName) {
        DocHandleDocumentDTO docHandleDocumentDTO = new DocHandleDocumentDTO(STORE_ID);
        CategoryDocumentDTO iCategory = categoryName != null ? new CategoryDocumentDTO(categoryName) : this.getCategoryDefault();
        docHandleDocumentDTO.setCategory((ICategory)iCategory);
        docHandleDocumentDTO.setPatientId(patientId);
        docHandleDocumentDTO.setTitle(title);
        return docHandleDocumentDTO;
    }

    public ICategory getCategoryDefault() {
        return new CategoryDocumentDTO("default");
    }

    public Optional<IPersistentObject> getPersistenceObject(IDocument iDocument) {
        return Optional.of(DocHandle.load(iDocument.getId()));
    }

    public ICategory createCategory(String name) {
        if (name != null && this.findCategoriesByName(name).isEmpty()) {
            DocHandle.addMainCategory(name);
        }
        return new CategoryDocumentDTO(name);
    }

    private List<ICategory> findCategoriesByName(String name) {
        Query query = new Query(DocHandle.class);
        query.add("Cat", "=", name, true);
        query.add("Mimetype", "=", "text/category");
        List docs = query.execute();
        ArrayList<ICategory> iCategories = new ArrayList<ICategory>();
        for (DocHandle docHandle : docs) {
            iCategories.add((ICategory)new CategoryDocumentDTO(docHandle.getCategoryName()));
        }
        return iCategories;
    }

    public void removeCategory(IDocument iDocument, String newCategory) throws IllegalStateException {
        if (iDocument.getId() != null && iDocument.getCategory() != null) {
            ICategory oldCategory = iDocument.getCategory();
            Query query = new Query(DocHandle.class);
            query.add("Cat", "=", oldCategory.getName(), true);
            query.add("Mimetype", "<>", "text/category");
            query.add("id", "<>", iDocument.getId());
            List docs = query.execute();
            if (!docs.isEmpty()) {
                throw new IllegalStateException("at least one document to category reference exists with id: " + ((DocHandle)((Object)docs.get(0))).getId());
            }
            DocHandle.removeCategory(oldCategory.getName(), newCategory);
        }
    }

    public void renameCategory(ICategory category, String newCategory) throws IllegalStateException {
        DocHandle.renameCategory(category.getName(), newCategory);
    }
}

