/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data.service.internal;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.services.ILocalDocumentService;
import ch.elexis.omnivore.data.DocHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.LoggerFactory;

@Component(service={})
public class LocalDocumentServiceHolder {
    private static Optional<ILocalDocumentService> localDocumentService;

    @Reference
    public void bind(ILocalDocumentService service) {
        localDocumentService = Optional.ofNullable(service);
        service.registerSaveHandler(DocHandle.class, new ILocalDocumentService.ISaveHandler(){

            public boolean save(Object documentSource, ILocalDocumentService service) {
                DocHandle docHandle = (DocHandle)((Object)documentSource);
                Optional content = service.getContent((Object)docHandle);
                if (content.isPresent()) {
                    try {
                        docHandle.storeContent(IOUtils.toByteArray((InputStream)((InputStream)content.get())));
                        return true;
                    }
                    catch (ElexisException | IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Error saving document", e);
                    }
                    finally {
                        try {
                            ((InputStream)content.get()).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return false;
            }
        });
        service.registerLoadHandler(DocHandle.class, new ILocalDocumentService.ILoadHandler(){

            public InputStream load(Object documentSource) {
                DocHandle docHandle = (DocHandle)((Object)documentSource);
                try {
                    return new ByteArrayInputStream(docHandle.getContentsAsBytes());
                }
                catch (ElexisException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Error loading document", (Throwable)e);
                    return null;
                }
            }
        });
    }

    public void unbind(ILocalDocumentService service) {
        localDocumentService = Optional.empty();
    }

    public static Optional<ILocalDocumentService> getService() {
        return localDocumentService;
    }
}

