/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.Preferences;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.eclipse.jface.preference.IPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger log = LoggerFactory.getLogger(Utils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File archiveFile(File file, DocHandle dh) {
        File newFile = null;
        String SrcPattern = null;
        String DestDir = null;
        try {
            Integer i = 0;
            while (true) {
                if (i >= Preferences.getOmnivorenRulesForAutoArchiving()) {
                    return newFile;
                }
                SrcPattern = Preferences.getOmnivoreRuleForAutoArchivingSrcPattern(i);
                DestDir = Preferences.getOmnivoreRuleForAutoArchivingDestDir(i);
                if (SrcPattern != null && DestDir != null && (SrcPattern != "" || DestDir != "") && file.getAbsolutePath().contains(SrcPattern)) {
                    log.debug("SrcPattern {} found in file.getAbsolutePath() pos {}", (Object)SrcPattern, (Object)i);
                    if (DestDir == "") {
                        log.debug("DestDir is empty. No more rules will be evaluated for this file. Returning.");
                    }
                    if ((newFile = new File(DestDir)).isDirectory()) {
                        newFile = new File(String.valueOf(DestDir) + File.separatorChar + file.getName());
                    }
                    if (newFile.isDirectory()) {
                        log.debug("new File {} is a directory ; archiveFile not attempted", (Object)newFile.getAbsolutePath());
                        SWTHelper.showError((String)Messages.DocHandle_MoveErrorCaption, (String)MessageFormat.format(Messages.DocHandle_MoveErrorDestIsDir, DestDir, file.getName()));
                        return null;
                    }
                    if (newFile.isFile()) {
                        log.debug("new File {} already exits ; archiveFile not attempted", (Object)newFile.getAbsolutePath());
                        SWTHelper.showError((String)Messages.DocHandle_MoveErrorCaption, (String)MessageFormat.format(Messages.DocHandle_MoveErrorDestIsFile, DestDir, file.getName()));
                        return null;
                    }
                    log.debug("Will move file {} {} to: {} {}", new Object[]{file.getAbsolutePath(), file.exists(), newFile.getAbsolutePath(), newFile.exists()});
                    if (Files.move(file.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING) != null) {
                        log.debug("Archived incoming file {} to: {}", (Object)file.getAbsolutePath(), (Object)newFile.getAbsolutePath());
                        return newFile;
                    }
                    log.debug("Failed archiveFile incoming file {} to: {}", (Object)file.getAbsolutePath(), (Object)newFile.getAbsolutePath());
                    return null;
                }
                i = i + 1;
            }
        }
        catch (Throwable throwable) {
            ExHandler.handle((Throwable)throwable);
            if (file != null && newFile != null) {
                log.debug("Exception while moving file {} {} to: {} {}", new Object[]{file.getAbsolutePath(), file.exists(), newFile.getAbsolutePath(), newFile.exists()});
            } else {
                log.debug("Exception while moving file [{}] {} src {} dest {}", new Object[]{file != null ? file.getAbsolutePath() : "null", file != null ? Boolean.valueOf(file.exists()) : "invalid", SrcPattern, DestDir});
            }
            SWTHelper.showError((String)Messages.DocHandle_MoveErrorCaption, (String)Messages.DocHandle_MoveError);
            return null;
        }
    }

    private static String getFileElement(String element_key, String element_data) {
        SettingsPreferenceStore preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg);
        return Utils.processFileElement((IPreferenceStore)preferenceStore, element_key, element_data);
    }

    private static String processFileElement(IPreferenceStore preferenceStore, String element_key, String element_data) {
        log.debug("processFileElement: element_key=<{}> data <{}>", (Object)element_key, (Object)element_data);
        StringBuffer element_data_processed = new StringBuffer();
        Integer nCotfRules = Preferences.PREFERENCE_cotf_elements.length;
        int i = 0;
        while (i < nCotfRules) {
            if (Preferences.PREFERENCE_cotf_elements[i].equals(element_key)) {
                String leadId;
                String lead_fill_char;
                String element_data_processed5;
                String element_data_processed4;
                String element_data_processed3;
                String element_data_processed2;
                String element_data_processed1;
                if (element_key.contains("constant")) {
                    String search = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i] + "_" + Preferences.PREFERENCE_cotf_parameters[1];
                    String constant = preferenceStore.getString(search).trim();
                    log.debug("processFileElement: {} returning constant=<{}>", (Object)search, (Object)constant);
                    if (constant.length() > 0) {
                        log.debug("processFileElement: {} returning constant=<{}>", (Object)search, (Object)constant);
                    }
                    return constant;
                }
                String snumId = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i] + "_" + Preferences.PREFERENCE_cotf_parameters[1];
                String snum_digits = preferenceStore.getString(snumId).trim();
                if (snum_digits.isEmpty()) {
                    return "";
                }
                Integer num_digits = -1;
                if (snum_digits != null) {
                    try {
                        num_digits = Integer.parseInt(snum_digits);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (num_digits <= 0) {
                    return "";
                }
                if (num_digits > Preferences.nPreferences_cotf_element_digits_max) {
                    num_digits = Preferences.nPreferences_cotf_element_digits_max;
                }
                if ((element_data_processed1 = (element_data_processed2 = (element_data_processed3 = (element_data_processed4 = (element_data_processed5 = element_data.replaceAll(Matcher.quoteReplacement("[\\:/:*?()+,';\"\r\t\n\u00b4`<>]"), "").toString().trim()).replaceAll("_noa[0-9]+.[a-zA-Z0-9]{0,3}", "")).replaceAll("noa[0-9]+.[a-zA-Z0-9]{0,3}", "")).replaceAll("_omni_[0-9]+_vore.[a-zA-Z0-9]{0,3}", "")).replaceAll("omni_[0-9]+_vore.[a-zA-Z0-9]{0,3}", "")).length() > num_digits) {
                    element_data_processed1 = element_data_processed1.substring(0, num_digits);
                }
                if ((lead_fill_char = preferenceStore.getString(leadId = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i] + "_" + Preferences.PREFERENCE_cotf_parameters[0]).trim()) != null && lead_fill_char.length() > 0 && element_data_processed1.length() < num_digits) {
                    lead_fill_char = lead_fill_char.substring(0, 1);
                    int n = element_data_processed1.length();
                    while (n <= num_digits) {
                        element_data_processed.append(lead_fill_char);
                        ++n;
                    }
                }
                element_data_processed.append(element_data_processed1);
                String trailId = "ch.elexis.omnivore/cotf_" + Preferences.PREFERENCE_cotf_elements[i] + "_" + Preferences.PREFERENCE_cotf_parameters[2];
                String add_trail_char = preferenceStore.getString(trailId).trim();
                if (add_trail_char != null && add_trail_char.length() > 0) {
                    add_trail_char = add_trail_char.substring(0, 1);
                    element_data_processed.append(add_trail_char);
                }
                log.debug("{} {} {} {} <{}> {} <{>}", new Object[]{i, snumId, snum_digits, leadId, lead_fill_char, trailId, add_trail_char});
                log.debug("processFileElement: element_data_processed=<{}>", (Object)element_data_processed);
                return element_data_processed.toString();
            }
            ++i;
        }
        return "";
    }

    public static String createNiceFileName(DocHandle dh) {
        StringBuffer tmp = new StringBuffer();
        tmp.append(Utils.getFileElement("constant1", ""));
        tmp.append(Utils.getFileElement("PID", dh.getPatient().getKuerzel()));
        tmp.append(Utils.getFileElement("fn", dh.getPatient().getName()));
        tmp.append(Utils.getFileElement("gn", dh.getPatient().getVorname()));
        tmp.append(Utils.getFileElement("dob", dh.getPatient().getGeburtsdatum()));
        tmp.append(Utils.getFileElement("dt", dh.getTitle()));
        tmp.append(Utils.getFileElement("dk", dh.getKeywords()));
        tmp.append(Utils.getFileElement("dguid", dh.getGUID()));
        SecureRandom random = new SecureRandom();
        int needed_bits = (int)Math.round(Math.ceil(Math.log(Preferences.nPreferences_cotf_element_digits_max.intValue()) / Math.log(2.0)));
        tmp.append(Utils.getFileElement("random", new BigInteger(needed_bits, random).toString()));
        tmp.append(Utils.getFileElement("constant2", ""));
        return tmp.toString();
    }
}

