/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.activator.CoreHubHelper;
import ch.elexis.core.ui.preferences.SettingsPreferenceStore;
import ch.elexis.omnivore.PreferenceConstants;
import ch.elexis.omnivore.data.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preferences {
    private static SettingsPreferenceStore fsSettingsStore;
    public static Logger log;
    public static final Integer nPreferences_cotf_element_digits_max;
    public static final String PREFERENCE_COTF = "cotf_";
    public static final String[] PREFERENCE_cotf_elements;
    public static final String[] PREFERENCE_cotf_parameters;
    public static final String cotf_unwanted_chars = "[\\:/:*?()+,';\"\r\t\n\u00b4`<>]";
    public static final String[] PREFERENCE_cotf_elements_messages;
    public static final String[] PREFERENCE_cotf_parameters_messages;

    static {
        log = LoggerFactory.getLogger(Preferences.class);
        nPreferences_cotf_element_digits_max = 80;
        PREFERENCE_cotf_elements = new String[]{"constant1", "PID", "fn", "gn", "dob", "dt", "dk", "dguid", "random", "constant2"};
        PREFERENCE_cotf_parameters = new String[]{"fill_leading_char", "num_digits", "add_trailing_char"};
        PREFERENCE_cotf_elements_messages = new String[]{Messages.Preferences_cotf_constant1, Messages.Preferences_cotf_pid, Messages.Preferences_cotf_fn, Messages.Preferences_cotf_gn, Messages.Preferences_cotf_dob, Messages.Preferences_cotf_dt, Messages.Preferences_cotf_dk, Messages.Preferences_cotf_dguid, Messages.Preferences_cotf_random, Messages.Preferences_cotf_constant2};
        PREFERENCE_cotf_parameters_messages = new String[]{Messages.Preferences_cotf_fill_lead_char, Messages.Preferences_cotf_num_digits, Messages.Preferences_cotf_add_trail_char};
    }

    private static void initGlobalConfig() {
        if (fsSettingsStore == null) {
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/store_in_fs_global", (String)"ch.elexis.omnivore/store_in_fs_global", (boolean)true);
            CoreHubHelper.transformConfigKey((String)"ch.elexis.omnivore//store_in_fs_global", (String)"ch.elexis.omnivore/store_in_fs_global", (boolean)true);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/store_in_fs", (String)"ch.elexis.omnivore/store_in_fs", (boolean)true);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/store_in_fs", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/basepath", (String)"ch.elexis.omnivore/basepath", (boolean)true);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/basepath", (String)"ch.elexis.omnivore/basepath", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/categories", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/date_modifiable", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/columnwidths", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/savecolwidths", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/sortdirection", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            CoreHubHelper.transformConfigKey((String)"plugins/omnivore-direct/savesortdirection", (String)"ch.elexis.omnivore/store_in_fs", (boolean)false);
            boolean isGlobal = CoreHub.globalCfg.get("ch.elexis.omnivore/store_in_fs_global", false);
            fsSettingsStore = isGlobal ? new SettingsPreferenceStore(CoreHub.globalCfg) : new SettingsPreferenceStore(CoreHub.localCfg);
        }
    }

    public static boolean storeInFilesystem() {
        Preferences.initGlobalConfig();
        return fsSettingsStore.getBoolean("ch.elexis.omnivore/store_in_fs");
    }

    public static String getBasepath() {
        Preferences.initGlobalConfig();
        return fsSettingsStore.getString("ch.elexis.omnivore/basepath");
    }

    public static boolean getDateModifiable() {
        return CoreHub.localCfg.get("ch.elexis.omnivore/date_modifiable", false);
    }

    public static Integer getOmnivorenRulesForAutoArchiving() {
        Integer nRules = PreferenceConstants.nPREF_SRC_PATTERN;
        if (PreferenceConstants.nPREF_DEST_DIR > PreferenceConstants.nPREF_SRC_PATTERN) {
            nRules = PreferenceConstants.nPREF_DEST_DIR;
        }
        return nRules;
    }

    public static String getOmnivoreRuleForAutoArchivingSrcPattern(Integer i) {
        if (i < 0 || i >= Preferences.getOmnivorenRulesForAutoArchiving()) {
            return null;
        }
        if (PreferenceConstants.PREF_SRC_PATTERN[i].equals("")) {
            PreferenceConstants.PREF_SRC_PATTERN[i.intValue()] = "ch.elexis.omnivore/src_pattern" + i.toString().trim();
        }
        return CoreHub.localCfg.get(PreferenceConstants.PREF_SRC_PATTERN[i], "").trim();
    }

    public static String getOmnivoreRuleForAutoArchivingDestDir(Integer i) {
        if (i < 0 || i >= Preferences.getOmnivorenRulesForAutoArchiving()) {
            return null;
        }
        if (PreferenceConstants.PREF_DEST_DIR[i].equals("")) {
            PreferenceConstants.PREF_DEST_DIR[i.intValue()] = "ch.elexis.omnivore/dest_dir" + i.toString().trim();
        }
        return CoreHub.localCfg.get(PreferenceConstants.PREF_DEST_DIR[i], "").trim();
    }

    public static Integer getOmnivoreMax_Filename_Length() {
        SettingsPreferenceStore preferenceStore = new SettingsPreferenceStore(CoreHub.localCfg);
        int ret = preferenceStore.getInt("ch.elexis.omnivore/max_filename_length");
        if (ret == 0) {
            ret = PreferenceConstants.OmnivoreMax_Filename_Length_Default;
        }
        return ret;
    }

    public static void setFsSettingStore(SettingsPreferenceStore settingsPreferenceStore) {
        fsSettingsStore = settingsPreferenceStore;
    }

    public static SettingsPreferenceStore getFsSettingsStore() {
        return fsSettingsStore;
    }
}

