/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.data.services.IDocumentManager;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Patient;
import ch.elexis.data.Query;
import ch.elexis.omnivore.data.AutomaticBilling;
import ch.elexis.omnivore.data.DocHandle;
import ch.elexis.omnivore.data.Messages;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.RegexpFilter;
import ch.rgw.tools.TimeSpan;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DocumentManagement
implements IDocumentManager {
    public boolean addCategorie(String categorie) {
        DocHandle.addMainCategory(categorie);
        return true;
    }

    public String addDocument(IOpaqueDocument doc) throws ElexisException {
        return this.addDocument(doc, false);
    }

    public String addDocument(IOpaqueDocument doc, boolean automaticBilling) throws ElexisException {
        DocHandle dh = new DocHandle(doc);
        if (automaticBilling && AutomaticBilling.isEnabled()) {
            AutomaticBilling billing = new AutomaticBilling(dh);
            billing.bill();
        }
        return dh.getId();
    }

    public String[] getCategories() {
        return DocHandle.getMainCategoryNames().toArray(new String[0]);
    }

    public InputStream getDocument(String id) {
        DocHandle dh = DocHandle.load(id);
        byte[] cnt = dh.getContents();
        ByteArrayInputStream bais = new ByteArrayInputStream(cnt);
        return bais;
    }

    public List<IOpaqueDocument> listDocuments(Patient pat, String categoryMatch, String titleMatch, String keywordMatch, TimeSpan dateMatch, String contentsMatch) throws ElexisException {
        Query qbe = new Query(DocHandle.class);
        if (pat != null) {
            qbe.add("PatID", "=", pat.getId());
        }
        if (dateMatch != null) {
            String from = dateMatch.from.toString(9);
            String until = dateMatch.until.toString(9);
            qbe.add("Datum", ">=", from);
            qbe.add("Datum", "<=", until);
        }
        if (titleMatch != null) {
            if (titleMatch.matches("/.+/")) {
                qbe.addPostQueryFilter((IFilter)new RegexpFilter(titleMatch.substring(1, titleMatch.length() - 1)));
            } else {
                qbe.add("Titel", "=", titleMatch);
            }
        }
        if (keywordMatch != null) {
            if (keywordMatch.matches("/.+/")) {
                qbe.addPostQueryFilter((IFilter)new RegexpFilter(keywordMatch.substring(1, keywordMatch.length() - 1)));
            } else {
                qbe.add("Keywords", "LIKE", "%" + keywordMatch + "%");
            }
        }
        if (categoryMatch != null) {
            if (categoryMatch.matches("/.+/")) {
                qbe.addPostQueryFilter((IFilter)new RegexpFilter(categoryMatch.substring(1, categoryMatch.length() - 1)));
            } else {
                qbe.add("Cat", "=", categoryMatch);
            }
        }
        if (contentsMatch != null) {
            throw new ElexisException(this.getClass(), Messages.DocumentManagement_contentsMatchNotSupported, 5);
        }
        List dox = qbe.execute();
        ArrayList<IOpaqueDocument> ret = new ArrayList<IOpaqueDocument>(dox.size());
        for (DocHandle doc : dox) {
            ret.add(doc);
        }
        return ret;
    }

    public boolean removeDocument(String guid) {
        DocHandle dh = DocHandle.load(guid);
        if (dh != null && dh.exists() && !"1".equals(dh.getId())) {
            return dh.delete();
        }
        return false;
    }
}

