/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.text.IOpaqueDocument;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.Preferences;
import ch.elexis.omnivore.data.Utils;
import ch.elexis.omnivore.dialog.FileImportDialog;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.MimeTool;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocHandle
extends PersistentObject
implements IOpaqueDocument {
    private static Logger log = LoggerFactory.getLogger(DocHandle.class);
    private TimeTool toStringTool = new TimeTool();
    public static final String FLD_CAT = "Cat";
    public static final String FLD_TITLE = "Titel";
    public static final String FLD_MIMETYPE = "Mimetype";
    public static final String FLD_DOC = "Doc";
    public static final String FLD_PATH = "Path";
    public static final String FLD_KEYWORDS = "Keywords";
    public static final String FLD_PATID = "PatID";
    public static final String FLD_CREATION_DATE = "CreationDate";
    public static final String TABLENAME = "CH_ELEXIS_OMNIVORE_DATA";
    public static final String DBVERSION = "2.0.4";
    protected static final String VERSION = "1";
    public static final String createDB = "CREATE TABLE CH_ELEXIS_OMNIVORE_DATA (ID\t\t    VARCHAR(25) primary key,lastupdate   BIGINT,deleted      CHAR(1) default '0',PatID\t    VARCHAR(25),Datum\t\tCHAR(8),CreationDate CHAR(8),Category\t\tVARCHAR(80) default null,Title \t\tVARCHAR(255),Mimetype\t\tVARCHAR(255),Keywords\t\tVARCHAR(255),Path\t\t\tVARCHAR(255),Doc\t\t\tBLOB);CREATE INDEX OMN1 ON CH_ELEXIS_OMNIVORE_DATA (PatID);CREATE INDEX OMN2 ON CH_ELEXIS_OMNIVORE_DATA (Keywords);CREATE INDEX OMN3 ON CH_ELEXIS_OMNIVORE_DATA (Category);CREATE INDEX OMN4 ON CH_ELEXIS_OMNIVORE_DATA (Mimetype);CREATE INDEX OMN5 ON CH_ELEXIS_OMNIVORE_DATA (deleted);CREATE INDEX OMN6 ON CH_ELEXIS_OMNIVORE_DATA (Title);INSERT INTO CH_ELEXIS_OMNIVORE_DATA (ID, TITLE) VALUES ('1','2.0.4');";
    public static final String upd120 = "ALTER TABLE CH_ELEXIS_OMNIVORE_DATA MODIFY Mimetype VARCHAR(255);ALTER TABLE CH_ELEXIS_OMNIVORE_DATA MODIFY Keywords VARCHAR(255);ALTER TABLE CH_ELEXIS_OMNIVORE_DATA Modify Path VARCHAR(255);";
    public static final String upd200 = "ALTER TABLE CH_ELEXIS_OMNIVORE_DATA ADD Category VARCHAR(80) default null;CREATE INDEX OMN3 ON CH_ELEXIS_OMNIVORE_DATA (Category);ALTER TABLE CH_ELEXIS_OMNIVORE_DATA MODIFY Title VARCHAR(255);";
    public static final String upd201 = "ALTER TABLE CH_ELEXIS_OMNIVORE_DATA ADD lastupdate BIGINT default 0;";
    public static final String upd202 = "CREATE INDEX OMN4 ON CH_ELEXIS_OMNIVORE_DATA (Mimetype);";
    public static final String upd203 = "CREATE INDEX OMN5 ON CH_ELEXIS_OMNIVORE_DATA (deleted);CREATE INDEX OMN6 ON CH_ELEXIS_OMNIVORE_DATA (Title);";
    public static final String upd204 = "ALTER TABLE CH_ELEXIS_OMNIVORE_DATA ADD CreationDate CHAR(8);";
    private static List<DocHandle> main_categories = null;

    static {
        DocHandle.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATID, "Cat=Category", "Datum=S:D:Datum", "CreationDate=S:D:CreationDate", "Titel=Title", FLD_KEYWORDS, FLD_PATH, FLD_DOC, FLD_MIMETYPE});
        DocHandle start = DocHandle.load(VERSION);
        if (!DocHandle.tableExists((String)TABLENAME)) {
            DocHandle.init();
        } else {
            VersionInfo vi = new VersionInfo(start.get(FLD_TITLE));
            if (vi.isOlder(DBVERSION)) {
                if (vi.isOlder("1.1.0")) {
                    DocHandle.getConnection().exec("ALTER TABLE CH_ELEXIS_OMNIVORE_DATA ADD if not exists deleted CHAR(1) default '0';");
                }
                if (vi.isOlder("1.2.0")) {
                    DocHandle.createOrModifyTable((String)upd120);
                }
                if (vi.isOlder("2.0.0")) {
                    DocHandle.createOrModifyTable((String)upd200);
                }
                if (vi.isOlder("2.0.1")) {
                    DocHandle.createOrModifyTable((String)upd201);
                }
                if (vi.isOlder("2.0.2")) {
                    DocHandle.createOrModifyTable((String)upd202);
                }
                if (vi.isOlder("2.0.3")) {
                    DocHandle.createOrModifyTable((String)upd203);
                }
                if (vi.isOlder(DBVERSION)) {
                    DocHandle.createOrModifyTable((String)upd204);
                }
                start.set(FLD_TITLE, DBVERSION);
            }
        }
    }

    public DocHandle(IOpaqueDocument doc) throws ElexisException {
        this.create(doc.getGUID());
        String category = doc.getCategory();
        if (category == null || category.length() < 1) {
            category = DocHandle.getDefaultCategory().getCategoryName();
        } else {
            DocHandle.ensureCategoryAvailability(category);
        }
        this.set(new String[]{FLD_CAT, FLD_PATID, "Datum", FLD_CREATION_DATE, FLD_TITLE, FLD_KEYWORDS, FLD_MIMETYPE}, new String[]{category, doc.getPatient().getId(), doc.getCreationDate(), doc.getCreationDate(), doc.getTitle(), doc.getKeywords(), doc.getMimeType()});
        this.store(doc.getContentsAsBytes());
    }

    public DocHandle(String category, byte[] doc, Patient pat, String title, String mime, String keyw) {
        this(category, doc, pat, new Date(), title, mime, keyw);
    }

    public DocHandle(String category, byte[] doc, Patient pat, Date creationDate, String title, String mime, String keyw) {
        if (doc == null || doc.length == 0) {
            SWTHelper.showError((String)Messages.DocHandle_readErrorCaption, (String)Messages.DocHandle_readErrorText);
            return;
        }
        this.create(null);
        if (category == null || category.length() < 1) {
            category = DocHandle.getDefaultCategory().getCategoryName();
        } else {
            DocHandle.ensureCategoryAvailability(category);
        }
        if (creationDate == null) {
            creationDate = new Date();
        }
        if (category == null || category.length() == 0) {
            this.set(new String[]{FLD_PATID, "Datum", FLD_CREATION_DATE, FLD_TITLE, FLD_KEYWORDS, FLD_MIMETYPE}, new String[]{pat.getId(), new TimeTool().toString(4), new TimeTool(creationDate).toString(9), title, keyw, mime});
        } else {
            this.set(new String[]{FLD_CAT, FLD_PATID, "Datum", FLD_CREATION_DATE, FLD_TITLE, FLD_KEYWORDS, FLD_MIMETYPE}, new String[]{category, pat.getId(), new TimeTool().toString(4), new TimeTool(creationDate).toString(9), title, keyw, mime});
        }
        this.store(doc);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    protected DocHandle(String id) {
        super(id);
    }

    protected DocHandle() {
    }

    public static DocHandle getDefaultCategory() {
        Query qbe = new Query(DocHandle.class);
        qbe.add(FLD_MIMETYPE, "=", "text/category");
        qbe.add(FLD_TITLE, "=", "default");
        List qre = qbe.execute();
        if (qre.size() < 1) {
            DocHandle.addMainCategory("default");
            return DocHandle.getDefaultCategory();
        }
        return (DocHandle)((Object)qre.get(0));
    }

    public static void ensureCategoryAvailability(String categoryName) {
        List<DocHandle> ldh = DocHandle.getMainCategories();
        boolean found = false;
        for (DocHandle dh : ldh) {
            if (!dh.get(FLD_TITLE).equalsIgnoreCase(categoryName) && !dh.get(FLD_CAT).equalsIgnoreCase(categoryName)) continue;
            found = true;
        }
        if (found) {
            return;
        }
        DocHandle.addMainCategory(categoryName);
    }

    public static List<String> getMainCategoryNames() {
        List<DocHandle> dox = DocHandle.getMainCategories();
        ArrayList<String> ret = new ArrayList<String>(dox.size());
        for (DocHandle doch : dox) {
            ret.add(doch.get(FLD_TITLE));
        }
        return ret;
    }

    public static List<DocHandle> getMainCategories() {
        if (main_categories == null) {
            Query qbe = new Query(DocHandle.class);
            qbe.add(FLD_MIMETYPE, "=", "text/category");
            main_categories = qbe.execute();
        }
        return main_categories;
    }

    public static void addMainCategory(String name) {
        if (DocHandle.findCategory(name) == null) {
            DocHandle dh = new DocHandle();
            dh.create(null);
            dh.set(new String[]{FLD_TITLE, FLD_CAT, FLD_MIMETYPE}, new String[]{name, name, "text/category"});
            main_categories = null;
        }
    }

    private static String findCategory(String name) {
        List<DocHandle> categories = DocHandle.getMainCategories();
        for (DocHandle docHandle : categories) {
            String catName = docHandle.getCategoryName().toLowerCase();
            if (!catName.equals(name.toLowerCase())) continue;
            return docHandle.getCategory();
        }
        return null;
    }

    public static void renameCategory(String old, String newn) {
        String oldname = old.trim();
        String newName = newn.trim();
        if (DocHandle.findCategory(newName) == null) {
            DocHandle.getConnection().exec("update CH_ELEXIS_OMNIVORE_DATA set Category=" + JdbcLink.wrap((String)newName) + " where Category= " + JdbcLink.wrap((String)oldname));
            DocHandle.getConnection().exec("update CH_ELEXIS_OMNIVORE_DATA set Title=" + JdbcLink.wrap((String)newName) + " where Title=" + JdbcLink.wrap((String)oldname) + " and mimetype=" + JdbcLink.wrap((String)"text/category"));
            main_categories = null;
            log.info("Renaming category [{}], moving entries to category [{}]", (Object)old, (Object)newn);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Dochandle_errorCatNameAlreadyTaken, (String)MessageFormat.format(Messages.DocHandle_errorCatNameAlreadyTakenMsg, newName));
        }
        DocHandle.clearCache();
    }

    public static void removeCategory(String name, String destName) {
        DocHandle.getConnection().exec("update CH_ELEXIS_OMNIVORE_DATA set Category=" + JdbcLink.wrap((String)destName) + " where Category= " + JdbcLink.wrap((String)name));
        DocHandle.getConnection().exec("update CH_ELEXIS_OMNIVORE_DATA set deleted='1' where Title=" + JdbcLink.wrap((String)name) + " AND mimetype=" + JdbcLink.wrap((String)"text/category"));
        main_categories = null;
        log.info("Removing category [{}], moving entries to category [{}]", (Object)name, (Object)destName);
    }

    public static void init() {
        DocHandle.createOrModifyTable((String)createDB);
    }

    public static DocHandle load(String id) {
        return new DocHandle(id);
    }

    private void store(byte[] doc) {
        try {
            this.storeContent(doc);
        }
        catch (PersistenceException e) {
            SWTHelper.showError((String)Messages.DocHandle_writeErrorCaption, (String)(String.valueOf(Messages.DocHandle_writeErrorText) + "; " + e.getMessage()));
            this.delete();
        }
        catch (ElexisException e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError((String)Messages.DocHandle_73, (String)Messages.DocHandle_writeErrorHeading, (String)MessageFormat.format(String.valueOf(Messages.DocHandle_writeErrorText2) + e.getCause(), e.getMessage()));
            this.delete();
        }
    }

    public void storeContent(byte[] doc) throws PersistenceException, ElexisException {
        File file = this.getStorageFile(false);
        if (file == null) {
            this.setBinary(FLD_DOC, doc);
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));){
                    bout.write(doc);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new ElexisException(file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public File getStorageFile(boolean force) {
        if (force || Preferences.storeInFilesystem()) {
            File dir;
            String pathname = Preferences.getBasepath();
            if (pathname != null && (dir = new File(pathname)).isDirectory()) {
                Patient pat = Patient.load((String)this.get(FLD_PATID));
                File subdir = new File(dir, pat.getPatCode());
                if (!subdir.exists()) {
                    subdir.mkdir();
                }
                File file = new File(subdir, String.valueOf(this.getId()) + "." + FileTool.getExtension((String)this.get(FLD_MIMETYPE)));
                return file;
            }
            if (Preferences.storeInFilesystem()) {
                this.configError();
            }
        }
        return null;
    }

    public String getCategoryName() {
        return DocHandle.checkNull((Object)this.get(FLD_CAT));
    }

    public boolean isCategory() {
        return this.get(FLD_MIMETYPE).equals("text/category");
    }

    public DocHandle getCategoryDH() {
        List ret;
        String name = this.getCategoryName();
        if (!StringTool.isNothing((Object)name) && (ret = new Query(DocHandle.class, FLD_TITLE, name).execute()) != null && ret.size() > 0) {
            return (DocHandle)((Object)ret.get(0));
        }
        return null;
    }

    public List<DocHandle> getMembers(Patient pat) {
        Query qbe = new Query(DocHandle.class, FLD_CAT, this.get(FLD_TITLE));
        if (pat != null) {
            qbe.add(FLD_PATID, "=", pat.getId());
        }
        return qbe.execute();
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        String date = this.get("Datum");
        if (date != null && !date.isEmpty()) {
            sb.append(this.get("Datum"));
            sb.append(" ");
        }
        sb.append(this.get(FLD_TITLE));
        return sb.toString();
    }

    public String getTitle() {
        return this.get(FLD_TITLE);
    }

    public String getKeywords() {
        return this.get(FLD_KEYWORDS);
    }

    public String getDate() {
        this.toStringTool.set(this.get("Datum"));
        return this.toStringTool.toString(4);
    }

    public void setDate(Date d) {
        TimeTool tt = new TimeTool();
        tt.setTime(d);
        this.set("Datum", tt.toString(9));
    }

    public String getCreationDate() {
        this.toStringTool.set(this.get(FLD_CREATION_DATE));
        return this.toStringTool.toString(4);
    }

    public void setCreationDate(Date d) {
        TimeTool tt = new TimeTool();
        tt.setTime(d);
        this.set(FLD_CREATION_DATE, tt.toString(9));
    }

    public byte[] getContents() {
        File file;
        byte[] ret = this.getBinary(FLD_DOC);
        if (ret == null && (file = this.getStorageFile(true)) != null) {
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
                if (!Preferences.storeInFilesystem()) {
                    try {
                        this.setBinary(FLD_DOC, bytes);
                    }
                    catch (PersistenceException pe) {
                        SWTHelper.showError((String)Messages.DocHandle_readErrorCaption, (String)(String.valueOf(Messages.DocHandle_importErrorText) + "; " + pe.getMessage()));
                    }
                }
                return bytes;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.DocHandle_readErrorHeading, (String)Messages.DocHandle_importError2, (String)MessageFormat.format(String.valueOf(Messages.DocHandle_importErrorText2) + ex.getMessage(), file.getAbsolutePath()));
            }
        }
        return ret;
    }

    public void execute() {
        try {
            String ext = " ";
            File temp = this.createTemporaryFile(this.getTitle());
            log.debug("execute {} readable {}", (Object)temp.getAbsolutePath(), (Object)Files.isReadable(temp.toPath()));
            Program proggie = Program.findProgram((String)ext);
            if (proggie != null) {
                proggie.execute(temp.getAbsolutePath());
            } else if (!Program.launch((String)temp.getAbsolutePath())) {
                Runtime.getRuntime().exec(temp.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.DocHandle_runErrorHeading, (String)ex.getMessage());
        }
    }

    public File createTemporaryFile(String title) {
        String fileExtension;
        block16: {
            fileExtension = null;
            try {
                MimeType docMimeType = new MimeType(this.get(FLD_MIMETYPE));
                fileExtension = MimeTool.getExtension((String)docMimeType.toString());
            }
            catch (MimeTypeParseException mpe) {
                fileExtension = FileTool.getExtension((String)this.get(FLD_MIMETYPE));
                if (fileExtension != null) break block16;
                fileExtension = FileTool.getExtension((String)this.get(FLD_TITLE));
            }
        }
        if (fileExtension == null) {
            fileExtension = "";
        }
        String config_temp_filename = Utils.createNiceFileName(this);
        File temp = null;
        try {
            String cleanTitle;
            Path tmpDir = Files.createTempDirectory("elexis", new FileAttribute[0]);
            temp = config_temp_filename.length() > 0 ? new File(tmpDir.toString(), String.valueOf(config_temp_filename) + "." + fileExtension) : (title != null && !title.isEmpty() ? (!(cleanTitle = title.replaceAll(Matcher.quoteReplacement("[\\:/:*?()+,';\"\r\t\n\u00b4`<>]"), "_")).toLowerCase().contains("." + fileExtension.toLowerCase()) ? new File(tmpDir.toString(), String.valueOf(cleanTitle) + "." + fileExtension) : new File(tmpDir.toString(), cleanTitle)) : Files.createTempFile(tmpDir, "omni_", "_vore." + fileExtension, new FileAttribute[0]).toFile());
            tmpDir.toFile().deleteOnExit();
            temp.deleteOnExit();
            byte[] b = this.getContents();
            if (b == null) {
                SWTHelper.showError((String)Messages.DocHandle_readErrorCaption2, (String)Messages.DocHandle_loadErrorText);
                return temp;
            }
            Throwable throwable = null;
            Object var8_12 = null;
            try (FileOutputStream fos = new FileOutputStream(temp);){
                fos.write(b);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            log.debug("createTemporaryFile {} size {} ext {} ", new Object[]{temp.getAbsolutePath(), Files.size(temp.toPath()), fileExtension});
        }
        catch (FileNotFoundException e) {
            log.debug("File not found " + e, (Object)3);
        }
        catch (IOException e) {
            log.debug("Error creating file " + e, (Object)3);
        }
        return temp;
    }

    public String getMimetype() {
        return this.get(FLD_MIMETYPE);
    }

    public boolean storeExternal(String filename) {
        block14: {
            byte[] b = this.getContents();
            if (b == null) {
                SWTHelper.showError((String)Messages.DocHandle_readErrorCaption2, (String)Messages.DocHandle_couldNotLoadError);
                return false;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            FileOutputStream fos = new FileOutputStream(filename);
            try {
                fos.write(b);
                if (fos == null) break block14;
            }
            catch (Throwable throwable2) {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (IOException ios) {
                        ExHandler.handle((Throwable)ios);
                        SWTHelper.showError((String)Messages.DocHandle_writeErrorCaption2, (String)Messages.DocHandle_writeErrorCaption2, (String)ios.getMessage());
                        return false;
                    }
                }
            }
            fos.close();
        }
        return true;
    }

    public static List<DocHandle> assimilate(List<ImageData> images) {
        ArrayList<DocHandle> ret = new ArrayList<DocHandle>();
        FileImportDialog fid = new FileImportDialog(Messages.DocHandle_scannedImageDialogCaption);
        if (fid.open() == 0) {
            try {
                Document pdf = new Document(PageSize.A4);
                pdf.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(100000);
                PdfWriter.getInstance((Document)pdf, (OutputStream)baos);
                pdf.open();
                ImageLoader il = new ImageLoader();
                int i = 0;
                while (i < images.size()) {
                    ImageData[] id = new ImageData[]{images.get(i)};
                    il.data = id;
                    ByteArrayOutputStream bimg = new ByteArrayOutputStream();
                    il.save((OutputStream)bimg, 5);
                    Image image = Image.getInstance((byte[])bimg.toByteArray());
                    int width = id[0].width;
                    int height = id[0].height;
                    if (width > 595 || height > 841) {
                        image.scaleToFit(595.0f, 841.0f);
                    }
                    pdf.add((Element)image);
                    ++i;
                }
                pdf.close();
                DocHandle docHandle = new DocHandle(fid.category, baos.toByteArray(), ElexisEventDispatcher.getSelectedPatient(), fid.originDate, fid.title, "image.pdf", fid.keywords);
                Utils.archiveFile(docHandle.getStorageFile(true), docHandle);
                ret.add(docHandle);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.DocHandle_readError, (String)Messages.DocHandle_readErrorText2);
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocHandle assimilate(String f) {
        Patient act = ElexisEventDispatcher.getSelectedPatient();
        if (act == null) {
            SWTHelper.showError((String)Messages.DocHandle_noPatientSelected, (String)Messages.DocHandle_pleaseSelectPatient);
            return null;
        }
        File file = new File(f);
        if (!file.canRead()) {
            SWTHelper.showError((String)Messages.DocHandle_cantReadCaption, (String)MessageFormat.format(Messages.DocHandle_cantReadText, f));
            return null;
        }
        if (file.isDirectory()) {
            SWTHelper.showError((String)Messages.DocHandle_importErrorDirectory, (String)Messages.DocHandle_importErrorDirectoryText);
            return null;
        }
        FileImportDialog fid = new FileImportDialog(file.getName());
        if (fid.open() != 0) return null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                try {
                    block23: {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        while (true) {
                            int in;
                            if ((in = bis.read()) == -1) {
                                String nam = file.getName();
                                if (nam.length() <= 255) break;
                                SWTHelper.showError((String)Messages.DocHandle_readErrorCaption3, (String)Messages.DocHandle_fileNameTooLong);
                            }
                            baos.write(in);
                        }
                        String category = fid.category;
                        if (category == null || category.length() == 0) {
                            category = DocHandle.getDefaultCategory().getCategoryName();
                        }
                        DocHandle dh = new DocHandle(category, baos.toByteArray(), act, fid.originDate, fid.title, file.getName(), fid.keywords);
                        if (!Preferences.getDateModifiable()) return dh;
                        dh.setDate(fid.saveDate);
                        dh.setCreationDate(fid.originDate);
                        return dh;
                        finally {
                            if (baos == null) break block23;
                            baos.close();
                        }
                    }
                    if (bis == null) return null;
                    bis.close();
                    return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bis == null) throw throwable;
                    bis.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.DocHandle_readErrorCaption3, (String)Messages.DocHandle_readErrorText2);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocHandle assimilate(String f, String selectedCategory) {
        act = ElexisEventDispatcher.getSelectedPatient();
        if (act == null) {
            SWTHelper.showError((String)Messages.DocHandle_noPatientSelected, (String)Messages.DocHandle_pleaseSelectPatient);
            return null;
        }
        file = new File(f);
        if (!file.canRead()) {
            SWTHelper.showError((String)Messages.DocHandle_cantReadCaption, (String)String.format(Messages.DocHandle_cantReadMessage, new Object[]{f}));
            return null;
        }
        if (file.isDirectory()) {
            SWTHelper.showError((String)Messages.DocHandle_importErrorDirectory, (String)Messages.DocHandle_importErrorDirectoryText);
            return null;
        }
        maxOmnivoreFilenameLength = Preferences.getOmnivoreMax_Filename_Length();
        nam = file.getName();
        if (nam.length() > maxOmnivoreFilenameLength) {
            SWTHelper.showError((String)Messages.DocHandle_importErrorCaption, (String)MessageFormat.format(Messages.DocHandle_importErrorMessage, new Object[]{maxOmnivoreFilenameLength}));
            return null;
        }
        fid = selectedCategory == null ? new FileImportDialog(file.getName()) : new FileImportDialog(file.getName(), selectedCategory);
        dh = null;
        if (fid.open() != 0) return dh;
        try {
            var8_8 = null;
            var9_11 = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
                try {
                    block26: {
                        block24: {
                            baos = new ByteArrayOutputStream();
                            while (true) {
                                if ((in = bis.read()) == -1) {
                                    fileName = file.getName();
                                    if (fileName.length() <= 255) break;
                                    SWTHelper.showError((String)Messages.DocHandle_readErrorCaption, (String)Messages.DocHandle_fileNameTooLong);
                                }
                                baos.write(in);
                            }
                            category = fid.category;
                            if (category == null || category.length() == 0) {
                                category = DocHandle.getDefaultCategory().getCategoryName();
                            }
                            break block26;
                            finally {
                                if (baos == null) break block24;
                                baos.close();
                            }
                        }
                        if (bis != null) {
                            bis.close();
                        }
                        return null;
                    }
                    dh = new DocHandle(category, baos.toByteArray(), act, fid.title.trim(), file.getName(), fid.keywords.trim());
                    ** if (bis == null) goto lbl-1000
                }
                catch (Throwable var9_12) {
                    if (var8_8 == null) {
                        var8_8 = var9_12;
                    } else if (var8_8 != var9_12) {
                        var8_8.addSuppressed(var9_12);
                    }
                    if (bis == null) throw var8_8;
                    bis.close();
                    throw var8_8;
                }
lbl-1000:
                // 1 sources

                {
                    bis.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var9_13) {
                if (var8_8 == null) {
                    var8_8 = var9_13;
                    throw var8_8;
                }
                if (var8_8 == var9_13) throw var8_8;
                var8_8.addSuppressed(var9_13);
                throw var8_8;
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.DocHandle_importErrorCaption, (String)Messages.DocHandle_importErrorMessage2);
            return null;
        }
        Utils.archiveFile(file, dh);
        return dh;
    }

    private void configError() {
        SWTHelper.showError((String)"config error", (String)Messages.DocHandle_configErrorCaption, (String)Messages.DocHandle_configErrorText);
    }

    public String getCategory() {
        return this.getCategoryName();
    }

    public String getMimeType() {
        return DocHandle.checkNull((Object)this.get(FLD_MIMETYPE));
    }

    public Patient getPatient() {
        return Patient.load((String)this.get(FLD_PATID));
    }

    public InputStream getContentsAsStream() throws ElexisException {
        return new ByteArrayInputStream(this.getContents());
    }

    public byte[] getContentsAsBytes() throws ElexisException {
        return this.getContents();
    }

    public String getGUID() {
        return this.getId();
    }

    public boolean exportToFileSystem() {
        byte[] doc = this.getBinary(FLD_DOC);
        if (doc == null) {
            return true;
        }
        File file = this.getStorageFile(true);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(file));){
                bout.write(doc);
                this.setBinary(FLD_DOC, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ios) {
            ExHandler.handle((Throwable)ios);
            log.warn("Exporting dochandle [{}] to filesystem fails.", (Object)this.getId(), (Object)ios);
            SWTHelper.showError((String)Messages.DocHandle_writeErrorCaption2, (String)Messages.DocHandle_writeErrorCaption2, (String)ios.getMessage());
            return false;
        }
        return true;
    }
}

