/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.omnivore.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.core.data.interfaces.events.MessageEvent;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.omnivore.data.DocHandle;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.LoggerFactory;

public class AutomaticBilling {
    private static Executor executor = Executors.newSingleThreadExecutor();
    private Patient patient;
    private DocHandle docHandle;

    public static boolean isEnabled() {
        String blockId = CoreHub.localCfg.get("ch.elexis.omnivore/automatic_billing_block", "");
        return CoreHub.localCfg.get("ch.elexis.omnivore/automatic_billing", false) && !blockId.isEmpty();
    }

    public AutomaticBilling(DocHandle docHandle) {
        this.patient = docHandle.getPatient();
        this.docHandle = docHandle;
    }

    public void bill() {
        if (AutomaticBilling.isEnabled() && this.docHandle != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Konsultation encounter = AutomaticBilling.this.getEncounter();
                        if (encounter != null) {
                            Leistungsblock block = Leistungsblock.load((String)CoreHub.localCfg.get("ch.elexis.omnivore/automatic_billing_block", ""));
                            if (encounter != null && encounter.isEditable(false)) {
                                AutomaticBilling.this.addBlockToEncounter(block, encounter);
                            } else {
                                LoggerFactory.getLogger(this.getClass()).warn(String.format("Could not add block [%s] for document of patient [%s] because no valid kons found.", block.getName(), AutomaticBilling.this.patient.getLabel()));
                            }
                        }
                    }
                    catch (Exception e) {
                        ElexisEventDispatcher.getInstance().fireMessageEvent(new MessageEvent(MessageEvent.MessageType.ERROR, "Error", "Es ist ein Fehler bei der automatischen Verrechnung aufgetreten."));
                        LoggerFactory.getLogger(this.getClass()).error("Error billing block", (Throwable)e);
                    }
                }
            });
        }
    }

    private void addBlockToEncounter(Leistungsblock block, Konsultation encounter) {
        List elements = block.getElements(encounter);
        for (ICodeElement element : elements) {
            Result result;
            if (!(element instanceof PersistentObject) || (result = encounter.addLeistung((IVerrechenbar)element)).isOK()) continue;
            ElexisEventDispatcher.getInstance().fireMessageEvent(new MessageEvent(MessageEvent.MessageType.WARN, Messages.VerrechnungsDisplay_imvalidBilling, String.valueOf(this.patient.getLabel()) + "\nDokument import Verrechnung von [" + ((IVerrechenbar)element).getCode() + "]\n\n" + result.toString()));
        }
    }

    private Konsultation getEncounter() {
        Konsultation encounter = this.patient.getLastKonsultation();
        if (encounter == null || !encounter.isEditable(false)) {
            encounter = this.createEncounter();
        }
        return encounter;
    }

    private Konsultation createEncounter() {
        Konsultation lastEncounter = this.patient.getLastKonsultation();
        Fall fall = null;
        if (lastEncounter != null) {
            fall = lastEncounter.getFall();
        }
        if (fall == null || !fall.isOpen()) {
            List<Fall> openFall = this.getOpenFall();
            fall = openFall.isEmpty() ? this.patient.neuerFall(Fall.getDefaultCaseLabel(), Fall.getDefaultCaseReason(), Fall.getDefaultCaseLaw()) : openFall.get(0);
        }
        if (fall != null) {
            return fall.neueKonsultation();
        }
        return null;
    }

    private List<Fall> getOpenFall() {
        Fall[] faelle;
        ArrayList<Fall> ret = new ArrayList<Fall>();
        Fall[] fallArray = faelle = this.patient.getFaelle();
        int n = faelle.length;
        int n2 = 0;
        while (n2 < n) {
            Fall f = fallArray[n2];
            if (f.isOpen()) {
                ret.add(f);
            }
            ++n2;
        }
        ret.sort(new Comparator<Fall>(){
            TimeTool o1Begin = new TimeTool();
            TimeTool o2Begin = new TimeTool();

            @Override
            public int compare(Fall o1, Fall o2) {
                if (o1.getBeginnDatum() != null && o2.getBeginnDatum() != null) {
                    this.o1Begin.set(o1.getBeginnDatum());
                    this.o2Begin.set(o2.getBeginnDatum());
                    return this.o1Begin.compareTo((Calendar)this.o2Begin);
                }
                return Long.compare(o1.getLastUpdate(), o2.getLastUpdate());
            }
        });
        return ret;
    }
}

