/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.molemax.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Anwender;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.molemax.Messages;
import ch.elexis.molemax.data.Tracker;
import ch.elexis.molemax.views.AllSlotsDisplay;
import ch.elexis.molemax.views.BaseSelectorDialog;
import ch.elexis.molemax.views.RowDisplay;
import ch.elexis.molemax.views.TimeMachineDisplay;
import ch.rgw.tools.TimeTool;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Overview
extends ViewPart
implements IActivationListener {
    public static final String ID = "molemax.overview";
    Form form;
    FormToolkit tk;
    protected Tracker[][] trackers;
    private StackLayout stack;
    private Composite inlay;
    AllSlotsDisplay dispAll;
    RowDisplay dispRow;
    TimeMachineDisplay tmd;
    Patient pat;
    String date;
    Composite outer;
    private IAction selectDateAction;
    private IAction restoreAction;
    private final ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            Overview.this.setPatient((Patient)ev.getObject(), null);
        }
    };
    private final ElexisUiEventListenerImpl eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        public void runInUi(ElexisEvent ev) {
        }
    };

    public Overview() {
        this.tk = UiDesk.getToolkit();
    }

    public void createPartControl(Composite parent) {
        this.form = this.tk.createForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.inlay = new Composite(body, 2048);
        this.stack = new StackLayout();
        this.inlay.setLayout((Layout)this.stack);
        this.dispAll = new AllSlotsDisplay(this, this.inlay);
        this.dispRow = new RowDisplay(this, this.inlay);
        this.tmd = new TimeMachineDisplay(this, this.inlay);
        this.trackers = new Tracker[12][];
        this.outer = parent;
        this.date = new TimeTool().toString(9);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createMenu(new IAction[]{this.restoreAction});
        menu.createToolbar(new IAction[]{this.selectDateAction});
        this.setTopControl(this.dispAll);
        GlobalEventDispatcher.getInstance();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    public void dispose() {
        GlobalEventDispatcher.getInstance();
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        int i = 0;
        while (i < 12) {
            if (this.trackers[i] != null) {
                Tracker.dispose(this.trackers[i]);
            }
            ++i;
        }
        this.dispAll.dispose();
        this.dispRow.dispose();
        super.dispose();
    }

    void setTopControl(Composite top) {
        this.stack.topControl = top;
        ScrollBar sc = this.dispRow.right.getHorizontalBar();
        int sub = 12;
        if (sc != null) {
            Point pt = sc.getSize();
            sub += pt.y;
        }
        this.inlay.setSize(this.outer.getClientArea().width, this.outer.getClientArea().height - sub);
        this.inlay.layout();
    }

    public void setPatient(Patient p, String dat) {
        if (p == null) {
            this.form.setText(Messages.Overview_noPatient);
            return;
        }
        if (dat == null) {
            dat = Tracker.getLastSequenceDate(p);
        }
        if (p.equals((Object)this.pat) && dat.equals(this.date)) {
            return;
        }
        int i = 0;
        while (i < 12) {
            if (this.trackers[i] != null) {
                Tracker.dispose(this.trackers[i]);
            }
            ++i;
        }
        this.pat = p;
        this.date = dat;
        i = 0;
        while (i < 12) {
            Tracker base = Tracker.loadBase(p, this.date, i);
            this.trackers[i] = Tracker.getImageStack(base);
            ++i;
        }
        this.dispAll.reload();
        this.form.setText(p.getLabel());
        this.setTopControl(this.dispAll);
    }

    public void setFocus() {
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat, this.eeli_user});
        }
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
        if (template.equals(Patient.class)) {
            this.setPatient(null, null);
        }
    }

    public void selectionEvent(PersistentObject obj) {
        if (obj instanceof Anwender) {
            this.dispAll.setUser();
        }
        if (obj instanceof Patient) {
            this.setPatient((Patient)obj, null);
        }
    }

    private void makeActions() {
        this.selectDateAction = new Action(Messages.Overview_baseDate){
            {
                this.setImageDescriptor(Overview.getImageDescriptor("icons/notiz.png"));
                this.setToolTipText(Messages.Overview_selectSequence);
            }

            public void run() {
                BaseSelectorDialog bsd = new BaseSelectorDialog(Overview.this.getViewSite().getShell(), Overview.this.pat);
                if (bsd.open() == 0) {
                    Overview.this.setPatient(Overview.this.pat, bsd.ret);
                }
            }
        };
        this.restoreAction = new Action(Messages.Overview_restore){
            {
                this.setImageDescriptor(Overview.getImageDescriptor("icons/rescue.gif"));
                this.setToolTipText(Messages.Overview_restoresequence);
            }

            public void run() {
                DirectoryDialog dlg = new DirectoryDialog(UiDesk.getTopShell());
                dlg.setMessage("Geben Sie das Basisverzeichnis der zu importierenden Sequenz ein");
                dlg.setText("Bildsequenz rekonstruieren");
                String dirname = dlg.open();
                if (dirname != null) {
                    File dir = new File(dirname);
                    if (dir.getName().matches("20[0-9][0-9][01][0-9][0-3][0-9]")) {
                        File[] subdirs;
                        TimeTool ttDate = new TimeTool(dir.getName());
                        Overview.this.setPatient(Overview.this.pat, ttDate.toString(4));
                        File[] fileArray = subdirs = dir.listFiles();
                        int n = subdirs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File sub = fileArray[n2];
                            if (sub.getName().matches("[0-9]{1,2}")) {
                                File img;
                                File[] imgs = sub.listFiles();
                                boolean baseSet = false;
                                File[] fileArray2 = imgs;
                                int n3 = imgs.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    img = fileArray2[n4];
                                    if (img.getName().matches("base\\..+")) {
                                        Overview.this.dispAll.addImageFromSequence(Integer.parseInt(sub.getName()), img);
                                        baseSet = true;
                                    }
                                    ++n4;
                                }
                                if (baseSet) {
                                    fileArray2 = imgs;
                                    n3 = imgs.length;
                                    n4 = 0;
                                    while (n4 < n3) {
                                        img = fileArray2[n4];
                                        if (!img.getName().matches("base\\..+")) {
                                            Overview.this.dispAll.addImageFromSequence(Integer.parseInt(sub.getName()), img);
                                        }
                                        ++n4;
                                    }
                                }
                            }
                            ++n2;
                        }
                    } else {
                        SWTHelper.showError((String)"Import nicht m\u00f6glich", (String)"Der Verzeichnisname ist nicht yyyymmdd");
                    }
                }
            }
        };
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.molemax", (String)path);
    }
}

