/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labororder.lg1.order;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.LocalLock;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.hl7.data.HL7Kontakt;
import ch.elexis.hl7.data.HL7Kostentraeger;
import ch.elexis.hl7.data.HL7Mandant;
import ch.elexis.hl7.data.HL7Patient;
import ch.elexis.hl7.v26.HL7_OML_O21;
import ch.elexis.labororder.lg1.messages.Messages;
import ch.elexis.labororder.lg1.preferences.LG1PreferencePage;
import ch.elexis.tarmedprefs.TarmedRequirements;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LabOrderAction
extends Action {
    private static final String TEXT_ENCODING = "ISO-8859-1";

    public LabOrderAction() {
        this.setId("ch.elexis.laborder.lg1.laborder");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.labororder.lg1", (String)"rsc/lg1_logo.png"));
        this.setText(Messages.LabOrderAction_nameAction);
    }

    public void run() {
        Patient patient = ElexisEventDispatcher.getSelectedPatient();
        Kontakt costBearer = null;
        Kontakt rechnungsempfaenger = null;
        Date beginDate = null;
        String vnr = "";
        String plan = "";
        if (patient == null) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabOrderAction_errorTitleNoPatientSelected, (String)Messages.LabOrderAction_errorMessageNoPatientSelected);
        } else {
            Fall fall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            if (fall != null && fall.getPatient() != null && !patient.getId().equals(fall.getPatient().getId())) {
                fall = null;
            }
            if (fall == null) {
                Vector<Fall> offeneFaelleList = new Vector<Fall>();
                Fall[] fallArray = patient.getFaelle();
                int n = fallArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Fall tmpFall = fallArray[n2];
                    if (tmpFall.isOpen()) {
                        offeneFaelleList.add(tmpFall);
                    }
                    ++n2;
                }
                if (offeneFaelleList.size() == 1) {
                    fall = (Fall)offeneFaelleList.get(0);
                }
            }
            if (fall == null) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabOrderAction_errorTitleNoFallSelected, (String)Messages.LabOrderAction_errorMessageNoFallSelected);
            } else {
                costBearer = fall.getCostBearer();
                if (costBearer == null) {
                    costBearer = fall.getGarant();
                }
                if ((rechnungsempfaenger = fall.getRequiredContact("Rechnungsempf\u00e4nger")) == null) {
                    rechnungsempfaenger = fall.getGarant();
                }
                plan = fall.getAbrechnungsSystem();
                beginDate = new TimeTool(fall.getBeginnDatum()).getTime();
                vnr = this.getInsuranceOrCaseNumber(fall);
            }
        }
        boolean ok = false;
        long orderNr = -1L;
        String filenamePath = "-";
        if (patient != null && costBearer != null && (filenamePath = this.writeHL7File(patient, rechnungsempfaenger, costBearer, plan, beginDate, vnr, orderNr = this.getNextOrderNr(patient))) != null) {
            ok = true;
        }
        if (ok) {
            String patLabel = "-";
            if (patient != null) {
                patLabel = patient.getLabel();
            }
            String orderNrText = "";
            if (orderNr >= 0L) {
                orderNrText = new Long(orderNr).toString();
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.LabOrderAction_infoTitleLabOrderFinshed, (String)MessageFormat.format(Messages.LabOrderAction_infoMessageLabOrderFinshed, orderNrText, patLabel, filenamePath));
        }
    }

    private String getInsuranceOrCaseNumber(Fall fall) {
        String nummer = null;
        BillingLaw gesetz = fall.getConfiguredBillingSystemLaw();
        if (gesetz != null) {
            nummer = gesetz == BillingLaw.IVG ? fall.getRequiredString(TarmedRequirements.CASE_NUMBER) : (gesetz == BillingLaw.UVG ? fall.getRequiredString(TarmedRequirements.ACCIDENT_NUMBER) : fall.getRequiredString(TarmedRequirements.INSURANCE_NUMBER));
        }
        if (nummer == null) {
            nummer = fall.getInfoString(TarmedRequirements.CASE_NUMBER);
            if ("".equals(nummer)) {
                nummer = fall.getInfoString(TarmedRequirements.ACCIDENT_NUMBER);
            }
            if ("".equals(nummer)) {
                nummer = fall.getInfoString(TarmedRequirements.INSURANCE_NUMBER);
            }
        }
        return nummer;
    }

    private void fillHL7Kontakt(HL7Kontakt hl7Kontakt, Kontakt kontakt) {
        String name = kontakt.get("Bezeichnung1");
        if (name == null) {
            name = "";
        }
        hl7Kontakt.setName(name.trim());
        String firstname = kontakt.get("Bezeichnung2");
        if (firstname == null) {
            firstname = "";
        }
        hl7Kontakt.setFirstname(firstname.trim());
        String title = kontakt.get("Titel");
        if (title == null) {
            title = "";
        }
        hl7Kontakt.setTitle(title.trim());
        String phone1 = kontakt.get("Telefon1");
        if (phone1 == null) {
            phone1 = "";
        }
        hl7Kontakt.setPhone1(phone1.trim());
        String phone2 = kontakt.get("Telefon2");
        if (phone2 == null) {
            phone2 = "";
        }
        hl7Kontakt.setPhone2(phone2.trim());
        String email = kontakt.get("E-Mail");
        if (email == null) {
            email = "";
        }
        hl7Kontakt.setEmail(email.trim());
        String fax = kontakt.get("Fax");
        if (fax == null) {
            fax = "";
        }
        hl7Kontakt.setFax(fax.trim());
        String street = kontakt.get("Strasse");
        if (street == null) {
            street = "";
        }
        hl7Kontakt.setAddress1(street.trim());
        String other = kontakt.get("Bezeichnung3");
        if (other == null) {
            other = "";
        }
        hl7Kontakt.setAddress2(other.trim());
        String city = kontakt.get("Ort");
        if (city == null) {
            city = "";
        }
        hl7Kontakt.setCity(city.trim());
        String zip = kontakt.get("Plz");
        if (zip == null) {
            zip = "";
        }
        hl7Kontakt.setZip(zip.trim());
        String country = kontakt.get("Land");
        if (country == null) {
            country = "";
        }
        hl7Kontakt.setCountry(country.trim());
    }

    private String writeHL7File(Patient patient, Kontakt rechnungsempfaenger, Kontakt kostentraeger, String plan, Date beginDate, String vnr, long orderNr) {
        String uniqueMessageControlID = StringTool.unique((String)"MessageControlID");
        String uniqueProcessingID = StringTool.unique((String)"ProcessingID");
        HL7Mandant mandant = new HL7Mandant();
        Mandant actMandant = ElexisEventDispatcher.getSelectedMandator();
        if (actMandant != null) {
            mandant.setLabel(actMandant.get("Label"));
            mandant.setEan(actMandant.getXid("www.xid.ch/id/ean"));
        }
        HL7_OML_O21 omlO21 = new HL7_OML_O21("CHELEXIS", "PATDATA", Messages.LabOrderAction_receivingApplication, "", Messages.LabOrderAction_receivingFacility, uniqueMessageControlID, uniqueProcessingID, mandant);
        HL7Patient hl7Patient = new HL7Patient();
        this.fillHL7Kontakt((HL7Kontakt)hl7Patient, (Kontakt)patient);
        String geschlecht = patient.getGeschlecht();
        if (geschlecht != null && geschlecht.length() > 0) {
            hl7Patient.setIsMale(Boolean.valueOf("m".toUpperCase().equals(patient.getGeschlecht().toUpperCase())));
        }
        hl7Patient.setBirthdate(new TimeTool(patient.getGeburtsdatum()).getTime());
        hl7Patient.setPatCode(patient.getPatCode());
        HL7Kostentraeger hl7Rechnungsempfaenger = new HL7Kostentraeger();
        this.fillHL7Kontakt((HL7Kontakt)hl7Rechnungsempfaenger, rechnungsempfaenger);
        hl7Rechnungsempfaenger.setEan(rechnungsempfaenger.getXid("www.xid.ch/id/ean"));
        HL7Kostentraeger hl7Kostentraeger = new HL7Kostentraeger();
        this.fillHL7Kontakt((HL7Kontakt)hl7Kostentraeger, kostentraeger);
        hl7Kostentraeger.setEan(kostentraeger.getXid("www.xid.ch/id/ean"));
        try {
            String encodedMessage = omlO21.createText(hl7Patient, hl7Rechnungsempfaenger, hl7Kostentraeger, plan, beginDate, vnr, orderNr);
            String filename = String.valueOf(new Long(orderNr).toString()) + "_" + patient.get("PatientNr") + ".hl7";
            File hl7File = new File(String.valueOf(LG1PreferencePage.getUploadDir()) + File.separator + filename);
            FileTool.writeFile((File)hl7File, (byte[])encodedMessage.getBytes(TEXT_ENCODING));
            return hl7File.getPath();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)MessageFormat.format(Messages.LabOrderAction_errorTitleCannotCreateHL7, omlO21.getVersion()), (String)e.getMessage());
            return null;
        }
    }

    private long getNextOrderNr(Patient patient) throws NumberFormatException {
        LocalLock lock = new LocalLock((Object)"ch.elexis.labororder.lg1.nextOrderNr");
        try {
            Integer intValue;
            while (!lock.tryLock()) {
                long millis = lock.getLockCurrentMillis();
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (millis != lock.getLockCurrentMillis()) continue;
                lock.unlock();
            }
            String value = CoreHub.globalCfg.get("ch.elexis.labororder.lg1.orderNr", "0");
            Integer n = intValue = Integer.valueOf(value);
            intValue = n + 1;
            long ret = n.intValue();
            CoreHub.globalCfg.set("ch.elexis.labororder.lg1.orderNr", Integer.toString(intValue));
            long l = ret;
            return l;
        }
        finally {
            lock.unlock();
        }
    }
}

