/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.labor.viollier.v2.labimport;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabItemResolver;
import ch.elexis.core.model.ILabOrder;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.importer.div.importers.TestHL7Parser;
import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.LabOrder;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Xid;
import ch.elexis.hl7.model.AbstractData;
import ch.elexis.hl7.model.ObservationMessage;
import ch.elexis.hl7.v22.HL7_ORU_R01;
import ch.elexis.importers.openmedical.MedTransfer;
import ch.elexis.labor.viollier.v2.Messages;
import ch.elexis.labor.viollier.v2.ViollierActivator;
import ch.elexis.labor.viollier.v2.data.ViollierLaborImportSettings;
import ch.elexis.labor.viollier.v2.labimport.PatientLabor;
import ch.elexis.laborimport.viollier.v2.data.KontaktOrderManagement;
import ch.elexis.laborimport.viollier.v2.data.LaborwerteOrderManagement;
import ch.elexis.laborimport.viollier.v2.util.ViollierLogger;
import ch.rgw.io.FileTool;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabOrderImport
extends ImporterPage {
    private static String DOMAIN_VIONR = "viollier.ch/vioNumber";
    public static final String ORDER_NR_DOMAIN_FILLER = "7601002132732";
    private static String KUERZEL = Messages.PatientLabor_kuerzelViollier;
    private boolean doAllFiles = true;
    private Text tSingleHL7Filename;
    private String singleHL7Filename = "";
    private Button bOverwrite;
    private Button bFile;
    private Button bDirect;
    private boolean settingProcessMode = false;
    private boolean settingOverwrite = false;
    private static TimeTool dateTime = new TimeTool();
    private static HL7Parser hlp = new DefaultHL7Parser(KUERZEL);
    protected final SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private ViollierLaborImportSettings settings;

    public static void setTestMode(boolean value) {
        hlp = value ? new TestHL7Parser(KUERZEL) : new DefaultHL7Parser(KUERZEL);
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        ViollierLogger.getLogger().backupLog(this.settings.getDirArchive());
        ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_StartImport, this.df.format(new Date())));
        ViollierLogger.getLogger().println("==============================================================");
        File downloadDir = null;
        boolean refRangeMismatch = false;
        int errorCount = 0;
        int errorMovedCount = 0;
        if (this.settings == null) {
            this.settings = new ViollierLaborImportSettings(CoreHub.actMandant);
        }
        File[] hl7Files = null;
        if (this.doAllFiles) {
            ViollierLogger.getLogger().println(Messages.LabOrderImport_StartMedTransfer);
            int count = MedTransfer.doDownload(this.settings.getJMedTransferJar(), this.settings.getDirDownload(), this.settings.getGlobalJMedTransferParam());
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoNumberDonloadedFiles, count));
            downloadDir = new File(this.settings.getDirDownload());
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoReadDownloadDir, downloadDir));
            if (downloadDir.isDirectory()) {
                hl7Files = downloadDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".hl7");
                    }
                });
            }
        } else {
            try {
                File file = new File(this.singleHL7Filename);
                if (file.isFile()) {
                    downloadDir = file.getParentFile();
                }
                hl7Files = new File[]{file};
            }
            catch (Exception file) {
                // empty catch block
            }
            if (hl7Files == null) {
                String err = MessageFormat.format(Messages.LabOrderImport_ErrorFileNotFound, this.singleHL7Filename);
                ViollierLogger.getLogger().println(err);
                SWTHelper.showError((String)Messages.LabOrderImport_errorTitle, (String)err);
            }
        }
        if (hl7Files != null) {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoProcessFiles, hl7Files.length));
            monitor.beginTask(Messages.LabOrderImport_monitorImportiereHL7, hl7Files.length);
            if (hl7Files != null) {
                File[] fileArray = hl7Files;
                int n = hl7Files.length;
                int n2 = 0;
                while (n2 < n) {
                    File hl7File = fileArray[n2];
                    if (monitor.isCanceled()) break;
                    String msg = MessageFormat.format(Messages.LabOrderImport_InfoParseFile, hl7File.getName());
                    ViollierLogger.getLogger().println(msg);
                    monitor.subTask(msg);
                    AtomicReference<File> pdfFileRef = new AtomicReference<File>();
                    SaveResult importResult = LabOrderImport.doImportOneFile(hl7File, pdfFileRef, this.settings, this.settingOverwrite);
                    File pdfFile = pdfFileRef.get();
                    if (importResult != SaveResult.ERROR) {
                        if (this.doAllFiles) {
                            this.moveToArchiv(hl7File);
                            if (pdfFile != null) {
                                this.moveToArchiv(pdfFile);
                            }
                        }
                    } else {
                        if (this.doAllFiles) {
                            if (this.moveToError(hl7File)) {
                                ++errorMovedCount;
                            }
                            if (pdfFile != null) {
                                this.moveToError(pdfFile);
                            }
                        }
                        ++errorCount;
                        monitor.subTask(MessageFormat.format(Messages.LabOrderImport_ErrorWhileParsingHL7File, hl7File.getName()));
                    }
                    ViollierLogger.getLogger().println("--------------------------------------------------");
                    monitor.worked(1);
                    ++n2;
                }
            }
        }
        if (errorCount > 0) {
            String errorDir = this.settings.getDirError();
            SWTHelper.showError((String)Messages.LabOrderImport_errorTitle, (String)MessageFormat.format(Messages.LabOrderImport_errorMsgVerarbeitung, errorCount, errorMovedCount, errorDir));
        } else if (refRangeMismatch) {
            SWTHelper.showInfo((String)Messages.LabOrderImport_ReferenceRangeWarningTitle, (String)(String.valueOf(Messages.LabOrderImport_ReferenceRangeWarningText) + ViollierLogger.getLogger().getLocation() + "'"));
        } else {
            SWTHelper.showInfo((String)Messages.LabOrderImport_ImportCompletedTitle, (String)(String.valueOf(Messages.LabOrderImport_ImportCompletedSSuccessText) + ViollierLogger.getLogger().getLocation() + "'"));
        }
        ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_EndImport, this.df.format(new Date())));
        ViollierLogger.getLogger().println("");
        this.deleteOldArchivFiles();
        return Status.OK_STATUS;
    }

    public static SaveResult doImportOneFile(File hl7File, AtomicReference<File> pdfFileRef, ViollierLaborImportSettings settings, boolean overwriteOlderEntries) throws IOException {
        return LabOrderImport.doImportOneFile(hl7File, pdfFileRef, settings, overwriteOlderEntries, true);
    }

    public static SaveResult doImportOneFile(File hl7File, AtomicReference<File> pdfFileRef, ViollierLaborImportSettings settings, boolean overwriteOlderEntries, boolean askUser) throws IOException {
        String crit4;
        String crit1;
        File[] pdfFiles;
        SaveResult saveResult = SaveResult.ERROR;
        HL7_ORU_R01 hl7OruR01 = new HL7_ORU_R01();
        ObservationMessage observation = null;
        Patient patient = null;
        PatientLabor labor = null;
        String orderId = null;
        File downloadDir = hl7File.getParentFile();
        try {
            String text = FileTool.readTextFile((File)hl7File, (String)ViollierActivator.TEXT_ENCODING);
            observation = hl7OruR01.readObservation(text);
            saveResult = SaveResult.SUCCESS;
            for (String error : hl7OruR01.getErrorList()) {
                saveResult = SaveResult.ERROR;
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_Error, error));
            }
            for (String warn : hl7OruR01.getWarningList()) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_Warning, warn));
            }
            if (saveResult == SaveResult.SUCCESS) {
                patient = LabOrderImport.getPatient(observation, askUser);
                if (patient != null) {
                    List orders;
                    Object obj;
                    labor = new PatientLabor(patient);
                    Result result = hlp.importFile(hl7File, new File(settings.getDirArchive()), new ILabItemResolver(){

                        public String getTestName(AbstractData data) {
                            return data.getName();
                        }

                        public String getTestGroupName(AbstractData data) {
                            return "Labor Viollier";
                        }

                        public String getNextTestGroupSequence(AbstractData data) {
                            return PatientLabor.DEFAULT_PRIO;
                        }
                    }, false);
                    if (result.isOK() && (obj = result.get()) instanceof String && (orders = LabOrder.getLabOrdersByOrderId((String)((String)obj))) != null && !orders.isEmpty()) {
                        LabOrderImport.resolveTimeForPdf((LabResult)((ILabOrder)orders.get(0)).getLabResult(), observation);
                        for (ILabOrder labOrder : orders) {
                            new LaborwerteOrderManagement(labOrder.getLabResult().getId(), orderId);
                        }
                    }
                    orderId = LabOrderImport.getAuftragsId(observation);
                    if (!observation.getAlternatePatientId().isEmpty()) {
                        LabOrderImport.addVioNumber(observation.getAlternatePatientId(), patient);
                    }
                } else {
                    saveResult = SaveResult.ERROR;
                }
            }
        }
        catch (ElexisException ex) {
            saveResult = SaveResult.ERROR;
            String cause = "";
            if (ex.getCause() != null && ex.getCause().getMessage() != null) {
                cause = ex.getCause().getMessage();
            }
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorHL7Exception, ex.getMessage(), cause));
        }
        catch (Exception ex) {
            saveResult = SaveResult.ERROR;
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_Error, String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage()));
        }
        if (patient != null && labor != null && observation != null && (pdfFiles = downloadDir.listFiles(new FilenameFilter(crit1 = observation.getMessageControlID(), crit4 = observation.getPatientBirthdate()){
            private final /* synthetic */ String val$crit1;
            private final /* synthetic */ String val$crit4;
            {
                this.val$crit1 = string;
                this.val$crit4 = string2;
            }

            @Override
            public boolean accept(File dir, String name) {
                String[] items;
                boolean crit1found = false;
                boolean crit4found = false;
                if (name.toLowerCase().endsWith(".pdf") && (items = name.toLowerCase().split("[_]")).length > 2) {
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equalsIgnoreCase(this.val$crit1)) {
                            crit1found = true;
                        } else if (items[i].equalsIgnoreCase(this.val$crit4)) {
                            crit4found = true;
                        }
                        ++i;
                    }
                }
                return crit1found && crit4found;
            }
        })).length > 0) {
            if (pdfFiles.length > 1) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorMultiplePDFFilesFound, pdfFiles.length));
            } else {
                File pdfFile = pdfFiles[0];
                pdfFileRef.set(pdfFile);
                String filename = pdfFile.getName();
                SimpleDateFormat sdfTitle = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String title = String.valueOf(Messages.LabOrderImport_LabResult) + sdfTitle.format(dateTime.getTime()) + "." + FileTool.getExtension((String)filename);
                labor.saveLaborItem(title, settings.getDocumentCategory(), pdfFile, dateTime.getTime(), orderId, filename, "", "");
            }
        }
        return saveResult;
    }

    private static void resolveTimeForPdf(LabResult labResult, ObservationMessage observation) {
        boolean timeSet = false;
        if (labResult != null) {
            TimeTool obsTime = labResult.getObservationTime();
            if (obsTime != null) {
                dateTime.set(obsTime);
                timeSet = true;
            } else if (labResult.getAnalyseTime() != null) {
                dateTime.set(labResult.getAnalyseTime());
                timeSet = true;
            } else if (labResult.getTransmissionTime() != null) {
                dateTime.set(labResult.getTransmissionTime());
                timeSet = true;
            }
        }
        if (!timeSet) {
            Date timeStamp = observation.getDateTimeOfTransaction();
            if (timeStamp == null && (timeStamp = observation.getDateTimeOfMessage()) == null) {
                timeStamp = new Date();
            }
            dateTime.setTime(timeStamp);
        }
    }

    private void deleteOldArchivFiles() {
        int archivDeleted = 0;
        ViollierLogger.getLogger().println(Messages.LabOrderImport_InfoPurgingArchiveDir);
        int days = this.settings.getArchivePurgeInterval();
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, -days);
        long lastTime = cal.getTime().getTime();
        String archivDirName = this.settings.getDirArchive();
        if (archivDirName != null) {
            File archivDir = new File(archivDirName);
            if (archivDir.exists() && archivDir.isDirectory()) {
                File[] fileArray = archivDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File archivFile = fileArray[n2];
                    if (archivFile.lastModified() < lastTime && archivFile.delete()) {
                        ++archivDeleted;
                    }
                    ++n2;
                }
            }
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_PurgeArchiveDir, archivDeleted));
        }
        ViollierLogger.getLogger().println("");
    }

    private boolean moveToArchiv(File file) {
        String archivDir = this.settings.getDirArchive();
        boolean ok = false;
        if (FileTool.copyFile((File)file, (File)new File(String.valueOf(archivDir) + File.separator + file.getName()), (int)0)) {
            ok = file.delete();
        }
        return ok;
    }

    private boolean moveToError(File file) {
        String errorDir = this.settings.getDirError();
        boolean ok = false;
        if (errorDir != null && errorDir.length() > 0 && FileTool.copyFile((File)file, (File)new File(String.valueOf(errorDir) + File.separator + file.getName()), (int)0)) {
            ok = file.delete();
        }
        return ok;
    }

    private static SaveResult addVioNumber(String vioNumber, Patient patient) {
        SaveResult retVal = SaveResult.ERROR;
        try {
            Xid.localRegisterXIDDomainIfNotExists((String)DOMAIN_VIONR, (String)"vioNumber", (int)1);
            if ("".equals(LabOrderImport.getVioNr(patient))) {
                new Xid((PersistentObject)patient, DOMAIN_VIONR, vioNumber);
                retVal = SaveResult.SUCCESS;
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoSaveXid, vioNumber, patient.getId(), patient.getLabel()));
            }
            return retVal;
        }
        catch (Xid.XIDException e) {
            e.printStackTrace();
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorSaveXid, vioNumber, patient.getId(), patient.getLabel(), e.getMessage()));
            return retVal;
        }
    }

    private static List<Patient> readPatienten(String patId) {
        Query patientQuery = new Query(Patient.class);
        patientQuery.add("PatientNr", "=", patId);
        return patientQuery.execute();
    }

    public static List<Patient> readPatienten(String patNachname, String patVorname, String patBirthday, String patSex) {
        String sex = patSex.toLowerCase();
        if ("f".equals(sex)) {
            sex = "w";
        }
        Query patientQuery = new Query(Patient.class);
        patientQuery.add("Name", "=", patNachname);
        patientQuery.add("Vorname", "=", patVorname);
        patientQuery.add("Geschlecht", "=", sex);
        patientQuery.add("Geburtsdatum", "=", patBirthday);
        return patientQuery.execute();
    }

    private static Patient getPatient(ObservationMessage observation, boolean askUser) {
        Patient patient = null;
        boolean fillerAuftragExists = false;
        String patientId = observation.getPatientId();
        String auftragsNrPlacerString = observation.getOrderNumberPlacer();
        String auftragsNrFillerString = observation.getOrderNumberFiller();
        long auftragsNrPlacer = -1L;
        if (auftragsNrPlacerString != null && auftragsNrPlacerString.length() > 0) {
            try {
                auftragsNrPlacer = Long.parseLong(auftragsNrPlacerString);
            }
            catch (Exception ex) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorNonNumericPlacerOrderNumber, auftragsNrPlacerString, patientId));
                return null;
            }
        }
        long auftragsNrFiller = -1L;
        if (auftragsNrFillerString != null && auftragsNrFillerString.length() > 0) {
            try {
                auftragsNrFiller = Long.parseLong(auftragsNrFillerString);
            }
            catch (Exception ex) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorNonNumericFillerOrderNumber, auftragsNrFillerString, patientId));
                return null;
            }
        }
        if (auftragsNrPlacer > 0L) {
            Query patientOrderNrQuery = new Query(KontaktOrderManagement.class);
            patientOrderNrQuery.add("ORDER_NR", "=", auftragsNrPlacerString);
            List patientOrderNrList = patientOrderNrQuery.execute();
            if (patientOrderNrList.size() > 0) {
                List<Patient> patientList = LabOrderImport.readPatienten(patientId);
                for (KontaktOrderManagement kontaktOrderMgt : patientOrderNrList) {
                    String kontaktId = kontaktOrderMgt.getKontaktId();
                    for (Patient pat : patientList) {
                        if (!kontaktId.equals(pat.getId())) continue;
                        patient = pat;
                    }
                }
                if (patient == null) {
                    patient = LabOrderImport.findPatient(observation, askUser);
                }
                if (patient == null) {
                    ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorMatchingPatientWithOrderNr, auftragsNrPlacerString, patientId));
                }
            }
        } else if (auftragsNrFiller > 0L) {
            List<KontaktOrderManagement> patientOrderNrList = LabOrderImport.getByNumberAndDomain(Long.toString(auftragsNrFiller), ORDER_NR_DOMAIN_FILLER);
            if (patientOrderNrList.size() > 0) {
                fillerAuftragExists = true;
                List<Patient> patientList = LabOrderImport.readPatienten(patientId);
                for (KontaktOrderManagement kontaktOrderMgt : patientOrderNrList) {
                    String kontaktId = kontaktOrderMgt.getKontaktId();
                    for (Patient pat : patientList) {
                        if (!kontaktId.equals(pat.getId())) continue;
                        patient = pat;
                    }
                }
            }
            if (patient == null) {
                patient = LabOrderImport.findPatient(observation, askUser);
            }
            if (patient == null) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorMatchingPatientWithOrderNr, auftragsNrFillerString, patientId));
            }
        } else {
            String patName = observation.getPatientName();
            List<Patient> patientList = LabOrderImport.readPatienten(patientId);
            for (Patient listPat : patientList) {
                if (!patName.equalsIgnoreCase(String.valueOf(listPat.getName()) + " " + listPat.getVorname())) continue;
                patient = listPat;
            }
            if (patient == null) {
                patient = LabOrderImport.findPatient(observation, askUser);
            }
        }
        if (patient == null) {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_ErrorIdentifyingPatient, observation.getPatientName(), patientId, auftragsNrPlacerString, auftragsNrFillerString));
        } else if (!fillerAuftragExists && auftragsNrFiller > 0L) {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoStoredFillerOrderNr, auftragsNrFillerString, patientId, patient.getLabel()));
            List<KontaktOrderManagement> orders = LabOrderImport.getByNumberAndDomain(auftragsNrFillerString, ORDER_NR_DOMAIN_FILLER);
            if (orders.isEmpty()) {
                new KontaktOrderManagement((Kontakt)patient, auftragsNrFillerString, ORDER_NR_DOMAIN_FILLER);
            }
        }
        return patient;
    }

    private static List<KontaktOrderManagement> getByNumberAndDomain(String number, String domain) {
        Query patientOrderNrQuery = new Query(KontaktOrderManagement.class);
        patientOrderNrQuery.add("ORDER_NR", "=", number);
        patientOrderNrQuery.add("ORDER_NR_DOMAIN", "=", ORDER_NR_DOMAIN_FILLER);
        return patientOrderNrQuery.execute();
    }

    public String getTitle() {
        return Messages.LabOrderImport_titleImport;
    }

    public String getDescription() {
        return Messages.LabOrderImport_descriptionImport;
    }

    public Composite createPage(final Composite parent) {
        if (this.settings == null) {
            this.settings = new ViollierLaborImportSettings(CoreHub.actMandant);
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.bOverwrite = new Button(composite, 32);
        this.bOverwrite.setText(Messages.LabOrderImport_OverwriteOlderValues);
        this.bOverwrite.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        GridData gd = SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)false);
        gd.horizontalAlignment = 3;
        gd.widthHint = this.bOverwrite.getSize().x + 20;
        this.bFile = new Button(composite, 16);
        this.bFile.setText(Messages.LabOrderImport_ImportFromHL7);
        this.bFile.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label lFile = new Label(composite, 0);
        lFile.setText(Messages.LabOrderImport_HL7File);
        this.tSingleHL7Filename = new Text(composite, 2048);
        this.tSingleHL7Filename.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Button bBrowse = new Button(composite, 8);
        bBrowse.setText(Messages.LabOrderImport_Browse);
        this.bDirect = new Button(composite, 16);
        this.bDirect.setText(Messages.LabOrderImport_AutomaticMedTransfer);
        this.bDirect.setLayoutData((Object)SWTHelper.getFillGridData((int)3, (boolean)true, (int)1, (boolean)false));
        Label lblJMedTransfer = new Label(composite, 0);
        lblJMedTransfer.setText(Messages.LabOrderImport_JMedTransfer);
        Text txtJMedTransfer = new Text(composite, 2056);
        txtJMedTransfer.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String jmedTransfer = String.valueOf(this.settings.getJMedTransferJar()) + " " + this.settings.getJMedTransferParam();
        if (jmedTransfer != null) {
            txtJMedTransfer.setText(jmedTransfer);
        }
        new Label(composite, 0);
        Label lblDirDownload = new Label(composite, 0);
        lblDirDownload.setText(Messages.Preferences_DirDownload);
        final Text txtDirDownload = new Text(composite, 2056);
        txtDirDownload.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String dirDownload = this.settings.getDirDownload();
        if (dirDownload != null) {
            txtDirDownload.setText(dirDownload);
        }
        new Label(composite, 0);
        Label lblDirArchive = new Label(composite, 0);
        lblDirArchive.setText(Messages.Preferences_DirArchive);
        Text txtDirArchive = new Text(composite, 2056);
        txtDirArchive.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String dirArchive = this.settings.getDirArchive();
        if (dirArchive != null) {
            txtDirArchive.setText(dirArchive);
        }
        new Label(composite, 0);
        Label lblDirError = new Label(composite, 0);
        lblDirError.setText(Messages.Preferences_DirError);
        Text txtDirError = new Text(composite, 2056);
        txtDirError.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String dirError = this.settings.getDirError();
        if (dirError != null) {
            txtDirError.setText(dirError);
        }
        new Label(composite, 0);
        Label lblKategorie = new Label(composite, 0);
        lblKategorie.setText(Messages.Preferences_DocumentCategory);
        Text txtKategorie = new Text(composite, 2056);
        txtKategorie.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        String kategorie = this.settings.getDocumentCategory();
        if (kategorie != null) {
            txtKategorie.setText(kategorie);
        }
        this.setProcessModeAllFiles();
        this.bOverwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button == LabOrderImport.this.bOverwrite) {
                    LabOrderImport.this.settingOverwrite = button.getSelection();
                }
            }
        });
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    LabOrderImport.this.settingProcessMode = true;
                    if (button == LabOrderImport.this.bFile) {
                        LabOrderImport.this.setProcessModeSingleFile();
                    }
                    if (button == LabOrderImport.this.bDirect) {
                        LabOrderImport.this.setProcessModeAllFiles();
                    }
                    LabOrderImport.this.settingProcessMode = false;
                }
            }
        };
        this.bFile.addSelectionListener((SelectionListener)sa);
        this.bDirect.addSelectionListener((SelectionListener)sa);
        bBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fdl = new FileDialog(parent.getShell(), 4096);
                fdl.setFilterExtensions(new String[]{"*.hl7", "*"});
                fdl.setFilterNames(new String[]{Messages.LabOrderImport_HL7Files, Messages.LabOrderImport_AllFiles});
                fdl.setFilterPath(txtDirDownload.getText());
                LabOrderImport.this.singleHL7Filename = fdl.open();
                if (LabOrderImport.this.singleHL7Filename == null) {
                    LabOrderImport.this.singleHL7Filename = "";
                }
                LabOrderImport.this.tSingleHL7Filename.setText(LabOrderImport.this.singleHL7Filename);
                LabOrderImport.this.setProcessModeSingleFile();
            }
        });
        this.tSingleHL7Filename.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                LabOrderImport.this.setProcessModeSingleFile();
                LabOrderImport.this.singleHL7Filename = LabOrderImport.this.tSingleHL7Filename.getText();
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        return composite;
    }

    private static Patient findPatient(ObservationMessage observation, boolean askUser) {
        Patient patient = null;
        if (patient == null && (patient = LabOrderImport.findExactPatient(observation)) != null) {
            ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_InfoPatientIdentifiedByExactDemographics, patient.getLabel()));
        }
        if (patient == null) {
            if (askUser) {
                patient = LabOrderImport.selectPatient(observation);
            }
            if (patient != null) {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_PatientIdentifiedByUser, observation.getPatientName(), patient.getLabel()));
            } else {
                ViollierLogger.getLogger().println(MessageFormat.format(Messages.LabOrderImport_WarningUserAbortWhileIdentifyingPatient, observation.getPatientName()));
            }
        }
        return patient;
    }

    private static Patient selectPatient(ObservationMessage observation) {
        Patient retVal = null;
        String patDemographics = String.valueOf(observation.getPatientName()) + " " + observation.getPatientBirthdate();
        retVal = (Patient)KontaktSelektor.showInSync(Patient.class, (String)Messages.LabOrderImport_SelectPatient, (String)MessageFormat.format(Messages.LabOrderImport_WhoIs, patDemographics));
        return retVal;
    }

    private static Patient findExactPatient(ObservationMessage observation) {
        Patient retVal = null;
        String patNachname = observation.getPatientLastName();
        String patVorname = observation.getPatientFirstName();
        String patSex = observation.getPatientSex();
        String patBirthday = observation.getPatientBirthdate();
        List<Patient> patientList = LabOrderImport.readPatienten(patNachname, patVorname, patBirthday, patSex);
        if (patientList.size() == 1) {
            retVal = patientList.get(0);
        }
        return retVal;
    }

    private void setProcessModeAllFiles() {
        this.doAllFiles = true;
        if (!this.settingProcessMode) {
            this.settingProcessMode = true;
            this.bFile.setSelection(false);
            this.bDirect.setSelection(true);
            this.settingProcessMode = false;
        }
    }

    private void setProcessModeSingleFile() {
        this.doAllFiles = false;
        if (!this.settingProcessMode) {
            this.settingProcessMode = true;
            this.bFile.setSelection(true);
            this.bDirect.setSelection(false);
            this.settingProcessMode = false;
        }
    }

    private static String getAuftragsId(ObservationMessage observation) {
        String orderId = "";
        String auftragsNrFiller = "";
        try {
            auftragsNrFiller = observation.getOrderNumberFiller();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<KontaktOrderManagement> orderNrList = LabOrderImport.getByNumberAndDomain(auftragsNrFiller, ORDER_NR_DOMAIN_FILLER);
        if (orderNrList.size() > 0) {
            orderId = orderNrList.get(0).getId();
        }
        return orderId;
    }

    public static String getVioNr(Patient patient) {
        Query patientVioNrQuery = new Query(Xid.class);
        patientVioNrQuery.add("object", "=", patient.getId());
        patientVioNrQuery.add("domain", "=", DOMAIN_VIONR);
        List patienten = patientVioNrQuery.execute();
        if (patienten.isEmpty()) {
            return "";
        }
        return ((Xid)patienten.get(0)).getDomainId();
    }

    public static enum SaveResult {
        SUCCESS,
        ERROR;

    }
}

