/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importers.openmedical;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class MedTransfer {
    private static String OPENMEDICAL_MAINCLASS = "ch.openmedical.JMedTransfer.JMedTransfer";

    public static int doDownload(String jarFilePath, String downloadDir, String params) {
        File jar;
        int result = 0;
        Object openmedicalObject = null;
        Method openmedicalDownloadMethod = null;
        String iniFilename = "";
        if (jarFilePath != null && (jar = new File(jarFilePath)).canRead()) {
            iniFilename = MedTransfer.extractIni(jarFilePath);
            try {
                URLClassLoader urlLoader = MedTransfer.getURLClassLoader(new URL("file", null, jar.getAbsolutePath()));
                Class<?> openmedicalClass = urlLoader.loadClass(OPENMEDICAL_MAINCLASS);
                Method meth = openmedicalClass.getMethod("download", String[].class);
                Object obj = openmedicalClass.newInstance();
                openmedicalObject = obj;
                openmedicalDownloadMethod = meth;
            }
            catch (Throwable urlLoader) {
                // empty catch block
            }
        }
        try {
            Object omResult;
            String[] customParams = params.split("[ ]");
            String[] systemParams = new String[]{"--download", downloadDir, "--logPath", downloadDir, "--ini", iniFilename, "--verbose", "INF", "-#OpenMedicalKey#"};
            Object[] finalParams = new Object[]{MedTransfer.concatArrays(systemParams, customParams)};
            if (openmedicalDownloadMethod != null && (omResult = openmedicalDownloadMethod.invoke(openmedicalObject, finalParams)) instanceof Integer) {
                result = (Integer)omResult;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static URLClassLoader getURLClassLoader(URL jarURL) {
        return new URLClassLoader(new URL[]{jarURL});
    }

    private static <T> T[] concatArrays(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    private static String extractIni(String jarFilePath) {
        String retVal = "";
        try {
            int nBytes;
            File iniFile = File.createTempFile("MedTransfer", ".ini");
            iniFile.deleteOnExit();
            retVal = iniFile.getCanonicalPath();
            JarFile jar = new JarFile(jarFilePath);
            ZipEntry entry = jar.getEntry("MedTransfer.ini");
            BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(iniFile));
            byte[] buffer = new byte[2048];
            while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, nBytes);
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retVal;
    }
}

