/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.laborimport.hl7.automatic;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.importer.div.importers.HL7Parser;
import ch.elexis.core.importer.div.importers.ILabContactResolver;
import ch.elexis.core.importer.div.importers.IPersistenceHandler;
import ch.elexis.core.importer.div.importers.multifile.MultiFileParser;
import ch.elexis.core.ui.importer.div.importers.DefaultHL7Parser;
import ch.elexis.core.ui.importer.div.importers.PersistenceHandler;
import ch.elexis.core.ui.importer.div.importers.multifile.strategy.DefaultImportStrategyFactory;
import ch.elexis.laborimport.hl7.universal.LinkLabContactResolver;
import ch.rgw.tools.Result;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;

@Component
public class AutomaticImportService {
    public static final String MY_LAB = "Eigenlabor";
    private MultiFileParser mfParser = new MultiFileParser("Eigenlabor");
    private HL7Parser hlp = new DefaultHL7Parser("Eigenlabor");
    private Timer timer = new Timer(true);

    @Activate
    public void activate() {
        this.timer.schedule((TimerTask)new AutomaticImportTask(), 5000L, 5000L);
    }

    private class AutomaticImportTask
    extends TimerTask {
        private final ReentrantLock running = new ReentrantLock();

        private AutomaticImportTask() {
        }

        @Override
        public void run() {
            File dir;
            if (CoreHub.localCfg.get("hl7/autoimport", false) && (dir = new File(CoreHub.localCfg.get("hl7/downloaddir", File.separator))).exists() && dir.isDirectory() && this.isElexisRunning() && this.shouldImport(dir)) {
                if (this.running.tryLock()) {
                    this.runImport(dir);
                    this.running.unlock();
                } else {
                    LoggerFactory.getLogger(AutomaticImportTask.class).warn("Import from [" + dir.getAbsolutePath() + "] already running");
                }
            }
        }

        private boolean isElexisRunning() {
            return CoreHub.globalCfg != null && ElexisEventDispatcher.getSelectedMandator() != null;
        }

        private boolean shouldImport(File dir) {
            return !this.getImportFiles(dir).isEmpty();
        }

        private List<File> getImportFiles(File dir) {
            String[] filenames;
            ArrayList<File> ret = new ArrayList<File>();
            String[] stringArray = filenames = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.toLowerCase().endsWith(".hl7");
                }
            });
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                File file = new File(dir, string);
                long currentMillis = System.currentTimeMillis();
                if (file.exists() && !file.isDirectory() && file.lastModified() + 10000L < currentMillis) {
                    ret.add(file);
                }
                ++n2;
            }
            return ret;
        }

        private void runImport(File dir) {
            int err = 0;
            int files = 0;
            Result<?> r = null;
            List<File> importFiles = this.getImportFiles(dir);
            for (File importFile : importFiles) {
                ++files;
                Display display = Display.getDefault();
                if (display == null) continue;
                ImportFileRunnable runnable = new ImportFileRunnable(importFile);
                display.syncExec((Runnable)runnable);
                r = runnable.getResult();
            }
            if (err > 0) {
                ResultAdapter.displayResult(r, (String)(String.valueOf(Integer.toString(err)) + " von " + Integer.toString(files) + " Dateien hatten Fehler\n"));
            }
        }
    }

    private class ImportFileRunnable
    implements Runnable {
        private File file;
        private Result<?> result;

        public ImportFileRunnable(File importFile) {
            this.file = importFile;
        }

        public Result<?> getResult() {
            return this.result;
        }

        @Override
        public void run() {
            this.result = AutomaticImportService.this.mfParser.importFromFile(this.file, new DefaultImportStrategyFactory().setMoveAfterImport(true).setLabContactResolver((ILabContactResolver)new LinkLabContactResolver()), AutomaticImportService.this.hlp, (IPersistenceHandler)new PersistenceHandler());
        }
    }
}

