/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.ui;

import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.ui.service.AeskulapImporterServiceHolder;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AeskulapImporter
extends ImporterPage {
    private boolean overwrite;

    public String getTitle() {
        return "Aeskulap";
    }

    public String getDescription() {
        return "Datenimport Aeskulap";
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        String filename = this.results[0];
        if (StringUtils.isBlank((CharSequence)filename)) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)"Kein Verzeichnis ausgew\u00e4hlt."));
            return new Status(4, "ch.elexis", "No file given");
        }
        File directory = new File(filename);
        if (!directory.exists() || !directory.isDirectory()) {
            Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Das Verzeichnis " + filename + " existiert nicht, oder ist kein Verzeichnis.")));
            return new Status(4, "ch.elexis", "Invalid file given");
        }
        List files = AeskulapImporterServiceHolder.get().setImportDirectory(directory);
        if (!files.isEmpty()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)files.size());
            List problems = AeskulapImporterServiceHolder.get().importFiles(files, this.overwrite, subMonitor);
            if (problems.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                files.stream().filter(af -> af.getType() != IAeskulapImportFile.Type.LETTERDIRECTORY).forEach(f -> {
                    StringBuilder stringBuilder2 = sb.append(String.valueOf(f.getFile().getName()) + "\n");
                });
                Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)("Die Dateien\n\n" + sb.toString() + "\nwurden erfolgreich importiert.")));
            } else {
                StringBuilder sb = new StringBuilder();
                problems.stream().filter(af -> af.getType() != IAeskulapImportFile.Type.LETTERDIRECTORY).forEach(f -> {
                    StringBuilder stringBuilder2 = sb.append(String.valueOf(f.getFile().getName()) + "\n");
                });
                Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Bei folgenden Dateien\n\n" + sb.toString() + "\nist ein Problem aufgetreten.")));
            }
        } else {
            Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)("Im Verzeichnis " + filename + " wurden keine Dateien zum Import gefunden.")));
        }
        return Status.OK_STATUS;
    }

    public Composite createPage(Composite parent) {
        ImporterPage.DirectoryBasedImporter fbi = new ImporterPage.DirectoryBasedImporter(parent, (ImporterPage)this);
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        final Button overwriteBtn = new Button(parent, 32);
        overwriteBtn.setText("Bereits importierte Daten \u00fcberschreiben.");
        overwriteBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AeskulapImporter.this.overwrite = overwriteBtn.getSelection();
            }
        });
        return fbi;
    }
}

