/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AbstractCsvImportFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.LoggerFactory;

public class MandatorFile
extends AbstractCsvImportFile<String>
implements IAeskulapImportFile {
    private File file;
    private Map<String, String> values;

    public MandatorFile(File file) {
        super(file);
        this.file = file;
        this.values = new HashMap<String, String>();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public static boolean canHandleFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equalsIgnoreCase("csv") && FilenameUtils.getBaseName((String)file.getName()).equalsIgnoreCase("Mandanten");
    }

    @Override
    public boolean isHeaderLine(String[] line) {
        return line[0] != null && line[0].equalsIgnoreCase("Arzt_No");
    }

    @Override
    public String create(String[] line) {
        this.values.put(line[0], StringUtils.abbreviate((String)line[1], (int)10));
        return line[1];
    }

    @Override
    public void setProperties(String map, String[] line) {
    }

    @Override
    public String getExisting(String id) {
        return this.values.get(id);
    }

    @Override
    public boolean doImport(Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles, boolean overwrite, SubMonitor monitor) {
        try {
            String[] line = null;
            while ((line = this.getNextLine()) != null) {
                String manator = this.getExisting(line[0]);
                if (manator != null) continue;
                manator = this.create(line);
            }
            return true;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error importing file", (Throwable)e);
        }
        finally {
            this.close();
            monitor.done();
        }
        return false;
    }

    @Override
    public IAeskulapImportFile.Type getType() {
        return IAeskulapImportFile.Type.MANDATOR;
    }

    @Override
    public String getXidDomain() {
        return "elexis.ch/aeskulap_import/AddrID";
    }

    @Override
    public boolean isTransient() {
        return true;
    }

    @Override
    public Object getTransient(String id) {
        return this.values.get(id);
    }
}

