/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal.csv;

import au.com.bytecode.opencsv.CSVReader;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.data.Xid;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.slf4j.LoggerFactory;

public abstract class AbstractCsvImportFile<T> {
    private File csvFile;
    private CSVReader reader;

    public AbstractCsvImportFile(File csvFile) {
        this.csvFile = csvFile;
    }

    public abstract boolean isHeaderLine(String[] var1);

    public abstract String getXidDomain();

    public T getExisting(String id) {
        Xid existingXid;
        String domain = this.getXidDomain();
        if (domain != null && (existingXid = Xid.findXID((String)domain, (String)id)) != null) {
            IPersistentObject ret = existingXid.getObject();
            if (this.getType().checkElexisClass(ret)) {
                return (T)ret;
            }
            LoggerFactory.getLogger(this.getClass()).error("XID [" + domain + "] [" + id + "] referes to object of wrong type [" + ret.getClass() + "]");
        }
        return null;
    }

    public abstract T create(String[] var1);

    public abstract void setProperties(T var1, String[] var2);

    public abstract IAeskulapImportFile.Type getType();

    public String[] getNextLine() throws IOException {
        if (this.reader == null) {
            this.reader = new CSVReader((Reader)new FileReader(this.csvFile), ',', '\"');
            String[] firstLine = this.reader.readNext();
            if (firstLine == null || firstLine.length == 0) {
                return null;
            }
            if (this.isHeaderLine(firstLine)) {
                return this.reader.readNext();
            }
            return firstLine;
        }
        return this.reader.readNext();
    }

    public int getLineCount() {
        int n;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.csvFile));
        try {
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = ((InputStream)is).read(c)) != -1) {
                empty = false;
                int i = 0;
                while (i < readChars) {
                    if (c[i] == 10) {
                        ++count;
                    }
                    ++i;
                }
            }
            n = count == 0 && !empty ? 1 : count;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error("Error getting line count", (Throwable)e);
                return 1;
            }
        }
        ((InputStream)is).close();
        return n;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

