/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.data.Xid;
import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.IAeskulapImporter;
import ch.elexis.importer.aeskulap.core.internal.AeskulapFileFactory;
import ch.elexis.importer.aeskulap.core.internal.LetterDirectories;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component
public class AeskulapImporter
implements IAeskulapImporter {
    private Map<IAeskulapImportFile.Type, IAeskulapImportFile> transientFiles;
    private LetterDirectories letterDirectories;

    @Override
    public List<IAeskulapImportFile> setImportDirectory(File directory) {
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        if (directory != null && directory.exists() && directory.isDirectory()) {
            File[] fileOrDirectory;
            File[] fileArray = fileOrDirectory = directory.listFiles();
            int n = fileOrDirectory.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    if (this.isLetterDirectory(file)) {
                        this.addLetterDirectory(file);
                    } else {
                        ret.addAll(this.getAeskulapFilesFromDirectory(file));
                    }
                } else {
                    AeskulapFileFactory.getAeskulapFile(file).ifPresent(af -> {
                        boolean bl = ret.add((IAeskulapImportFile)af);
                    });
                }
                ++n2;
            }
        }
        if (this.letterDirectories != null) {
            ret.add(this.letterDirectories);
        }
        return ret;
    }

    private void addLetterDirectory(File file) {
        if (this.letterDirectories == null) {
            this.letterDirectories = new LetterDirectories();
        }
        this.letterDirectories.add(file);
    }

    private boolean isLetterDirectory(File directory) {
        if (directory.isDirectory()) {
            File[] docFiles = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("!") && name.contains("_");
                }
            });
            return docFiles.length > 0;
        }
        return false;
    }

    private List<IAeskulapImportFile> getAeskulapFilesFromDirectory(File directory) {
        File[] fileOrDirectory;
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        File[] fileArray = fileOrDirectory = directory.listFiles();
        int n = fileOrDirectory.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (this.isLetterDirectory(file)) {
                    this.addLetterDirectory(file);
                } else {
                    ret.addAll(this.getAeskulapFilesFromDirectory(file));
                }
            } else {
                AeskulapFileFactory.getAeskulapFile(file).ifPresent(af -> {
                    boolean bl = ret.add((IAeskulapImportFile)af);
                });
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public List<IAeskulapImportFile> importFiles(List<IAeskulapImportFile> files, boolean overwrite, SubMonitor monitor) {
        ElexisEventDispatcher.getInstance().setBlockEventTypes(Arrays.asList(1, 2, 16, 32, 8, 4));
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/AddrID", (String)"Alte Adress-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabContactID", (String)"Alte Labor Kontakt-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabItemID", (String)"Alte Labor Typ-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LabResultID", (String)"Alte Labor Resultat-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/PatID", (String)"Alte KG-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/garantID", (String)"Alte Garant-ID", (int)1);
        Xid.localRegisterXIDDomainIfNotExists((String)"elexis.ch/aeskulap_import/LetterID", (String)"Alte Brief-ID", (int)1);
        this.transientFiles = new HashMap<IAeskulapImportFile.Type, IAeskulapImportFile>();
        ArrayList<IAeskulapImportFile> ret = new ArrayList<IAeskulapImportFile>();
        Map<IAeskulapImportFile.Type, List<IAeskulapImportFile>> typedMap = this.getTypedMap(files);
        for (IAeskulapImportFile.Type type : IAeskulapImportFile.Type.getSequenced()) {
            files = typedMap.get((Object)type);
            if (files == null) continue;
            for (IAeskulapImportFile iAeskulapImportFile : files) {
                boolean success = iAeskulapImportFile.doImport(this.transientFiles, overwrite, monitor.newChild(1));
                if (!success) {
                    ret.add(iAeskulapImportFile);
                    continue;
                }
                if (!iAeskulapImportFile.isTransient()) continue;
                this.transientFiles.put(iAeskulapImportFile.getType(), iAeskulapImportFile);
            }
        }
        ElexisEventDispatcher.getInstance().setBlockEventTypes(null);
        return ret;
    }

    private Map<IAeskulapImportFile.Type, List<IAeskulapImportFile>> getTypedMap(List<IAeskulapImportFile> files) {
        HashMap<IAeskulapImportFile.Type, List<IAeskulapImportFile>> ret = new HashMap<IAeskulapImportFile.Type, List<IAeskulapImportFile>>();
        for (IAeskulapImportFile iAeskulapImportFile : files) {
            ArrayList<IAeskulapImportFile> list = (ArrayList<IAeskulapImportFile>)ret.get((Object)iAeskulapImportFile.getType());
            if (list == null) {
                list = new ArrayList<IAeskulapImportFile>();
            }
            list.add(iAeskulapImportFile);
            ret.put(iAeskulapImportFile.getType(), list);
        }
        return ret;
    }
}

