/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.importer.aeskulap.core.internal;

import ch.elexis.importer.aeskulap.core.IAeskulapImportFile;
import ch.elexis.importer.aeskulap.core.internal.csv.AddressesFile;
import ch.elexis.importer.aeskulap.core.internal.csv.LabContactFile;
import ch.elexis.importer.aeskulap.core.internal.csv.LabItemFile;
import ch.elexis.importer.aeskulap.core.internal.csv.LabResultFile;
import ch.elexis.importer.aeskulap.core.internal.csv.LetterFile;
import ch.elexis.importer.aeskulap.core.internal.csv.MandatorFile;
import ch.elexis.importer.aeskulap.core.internal.csv.PatientFile;
import java.io.File;
import java.util.Optional;

public class AeskulapFileFactory {
    public static Optional<IAeskulapImportFile> getAeskulapFile(File file) {
        if (AddressesFile.canHandleFile(file)) {
            return Optional.of(new AddressesFile(file));
        }
        if (LabContactFile.canHandleFile(file)) {
            return Optional.of(new LabContactFile(file));
        }
        if (LabItemFile.canHandleFile(file)) {
            return Optional.of(new LabItemFile(file));
        }
        if (LabResultFile.canHandleFile(file)) {
            return Optional.of(new LabResultFile(file));
        }
        if (PatientFile.canHandleFile(file)) {
            return Optional.of(new PatientFile(file));
        }
        if (LetterFile.canHandleFile(file)) {
            return Optional.of(new LetterFile(file));
        }
        if (MandatorFile.canHandleFile(file)) {
            return Optional.of(new MandatorFile(file));
        }
        return Optional.empty();
    }
}

