/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.view;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Patient;
import ch.elexis.impfplan.controller.ImpfplanController;
import ch.elexis.impfplan.controller.VaccinationSorter;
import ch.elexis.impfplan.model.Vaccination;
import ch.elexis.impfplan.model.VaccinationType;
import ch.elexis.impfplan.view.AddVaccinationDialog;
import ch.elexis.impfplan.view.ContentProviderAdapter;
import ch.elexis.impfplan.view.ImpfplanPrinter;
import ch.elexis.impfplan.view.Messages;
import ch.elexis.impfplan.view.VaccinationLabelProvider;
import ch.rgw.tools.TimeTool;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class ImpfplanView
extends ViewPart {
    private IAction addVacination;
    private IAction printVaccinations;
    private IAction removeVaccination;
    TableViewer tvVaccsDone;
    TableViewer tvVaccsRecommended;
    int[] columnWidths = new int[]{300, 100};
    String[] columnTitles = new String[]{Messages.ImpfplanView_vaccinationColumn, Messages.ImpfplanView_dateColumn};
    ScrolledForm form;
    VaccinationSorter sorter = new VaccinationSorter();
    ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        public void runInUi(ElexisEvent ev) {
            ImpfplanView.this.tvVaccsDone.refresh();
            ImpfplanView.this.tvVaccsRecommended.refresh();
            if (ElexisEventDispatcher.getSelectedPatient() != null) {
                ImpfplanView.this.addVacination.setEnabled(true);
                ImpfplanView.this.printVaccinations.setEnabled(true);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.form = UiDesk.getToolkit().createScrolledForm(parent);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.addVacination, this.printVaccinations});
        Label lblVaccsDone = new Label(body, 0);
        lblVaccsDone.setText(Messages.ImpfplanView_vaccinationsDOne);
        Table tVaccsDone = new Table(body, 65536);
        tVaccsDone.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        int i = 0;
        while (i < this.columnTitles.length) {
            TableColumn tc = new TableColumn(tVaccsDone, 0);
            tc.setWidth(this.columnWidths[i]);
            tc.setText(this.columnTitles[i]);
            ++i;
        }
        tVaccsDone.setHeaderVisible(true);
        tVaccsDone.setLinesVisible(true);
        this.tvVaccsDone = new TableViewer(tVaccsDone);
        this.tvVaccsDone.setContentProvider((IContentProvider)new ContentProviderAdapter(){

            @Override
            public Object[] getElements(Object inputElement) {
                Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                if (actPatient != null) {
                    List<Vaccination> r = ImpfplanController.getVaccinations(actPatient);
                    return r.toArray();
                }
                return new Object[0];
            }
        });
        MenuManager contextMenu = new MenuManager();
        contextMenu.add(this.removeVaccination);
        this.tvVaccsDone.getControl().setMenu(contextMenu.createContextMenu(this.tvVaccsDone.getControl()));
        this.tvVaccsDone.setSorter((ViewerSorter)this.sorter);
        this.tvVaccsDone.setLabelProvider((IBaseLabelProvider)new VaccinationLabelProvider());
        Label lblVaccsReccomended = new Label(body, 0);
        lblVaccsReccomended.setText(Messages.ImpfplanView_vaccinationsRecommended);
        Table tVaccsRecommended = new Table(body, 65536);
        tVaccsRecommended.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        int i2 = 0;
        while (i2 < this.columnTitles.length) {
            TableColumn tc = new TableColumn(tVaccsRecommended, 0);
            tc.setWidth(this.columnWidths[i2]);
            tc.setText(this.columnTitles[i2]);
            ++i2;
        }
        tVaccsRecommended.setHeaderVisible(true);
        tVaccsRecommended.setLinesVisible(true);
        this.tvVaccsRecommended = new TableViewer(tVaccsRecommended);
        this.tvVaccsRecommended.setContentProvider((IContentProvider)new ContentProviderAdapter(){

            @Override
            public Object[] getElements(Object inputElement) {
                Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
                if (actPatient != null) {
                    try {
                        List<VaccinationType> r = VaccinationType.findDueFor(actPatient);
                        return r.toArray();
                    }
                    catch (ElexisException e) {
                        e.printStackTrace();
                    }
                }
                return new Object[0];
            }
        });
        this.tvVaccsRecommended.setSorter((ViewerSorter)this.sorter);
        this.tvVaccsRecommended.setLabelProvider((IBaseLabelProvider)new VaccinationLabelProvider());
        this.tvVaccsRecommended.setInput((Object)this);
        this.tvVaccsDone.setInput((Object)this);
        boolean enable = ElexisEventDispatcher.getSelectedPatient() != null;
        this.addVacination.setEnabled(enable);
        this.printVaccinations.setEnabled(enable);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_pat});
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_pat});
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.addVacination = new Action(Messages.ImpfplanView_vaccinateActionTitle){
            {
                this.setToolTipText(Messages.ImpfplanView_vaccinateActionTooltip);
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
            }

            public void run() {
                AddVaccinationDialog dlg = new AddVaccinationDialog(ImpfplanView.this.getViewSite().getShell());
                if (dlg.open() == 0) {
                    new Vaccination(dlg.result, ElexisEventDispatcher.getSelectedPatient(), new TimeTool(dlg.date), dlg.bUnexact);
                    ImpfplanView.this.tvVaccsDone.refresh();
                    ImpfplanView.this.tvVaccsRecommended.refresh();
                }
            }
        };
        this.printVaccinations = new Action(Messages.ImpfplanView_printActionTitle){
            {
                this.setToolTipText(Messages.ImpfplanView_printActionTooltip);
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
            }

            public void run() {
                ImpfplanPrinter ipr = new ImpfplanPrinter(ImpfplanView.this.getSite().getShell());
                ipr.open();
            }
        };
        this.removeVaccination = new Action(Messages.ImpfplanView_removeActionTitle){
            {
                this.setToolTipText(Messages.ImpfplanView_removeActionTooltip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                Vaccination v;
                IStructuredSelection sel = (IStructuredSelection)ImpfplanView.this.tvVaccsDone.getSelection();
                if (!sel.isEmpty() && (v = (Vaccination)((Object)sel.getFirstElement())).delete()) {
                    ImpfplanView.this.tvVaccsDone.remove((Object)v);
                }
            }
        };
    }
}

