/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.view;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.impfplan.controller.ImpfplanController;
import ch.elexis.impfplan.model.Vaccination;
import ch.elexis.impfplan.model.VaccinationType;
import ch.elexis.impfplan.view.Messages;
import ch.rgw.tools.ExHandler;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImpfplanPrinter
extends TitleAreaDialog
implements ITextPlugin.ICallback {
    private TextContainer text = null;

    public ImpfplanPrinter(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        Patient actPatient = ElexisEventDispatcher.getSelectedPatient();
        if (actPatient != null) {
            ret.setLayout((Layout)new FillLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            this.text = new TextContainer(this.getShell());
            this.text.getPlugin().createContainer(ret, (ITextPlugin.ICallback)this);
            this.text.getPlugin().showMenu(true);
            this.text.getPlugin().showToolbar(true);
            this.text.createFromTemplateName(null, "Impfplan", "Allg.", (Kontakt)CoreHub.actUser, Messages.ImpfplanPrinter_templateType);
            List<Vaccination> r = ImpfplanController.getVaccinations(actPatient);
            String[][] tbl = new String[r.size()][3];
            int line = 0;
            for (Vaccination vacc : r) {
                VaccinationType vt = vacc.getVaccinationType();
                tbl[line][0] = vt.get("name");
                tbl[line][1] = vt.get("product");
                tbl[line++][2] = vacc.getDateAsString();
            }
            this.text.getPlugin().insertTable(Messages.ImpfplanPrinter_templatePlaceHolder, 0, tbl, null);
            try {
                List<VaccinationType> vts = VaccinationType.findDueFor(actPatient);
                StringBuilder sb = new StringBuilder();
                for (VaccinationType vt : vts) {
                    sb.append(vt.get("name")).append("\n");
                }
                this.text.replace(Messages.ImpfplanPrinter_recommendPlaceholder, sb.toString());
            }
            catch (ElexisException e) {
                ExHandler.handle((Throwable)e);
            }
        }
        return ret;
    }

    public void create() {
        super.create();
        this.setMessage(Messages.ImpfplanPrinter_printPlanMessage);
        this.setTitle(Messages.ImpfplanPrinter_printPlanTitle);
        this.getShell().setText(Messages.ImpfplanPrinter_printListHeading);
        this.getShell().setSize(800, 700);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }
}

