/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.model;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.impfplan.controller.ImpfplanController;
import ch.elexis.impfplan.model.Tuple;
import ch.elexis.impfplan.model.Vaccination;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VaccinationType
extends PersistentObject {
    public static final String RECOMMENDED_AGE = "recommendedAge";
    public static final String REMARKS = "remarks";
    public static final String DELAY_REP = "delay_rep";
    public static final String DELAY3TO4 = "delay_3to4";
    public static final String DELAY2TO3 = "delay_2to3";
    public static final String DELAY1TO2 = "delay_1to2";
    public static final String PRODUCT = "product";
    public static final String NAME = "name";
    public static final String VACC_AGAINST = "vaccAgainst";
    private static final String TABLENAME = "CH_ELEXIS_IMPFPLAN_VACCINATION_TYPES";
    private static final String VERSION = "0.2.0";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_IMPFPLAN_VACCINATION_TYPES (ID\tVARCHAR(25) primary key, deleted CHAR(1) default '0', lastupdate BIGINT,name VARCHAR(80), product VARCHAR(80), delay_1to2 VARCHAR(10), delay_2to3 VARCHAR(10),delay_3to4 VARCHAR(10), delay_4to5 VARCHAR(10), delay_rep VARCHAR(10), recommendedAge VARCHAR(10),remarks TEXT,ExtInfo BLOB);INSERT INTO CH_ELEXIS_IMPFPLAN_VACCINATION_TYPES (ID,name) VALUES('VERSION','0.2.0');";
    public static final String upd020 = "ALTER TABLE CH_ELEXIS_IMPFPLAN_VACCINATION_TYPES ADD ExtInfo longblob";

    static {
        VaccinationType.addMapping((String)TABLENAME, (String[])new String[]{NAME, PRODUCT, DELAY1TO2, DELAY2TO3, DELAY3TO4, DELAY_REP, REMARKS, RECOMMENDED_AGE, "ExtInfo"});
        VaccinationType ver = VaccinationType.load("VERSION");
        if (!ver.exists()) {
            VaccinationType.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(ver.get(NAME));
            if (vi.isOlder(VERSION)) {
                VaccinationType.createOrModifyTable((String)upd020);
                ver.set(NAME, VERSION);
            }
        }
    }

    public VaccinationType(String name, String subst) {
        this.create(null);
        this.set(new String[]{NAME, PRODUCT}, new String[]{name, subst});
    }

    public static VaccinationType load(String id) {
        return new VaccinationType(id);
    }

    public String getLabel() {
        return this.get(NAME) + ": " + this.get(PRODUCT);
    }

    public static Tuple calcDays(String inputDef) throws ElexisException {
        String[] in = (inputDef = inputDef.trim().toLowerCase()).split("\\s*-\\s*");
        if (in.length == 1) {
            int m = VaccinationType.doInterpret(in[0]);
            if (inputDef.startsWith("-")) {
                return new Tuple(0, m);
            }
            if (inputDef.endsWith("-")) {
                return new Tuple(m, 36500);
            }
            return new Tuple(m, m);
        }
        if (in.length == 2) {
            return new Tuple(VaccinationType.doInterpret(in[0]), VaccinationType.doInterpret(in[1]));
        }
        throw new ElexisException(VaccinationType.class, "Too many dashes in " + inputDef, 2);
    }

    private static int doInterpret(String input) throws ElexisException {
        String s = input.trim();
        int len = s.length();
        if (len == 0) {
            return 0;
        }
        try {
            String number = s;
            int mul = 1;
            if (s.matches("[0-9]+")) {
                s = String.valueOf(s) + "y";
                ++len;
            }
            if (s.matches("[0-9]+[wmyjad]")) {
                number = s.substring(0, len - 1);
                CharSequence mdef = s.subSequence(len - 1, len);
                switch (mdef.charAt(0)) {
                    case 's': 
                    case 'w': {
                        mul = 7;
                        break;
                    }
                    case 'm': {
                        mul = 30;
                        break;
                    }
                    case 'a': 
                    case 'j': 
                    case 'y': {
                        mul = 365;
                        break;
                    }
                    case 'd': {
                        mul = 1;
                    }
                }
            }
            return Integer.parseInt(number) * mul;
        }
        catch (NumberFormatException nex) {
            throw new ElexisException(VaccinationType.class, "Can not interpret " + input, 1);
        }
    }

    public static List<VaccinationType> findDueFor(Patient pat) throws ElexisException {
        LinkedList<VaccinationType> ret = new LinkedList<VaccinationType>();
        List<VaccinationType> vaccinationsDefined = ImpfplanController.allVaccs();
        HashMap<VaccinationType, LinkedList<TimeTool>> vaccs = new HashMap<VaccinationType, LinkedList<TimeTool>>();
        for (Vaccination v : ImpfplanController.getVaccinations(pat)) {
            LinkedList<TimeTool> l = (LinkedList<TimeTool>)vaccs.get((Object)v.getVaccinationType());
            if (l == null) {
                l = new LinkedList<TimeTool>();
            }
            l.add(new TimeTool(v.get("date")));
            vaccs.put(v.getVaccinationType(), l);
        }
        for (VaccinationType vt : vaccinationsDefined) {
            TimeTool ttThird;
            List vDone = (List)vaccs.get((Object)vt);
            if (vDone == null) {
                Tuple recAge = VaccinationType.calcDays(vt.get(RECOMMENDED_AGE));
                if (!VaccinationType.isInRange(pat, null, recAge)) continue;
                ret.add(vt);
                continue;
            }
            String v2 = vt.get(DELAY1TO2);
            if (v2 == null || v2.equals("0") || v2.length() <= 0) continue;
            Tuple d1to2 = VaccinationType.calcDays(v2);
            if (vDone.size() < 2) {
                TimeTool ttFirst = new TimeTool((TimeTool)vDone.get(0));
                if (!VaccinationType.isInRange(pat, ttFirst, d1to2)) continue;
                ret.add(vt);
                continue;
            }
            String v3 = vt.get(DELAY2TO3);
            if (v3 == null || v3.equals("0") || v3.length() <= 0) continue;
            Tuple d2tod3 = VaccinationType.calcDays(v3);
            if (vDone.size() < 3) {
                TimeTool ttSecond = new TimeTool((TimeTool)vDone.get(1));
                if (!VaccinationType.isInRange(pat, ttSecond, d2tod3)) continue;
                ret.add(vt);
                continue;
            }
            String v4 = vt.get(DELAY3TO4);
            if (v4 == null || v4.equals("0") || v4.length() <= 0) continue;
            Tuple d3tod4 = VaccinationType.calcDays(v4);
            if (vDone.size() >= 4 || !VaccinationType.isInRange(pat, ttThird = new TimeTool((TimeTool)vDone.get(2)), d3tod4)) continue;
            ret.add(vt);
        }
        return ret;
    }

    public static boolean isInRange(Patient p, TimeTool base, Tuple t) {
        TimeTool now = new TimeTool();
        TimeTool bd = new TimeTool(p.getGeburtsdatum());
        int days = bd.daysTo(now);
        if (base == null) {
            base = new TimeTool(bd);
        }
        TimeTool lower = new TimeTool(base);
        lower.addDays(((Integer)t.o1).intValue());
        TimeTool upper = new TimeTool(base);
        upper.addDays(((Integer)t.o2).intValue());
        if (lower.isBeforeOrEqual(now)) {
            return true;
        }
        return upper.isBeforeOrEqual(now);
    }

    public List<String> getVaccAgainstList() {
        String[] singleCodes;
        String vaccAgainst = this.getExt(VACC_AGAINST);
        if (vaccAgainst == null || vaccAgainst.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> atcCodes = new ArrayList<String>();
        String[] stringArray = singleCodes = vaccAgainst.split(",");
        int n = singleCodes.length;
        int n2 = 0;
        while (n2 < n) {
            String atc = stringArray[n2];
            atcCodes.add(atc);
            ++n2;
        }
        return atcCodes;
    }

    public String getVaccAgainst() {
        return VaccinationType.checkNull((Object)this.getExt(VACC_AGAINST));
    }

    public void setVaccAgainst(String bem) {
        this.setExt(VACC_AGAINST, bem);
    }

    public void setExt(String name, String value) {
        Map h = this.getMap("ExtInfo");
        if (value == null) {
            h.remove(name);
        } else {
            h.put(name, value);
        }
        this.setMap("ExtInfo", h);
    }

    public String getExt(String name) {
        Map h = this.getMap("ExtInfo");
        return VaccinationType.checkNull((Object)((String)h.get(name)));
    }

    protected String getTableName() {
        return TABLENAME;
    }

    protected VaccinationType() {
    }

    protected VaccinationType(String id) {
        super(id);
    }
}

