/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.impfplan.model;

import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.impfplan.model.VaccinationType;
import ch.rgw.tools.TimeTool;

public class Vaccination
extends PersistentObject {
    public static final String OBSERVATIONS = "observations";
    public static final String DATE = "date";
    public static final String VACCINATION_TYPE = "vaccinationType";
    public static final String PATIENT_ID = "patientID";
    private static final String TABLENAME = "CH_ELEXIS_IMPFPLAN_VACCINATIONS";
    private static final String VERSION = "0.1.0";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_IMPFPLAN_VACCINATIONS (ID VARCHAR(25) primary key, deleted CHAR(1) default '0', lastupdate bigint,patientID VARCHAR(25), vaccinationType VARCHAR(25), date CHAR(8), observations TEXT);CREATE INDEX CH_ELEXIS_IMPFPLAN_VACCINATIONS_IDX1 on CH_ELEXIS_IMPFPLAN_VACCINATIONS (patientID);INSERT INTO CH_ELEXIS_IMPFPLAN_VACCINATIONS(ID,observations) VALUES('VERSION','0.1.0');";

    static {
        Vaccination.addMapping((String)TABLENAME, (String[])new String[]{PATIENT_ID, VACCINATION_TYPE, DATE, OBSERVATIONS});
        Vaccination ver = Vaccination.load("VERSION");
        if (!ver.exists()) {
            Vaccination.createOrModifyTable((String)createDB);
        }
    }

    public Vaccination(VaccinationType vt, Patient pat, TimeTool date, boolean bUnexact) {
        this.create(null);
        String dat = date.toString(9);
        if (bUnexact) {
            dat = String.valueOf(dat.substring(0, 4)) + "0000";
        }
        this.set(new String[]{VACCINATION_TYPE, PATIENT_ID, DATE}, new String[]{vt.getId(), pat.getId(), dat});
    }

    public Vaccination(VaccinationType vt, Patient pat) {
        this(vt, pat, new TimeTool(), false);
    }

    public String getLabel() {
        Patient pat = Patient.load((String)this.get(PATIENT_ID));
        VaccinationType type = VaccinationType.load(this.get(VACCINATION_TYPE));
        return pat.getLabel() + " : " + type.getLabel();
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public VaccinationType getVaccinationType() {
        VaccinationType vt = VaccinationType.load(this.get(VACCINATION_TYPE));
        if (vt.exists()) {
            return vt;
        }
        return null;
    }

    public String getDateAsString() {
        String dat = this.get(DATE);
        if (dat.endsWith("0000")) {
            return "( ~" + dat.substring(0, 4) + ")";
        }
        return this.getDate().toString(4);
    }

    public String getRawDateString() {
        String dat = this.get(DATE);
        if (dat.endsWith("0000")) {
            return dat;
        }
        return this.getDate().toString(9);
    }

    public TimeTool getDate() {
        String dRaw = this.get(DATE);
        if (dRaw.endsWith("0000")) {
            dRaw = String.valueOf(dRaw.substring(0, 4)) + "0101";
        }
        return new TimeTool(dRaw);
    }

    public void setDate(TimeTool date, boolean bIsUnexact) {
        String val = date.toString(9);
        if (bIsUnexact) {
            val = String.valueOf(val.substring(0, 4)) + "0000";
        }
        this.set(DATE, val);
    }

    public String getPatientId() {
        return Vaccination.checkNull((Object)this.get(PATIENT_ID));
    }

    public static Vaccination load(String id) {
        return new Vaccination(id);
    }

    protected Vaccination(String id) {
        super(id);
    }

    protected Vaccination() {
    }
}

