/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.ObjectFilterRegistry;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Episode;
import ch.elexis.icpc.KonsFilter;
import ch.elexis.icpc.views.EditEpisodeDialog;
import ch.elexis.icpc.views.EpisodesDisplay;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class EpisodesView
extends ViewPart
implements IActivationListener {
    public static final String ID = "ch.elexis.icpc.episodesView";
    EpisodesDisplay display;
    KonsFilter episodesFilter = new KonsFilter(this);
    private IAction addEpisodeAction;
    private IAction removeEpisodeAction;
    private IAction editEpisodeAction;
    private IAction activateEpisodeAction;
    private IAction konsFilterAction;
    private IAction removeDiagnosesAction;
    private ElexisUiEventListenerImpl eeli_kons = new ElexisUiEventListenerImpl(Konsultation.class, 1){

        public void catchElexisEvent(ElexisEvent ev) {
            switch (ev.getType()) {
                default: 
            }
        }
    };
    private ElexisUiEventListenerImpl eeli_pat = new ElexisUiEventListenerImpl(Patient.class, 16){

        public void runInUi(ElexisEvent ev) {
            EpisodesView.this.display.setPatient((Patient)ev.getObject());
        }
    };
    private ElexisUiEventListenerImpl eeli_episode = new ElexisUiEventListenerImpl(Episode.class, 52){

        public void runInUi(ElexisEvent ev) {
            Episode ep = (Episode)ev.getObject();
            switch (ev.getType()) {
                case 16: {
                    if (ep.getStatus() == 1) {
                        EpisodesView.this.activateEpisodeAction.setChecked(true);
                    } else {
                        EpisodesView.this.activateEpisodeAction.setChecked(false);
                    }
                    if (!EpisodesView.this.konsFilterAction.isChecked()) break;
                    EpisodesView.this.episodesFilter.setProblem(ep);
                    break;
                }
                case 32: {
                    EpisodesView.this.episodesFilter.setProblem(null);
                    break;
                }
                case 4: {
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.display = new EpisodesDisplay(parent);
        this.display.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createControlContextMenu(this.display.tvEpisodes.getControl(), new ViewMenus.IMenuPopulator(){

            public IAction[] fillMenu() {
                IAction[] iActionArray = new IAction[5];
                iActionArray[0] = EpisodesView.this.activateEpisodeAction;
                iActionArray[1] = EpisodesView.this.editEpisodeAction;
                iActionArray[3] = EpisodesView.this.removeEpisodeAction;
                iActionArray[4] = EpisodesView.this.removeDiagnosesAction;
                return iActionArray;
            }
        });
        menu.createToolbar(new IAction[]{this.konsFilterAction, this.addEpisodeAction, this.editEpisodeAction});
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this.getViewSite().getPart());
    }

    public void setFocus() {
    }

    public void clearEvent(Class<? extends PersistentObject> template) {
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            this.display.setPatient(ElexisEventDispatcher.getSelectedPatient());
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_episode, this.eeli_kons, this.eeli_pat});
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_episode, this.eeli_kons, this.eeli_pat});
        }
    }

    private void makeActions() {
        this.addEpisodeAction = new Action("Neues Problem"){
            {
                this.setToolTipText("Eine neues Problem erstellen");
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
            }

            public void run() {
                EditEpisodeDialog dlg = new EditEpisodeDialog(EpisodesView.this.getViewSite().getShell(), null);
                if (dlg.open() == 0) {
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.removeEpisodeAction = new Action("Problem l\u00f6schen"){
            {
                this.setToolTipText("Das gew\u00e4hlte Problem unwiderruflich l\u00f6schen");
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                Episode act = EpisodesView.this.display.getSelectedEpisode();
                if (act != null) {
                    act.delete();
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.removeDiagnosesAction = new Action("Diagnosen entfernen"){
            {
                this.setToolTipText("Entfernt die Verkn\u00fcpfungen mit Diagnosen");
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
            }

            public void run() {
                Episode act = EpisodesView.this.display.getSelectedEpisode();
                if (act != null) {
                    act.removeFromList("DiagLink");
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.editEpisodeAction = new Action("Problem bearbeiten"){
            {
                this.setToolTipText("Problem bearbeiten");
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
            }

            public void run() {
                EditEpisodeDialog dlg;
                Episode ep = EpisodesView.this.display.getSelectedEpisode();
                if (ep != null && (dlg = new EditEpisodeDialog(EpisodesView.this.getViewSite().getShell(), ep)).open() == 0) {
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.activateEpisodeAction = new Action("Aktiv", 2){
            {
                this.setToolTipText("Problem aktivieren oder deaktivieren");
            }

            public void run() {
                Episode ep = EpisodesView.this.display.getSelectedEpisode();
                if (ep != null) {
                    ep.setStatus(EpisodesView.this.activateEpisodeAction.isChecked() ? 1 : 0);
                    EpisodesView.this.display.tvEpisodes.refresh();
                }
            }
        };
        this.konsFilterAction = new Action("Konsultationen filtern", 2){
            {
                this.setToolTipText("Konsultationslisten auf markiertes Problem begrenzen");
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
            }

            public void run() {
                if (!this.isChecked()) {
                    ObjectFilterRegistry.getInstance().unregisterObjectFilter(Konsultation.class, (ObjectFilterRegistry.IObjectFilterProvider)EpisodesView.this.episodesFilter);
                } else {
                    ObjectFilterRegistry.getInstance().registerObjectFilter(Konsultation.class, (ObjectFilterRegistry.IObjectFilterProvider)EpisodesView.this.episodesFilter);
                    Episode ep = EpisodesView.this.display.getSelectedEpisode();
                    EpisodesView.this.episodesFilter.setProblem(ep);
                }
            }
        };
    }

    public void activateKonsFilterAction(boolean bActivate) {
        this.konsFilterAction.setChecked(bActivate);
    }
}

