/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.icpc.Episode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class EpisodesDisplay
extends Composite {
    ScrolledForm form;
    Patient actPatient;
    TreeViewer tvEpisodes;

    public EpisodesDisplay(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.form = UiDesk.getToolkit().createScrolledForm((Composite)this);
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.tvEpisodes = new TreeViewer(body);
        this.tvEpisodes.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tvEpisodes.setLabelProvider((IBaseLabelProvider)new EpisodesLabelProvider());
        this.tvEpisodes.setContentProvider((IContentProvider)new EpisodecontentProvider());
        this.tvEpisodes.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        new PersistentObjectDragSource((StructuredViewer)this.tvEpisodes);
        new PersistentObjectDropTarget(this.tvEpisodes.getControl(), (PersistentObjectDropTarget.IReceiver)new Receiver());
        this.setPatient(ElexisEventDispatcher.getSelectedPatient());
    }

    public void setPatient(Patient pat) {
        this.actPatient = pat;
        if (pat != null) {
            this.tvEpisodes.setInput((Object)pat);
        }
        this.tvEpisodes.refresh();
    }

    public Episode getSelectedEpisode() {
        TreeItem f;
        Tree widget = this.tvEpisodes.getTree();
        TreeItem[] sel = widget.getSelection();
        if (sel == null || sel.length == 0) {
            return null;
        }
        TreeItem p = f = sel[0];
        while ((p = (f = p).getParentItem()) != null) {
        }
        return this.getEpisodeFromItem(f);
    }

    private Episode getEpisodeFromItem(TreeItem t) {
        String etext = t.getText();
        Object[] objectArray = ((ITreeContentProvider)this.tvEpisodes.getContentProvider()).getElements((Object)this.actPatient);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Episode ep;
            Object o = objectArray[n2];
            if (o instanceof Episode && (ep = (Episode)o).getLabel().equals(etext)) {
                return ep;
            }
            ++n2;
        }
        return null;
    }

    class EpisodecontentProvider
    implements ITreeContentProvider {
        EpisodecontentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Episode) {
                Episode ep = (Episode)parentElement;
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("Seit: " + ep.get("StartDate"));
                ret.add("Status: " + ep.getStatusText());
                List<IDiagnose> diags = ep.getDiagnoses();
                for (IDiagnose dg : diags) {
                    ret.add(String.valueOf(dg.getCodeSystemName()) + ": " + dg.getLabel());
                }
                return ret.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Episode;
        }

        public Object[] getElements(Object inputElement) {
            if (EpisodesDisplay.this.actPatient != null) {
                Query qbe = new Query(Episode.class);
                qbe.add("PatientID", "=", EpisodesDisplay.this.actPatient.getId());
                List list = qbe.execute();
                Collections.sort(list);
                return list.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EpisodesLabelProvider
    extends LabelProvider
    implements IColorProvider {
        EpisodesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Episode) {
                return ((Episode)element).getLabel();
            }
            if (element instanceof String) {
                return element.toString();
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            Episode e;
            if (element instanceof Episode && (e = (Episode)element).getStatus() == 0) {
                return UiDesk.getColor((String)"hellgrau");
            }
            return UiDesk.getColor((String)"schwarz");
        }
    }

    class Receiver
    implements PersistentObjectDropTarget.IReceiver {
        Receiver() {
        }

        public boolean accept(PersistentObject o) {
            return o instanceof IDiagnose;
        }

        public void dropped(PersistentObject o, DropTargetEvent e) {
            Episode hit;
            Point point;
            Tree tree = EpisodesDisplay.this.tvEpisodes.getTree();
            TreeItem item = tree.getItem(point = tree.toControl(e.x, e.y));
            if (item != null && (hit = EpisodesDisplay.this.getEpisodeFromItem(item)) != null) {
                if (o instanceof IDiagnose) {
                    IDiagnose id = (IDiagnose)o;
                    hit.addDiagnosis(id);
                }
                EpisodesDisplay.this.tvEpisodes.refresh();
            }
        }
    }
}

