/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Encounter;
import ch.elexis.icpc.Episode;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyleRange;

public class KonsExtension
implements IKonsExtension {
    IRichTextDisplay mine;
    static final String EPISODE_TITLE = "Problem: ";

    public String connect(IRichTextDisplay tf) {
        this.mine = tf;
        this.mine.addDropReceiver(Episode.class, (IKonsExtension)this);
        return "ch.elexis.icpc";
    }

    public boolean doLayout(StyleRange n, String provider, String id) {
        n.background = UiDesk.getColor((String)"gruen");
        return true;
    }

    public boolean doXRef(String refProvider, String refID) {
        Encounter enc = Encounter.load(refID);
        if (enc.exists()) {
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)enc);
        }
        return true;
    }

    public IAction[] getActions() {
        return null;
    }

    public void insert(Object o, int pos) {
        if (o instanceof Episode) {
            Episode ep = (Episode)o;
            Konsultation k = (Konsultation)ElexisEventDispatcher.getSelected(Konsultation.class);
            Encounter enc = new Encounter(k, ep);
            List<IDiagnose> diags = ep.getDiagnoses();
            for (IDiagnose dg : diags) {
                k.addDiagnose(dg);
            }
            this.mine.insertXRef(pos, EPISODE_TITLE + ep.getLabel(), "ch.elexis.icpc", enc.getId());
            k.updateEintrag(this.mine.getContentsAsXML(), false);
            ElexisEventDispatcher.update((PersistentObject)k);
        }
    }

    public void removeXRef(String refProvider, String refID) {
        Encounter encounter = Encounter.load(refID);
        encounter.delete();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

