/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.ui.util.ImporterPage;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class IcpcImporter
extends ImporterPage {
    JdbcLink pj;

    public Composite createPage(Composite parent) {
        ImporterPage.FileBasedImporter fbi = new ImporterPage.FileBasedImporter(parent, (ImporterPage)this);
        fbi.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        return fbi;
    }

    public IStatus doImport(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Importiere ICPC-2", 727);
        new DatabaseBuilder().setReadOnly(true);
        Database db = DatabaseBuilder.open((File)new File(this.results[0]));
        monitor.worked(1);
        this.pj = PersistentObject.getConnection();
        monitor.subTask("L\u00f6sche alte Daten");
        this.pj.exec("DELETE FROM CH_ELEXIS_ICPC where ID != 'ver'");
        monitor.worked(1);
        monitor.subTask("Lese Daten ein");
        PreparedStatement ps = this.pj.prepareStatement("INSERT INTO CH_ELEXIS_ICPC (ID,component,txt,synonyms,short,icd10,criteria,inclusion,exclusion,consider,note)VALUES (?,?,?,?,?,?,?,?,?,?,?);");
        monitor.worked(1);
        try {
            Table table = db.getTable("ICPC2eGM");
            for (Row row : table) {
                ps.setString(1, (String)row.get((Object)"CODE"));
                ps.setObject(2, row.get((Object)"COMPONENT"));
                ps.setString(3, (String)row.get((Object)"TEXT"));
                ps.setString(4, (String)row.get((Object)"SYNONYMS"));
                ps.setString(5, (String)row.get((Object)"SHORT"));
                ps.setString(6, (String)row.get((Object)"ICD-10"));
                ps.setString(7, (String)row.get((Object)"CRIT"));
                ps.setString(8, (String)row.get((Object)"INCL"));
                ps.setString(9, (String)row.get((Object)"EXCL"));
                ps.setString(10, (String)row.get((Object)"CONS"));
                ps.setString(11, (String)row.get((Object)"NOTE"));
                ps.execute();
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(1);
            }
            monitor.done();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return new Status(4, "ICPC", 3, ex.getMessage(), null);
        }
        return Status.OK_STATUS;
    }

    public String getDescription() {
        return "International Classification of Primary Care";
    }

    public String getTitle() {
        return "ICPC-2";
    }

    private String convert(ResultSet res, int field) throws Exception {
        String line;
        Reader reader = res.getCharacterStream(field);
        if (reader == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        String ret = sb.toString();
        return ret;
    }
}

