/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import ch.elexis.icpc.Messages;
import ch.rgw.tools.Tree;
import ch.rgw.tools.VersionInfo;
import java.util.List;
import org.eclipse.jface.action.IAction;

public class IcpcCode
extends PersistentObject
implements IDiagnose {
    static final String TABLENAME = "CH_ELEXIS_ICPC";
    static final String VERSION = "1.2.1";
    public static final String createDB = "CREATE TABLE CH_ELEXIS_ICPC (ID\t\t\tCHAR(3) primary key,lastupdate BIGINT,deleted\tCHAR(1) default '0',component\tCHAR(2),short\t\tVARCHAR(80),synonyms   VARCHAR(250),icd10\t\t    TEXT,txt\t\t\tTEXT,criteria\t\tTEXT,inclusion \t\tTEXT,exclusion\t\tTEXT,consider\t\tTEXT,note\t\t\tTEXT);create index CH_ELEXIS_ICPC_IDX1 ON CH_ELEXIS_ICPC (component);INSERT INTO CH_ELEXIS_ICPC (ID,txt) VALUES ('ver','1.2.1');";
    private static Tree root;
    private String realCode;
    public static final String[] classes;
    public static final String[] components;

    static {
        VersionInfo vi;
        IcpcCode.addMapping((String)TABLENAME, (String[])new String[]{"component", "text=txt", "short", "icd10", "criteria", "inclusion", "exclusion", "consider", "note", "synonyms"});
        IcpcCode ver = IcpcCode.load("ver");
        if (!ver.exists()) {
            if (PersistentObject.tableExists((String)TABLENAME)) {
                IcpcCode.createOrModifyTable((String)"DROP TABLE CH_ELEXIS_ICPC");
            }
            IcpcCode.createOrModifyTable((String)createDB);
        }
        if ((vi = new VersionInfo(ver.get("text"))).isOlder(VERSION) && vi.isOlder(VERSION)) {
            IcpcCode.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_ICPC ADD lastupdate BIGINT;");
            ver.set("text", VERSION);
        }
        classes = new String[]{Messages.IcpcCode_class_A, Messages.IcpcCode_class_B, Messages.IcpcCode_class_D, Messages.IcpcCode_class_F, Messages.IcpcCode_class_H, Messages.IcpcCode_class_K, Messages.IcpcCode_class_L, Messages.IcpcCode_class_N, Messages.IcpcCode_class_P, Messages.IcpcCode_class_R, Messages.IcpcCode_class_S, Messages.IcpcCode_class_T, Messages.IcpcCode_class_U, Messages.IcpcCode_class_W, Messages.IcpcCode_class_X, Messages.IcpcCode_class_Y, Messages.IcpcCode_class_Z};
        components = new String[]{Messages.IcpcCode_comp_1, Messages.IcpcCode_comp_2, Messages.IcpcCode_comp_3, Messages.IcpcCode_comp_4, Messages.IcpcCode_comp_5, Messages.IcpcCode_comp_6, Messages.IcpcCode_comp_7};
    }

    public static void initialize() {
        UiDesk.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IcpcCode.createOrModifyTable((String)IcpcCode.createDB);
            }
        });
    }

    public static Tree getRoot() {
        if (root == null) {
            IcpcCode.reload();
        }
        return root;
    }

    public String getLabel() {
        if (this.realCode == null) {
            return String.valueOf(this.getId()) + " " + this.get("short");
        }
        return String.valueOf(this.realCode) + " " + this.get("short");
    }

    public void setLabel(String l) {
        this.realCode = l;
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public String getCode() {
        return this.getId();
    }

    public String getCodeSystemCode() {
        return "999";
    }

    public String getCodeSystemName() {
        return "Icpc";
    }

    public String getText() {
        return this.get("text");
    }

    protected IcpcCode() {
    }

    protected IcpcCode(String id) {
        super(id);
    }

    public static IcpcCode load(String id) {
        return new IcpcCode(id);
    }

    public static List<IcpcCode> loadAllFromComponent(String cl, String cmp, boolean rev) {
        Query qbe = new Query(IcpcCode.class);
        qbe.add("component", "=", cmp.substring(0, 1));
        qbe.startGroup();
        qbe.add("ID", "Like", "*%");
        qbe.or();
        qbe.add("ID", "Like", String.valueOf(cl.substring(0, 1)) + "%");
        qbe.endGroup();
        qbe.orderBy(rev, new String[]{"ID"});
        List list = qbe.execute();
        for (IcpcCode code : list) {
            code.setLabel(String.valueOf(cl.substring(0, 1)) + code.getId().substring(1));
        }
        return list;
    }

    public static void reload() {
        IcpcCode ic = IcpcCode.load("ver");
        if (!ic.exists()) {
            IcpcCode.initialize();
        } else {
            VersionInfo vi = new VersionInfo(ic.getText());
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("1.1.0")) {
                    IcpcCode.getConnection().exec("ALTER TABLE CH_ELEXIS_ICPC ADD deleted CHAR(1) default '0';");
                    ic.set("text", VERSION);
                }
                if (vi.isOlder("1.2.0")) {
                    IcpcCode.getConnection().equals("ALTER TABLE CH_ELEXIS_ICPC ADD synonyms VARCHAR(255)");
                }
            }
        }
        root = new Tree(null, null);
        int i = classes.length - 1;
        while (i >= 0) {
            String cl = classes[i];
            Tree tClass = new Tree(root, (Object)cl);
            int j = components.length - 1;
            while (j >= 0) {
                String cmp = components[j];
                Tree tComp = new Tree(tClass, (Object)cmp);
                List<IcpcCode> list = IcpcCode.loadAllFromComponent(cl, cmp, true);
                for (IcpcCode code : list) {
                    new Tree(tComp, (Object)code);
                }
                --j;
            }
            --i;
        }
    }

    public boolean isDragOK() {
        if (this.getId().length() == 3) {
            return true;
        }
        return super.isDragOK();
    }

    public String storeToString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "::" + this.getId();
    }

    public List<IAction> getActions(Verrechnet kontext) {
        return null;
    }

    public List<Object> getActions(Object context) {
        return null;
    }
}

