/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IDiagnose;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.icpc.Messages;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Episode
extends PersistentObject
implements Comparable<Episode> {
    public static final String FLD_PATIENT_ID = "PatientID";
    public static final String FLD_STATUS = "Status";
    public static final String FLD_NUMBER = "Number";
    public static final String FLD_START_DATE = "StartDate";
    public static final String FLD_TITLE = "Title";
    public static final int INACTIVE = 0;
    public static final int ACTIVE = 1;
    protected static final String VERSION = "0.4.2";
    protected static final String TABLENAME = "CH_ELEXIS_ICPC_EPISODES";
    protected static final String INACTIVE_VALUE = "0";
    protected static final String ACTIVE_VALUE = "1";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_ICPC_EPISODES (ID\t\t\t\tVARCHAR(25),lastupdate\t\tBIGINT,deleted \t\tCHAR(1) default '0',PatientID\t\tVARCHAR(25),Title\t\t\tVARCHAR(256),StartDate      VARCHAR(20),Number         VARCHAR(10),Status         CHAR(1) DEFAULT '1',ExtInfo\t\tBLOB);CREATE INDEX CH_ELEXIS_ICPC_EPISODES1 ON CH_ELEXIS_ICPC_EPISODES (PatientID);INSERT INTO CH_ELEXIS_ICPC_EPISODES (ID,Title) VALUES ('1'," + JdbcLink.wrap((String)"0.4.2") + ");";
    private static final String LINKNAME = "CH_ELEXIS_ICPC_EPISODES_DIAGNOSES_LINK";
    private static final String createLink = "CREATE TABLE CH_ELEXIS_ICPC_EPISODES_DIAGNOSES_LINK (ID\t\t\t\tVARCHAR(25),lastupdate \tBIGINT,deleted\t\tchar(1) default '0',Episode\t\tVARCHAR(25),Diagnosis\t\tVARCHAR(80));";
    private static final String upd041 = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES add lastupdate BIGINT;ALTER TABLE CH_ELEXIS_ICPC_EPISODES_DIAGNOSES_LINK ADD lastupdate BIGINT;";
    private static final String upd042 = "CREATE INDEX CH_ELEXIS_ICPC_EPISODES2 ON CH_ELEXIS_ICPC_EPISODES (Title);";

    static {
        Episode.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATIENT_ID, FLD_TITLE, FLD_START_DATE, FLD_NUMBER, FLD_STATUS, "ExtInfo", "DiagLink=JOINT:Diagnosis:Episode:CH_ELEXIS_ICPC_EPISODES_DIAGNOSES_LINK"});
        JdbcLink j = Episode.getConnection();
        Episode version = Episode.load(ACTIVE_VALUE);
        if (!version.exists()) {
            Episode.createOrModifyTable((String)createDB);
            Episode.createOrModifyTable((String)createLink);
        } else {
            VersionInfo vi = new VersionInfo(version.get(FLD_TITLE));
            if (vi.isOlder(VERSION)) {
                String sql;
                if (vi.isOlder("0.2.0")) {
                    j.exec(j.translateFlavor("ALTER TABLE CH_ELEXIS_ICPC_EPISODES ADD deleted CHAR(1) default '0';"));
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder("0.3.0")) {
                    sql = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES ADD StartDate VARCHAR(20);";
                    j.exec(j.translateFlavor(sql));
                    sql = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES ADD Number VARCHAR(10);";
                    j.exec(j.translateFlavor(sql));
                    sql = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES ADD Status CHAR(1) DEFAULT '1';";
                    j.exec(j.translateFlavor(sql));
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder("0.3.1")) {
                    sql = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES ADD ExtInfo BLOB;";
                    j.exec(j.translateFlavor(sql));
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder("0.3.2")) {
                    sql = "ALTER TABLE CH_ELEXIS_ICPC_EPISODES MODIFY Title VARCHAR(256);";
                    j.exec(j.translateFlavor(sql));
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder("0.4.0")) {
                    Episode.createOrModifyTable((String)createLink);
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder("0.4.1")) {
                    Episode.createOrModifyTable((String)upd041);
                    version.set(FLD_TITLE, VERSION);
                }
                if (vi.isOlder(VERSION)) {
                    Episode.createOrModifyTable((String)upd042);
                    version.set(FLD_TITLE, VERSION);
                }
            }
        }
    }

    public Episode(Patient pat, String title) {
        this.create(null);
        this.set(new String[]{FLD_PATIENT_ID, FLD_TITLE}, new String[]{pat.getId(), title});
    }

    public static Episode findEpisode(Patient pat, String title) {
        Query qbe = new Query(Episode.class);
        qbe.add(FLD_PATIENT_ID, "=", pat.getId());
        qbe.add(FLD_TITLE, "=", title);
        List result = qbe.execute();
        if (result == null || result.size() == 0) {
            return null;
        }
        return (Episode)result.get(0);
    }

    public String getLabel() {
        String title = this.get(FLD_TITLE);
        String number = this.get(FLD_NUMBER);
        int status = this.getStatus();
        StringBuffer sb = new StringBuffer();
        if (!StringTool.isNothing((Object)number)) {
            sb.append(number).append(": ");
        }
        sb.append(title);
        if (status == 0) {
            sb.append(" [" + this.getStatusText() + "]");
        }
        return sb.toString();
    }

    public List<IDiagnose> getDiagnoses() {
        List res = this.getList("DiagLink", null);
        ArrayList<IDiagnose> ret = new ArrayList<IDiagnose>(res.size());
        for (String[] diag : res) {
            IDiagnose id = (IDiagnose)CoreHub.poFactory.createFromString(diag[0]);
            if (id == null) continue;
            ret.add(id);
        }
        return ret;
    }

    public void addDiagnosis(IDiagnose id) {
        String clazz = id.getClass().getName();
        this.addToList("DiagLink", String.valueOf(clazz) + "::" + id.getCode(), new String[0]);
    }

    public void removeDiagnosis(IDiagnose id) {
        String clazz = id.getClass().getName();
        this.removeFromList("DiagLink", String.valueOf(clazz) + "::" + id.getCode());
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Episode load(String id) {
        return new Episode(id);
    }

    protected Episode(String id) {
        super(id);
    }

    protected Episode() {
    }

    public boolean isDragOK() {
        return true;
    }

    public Patient getPatient() {
        String id = this.get(FLD_PATIENT_ID);
        Patient patient = Patient.load((String)id);
        return patient;
    }

    public int getStatus() {
        String statusText = this.get(FLD_STATUS);
        if (statusText != null && statusText.equals(ACTIVE_VALUE)) {
            return 1;
        }
        return 0;
    }

    public String getStatusText() {
        int status = this.getStatus();
        if (status == 1) {
            return Messages.Active;
        }
        return Messages.Inactive;
    }

    public void setStatus(int status) {
        switch (status) {
            case 1: {
                this.set(FLD_STATUS, ACTIVE_VALUE);
                break;
            }
            case 0: {
                this.set(FLD_STATUS, INACTIVE_VALUE);
                break;
            }
            default: {
                this.set(FLD_STATUS, ACTIVE_VALUE);
            }
        }
    }

    @Override
    public int compareTo(Episode e2) {
        VersionInfo v2;
        VersionInfo v1 = new VersionInfo(this.get(FLD_NUMBER));
        if (v1.isNewer(v2 = new VersionInfo(e2.get(FLD_NUMBER)))) {
            return 1;
        }
        if (v1.isOlder(v2)) {
            return -1;
        }
        return 0;
    }

    public String getStartDate() {
        return this.get(FLD_START_DATE);
    }

    public void setStartDate(String startDate) {
        this.set(FLD_START_DATE, startDate);
    }

    public String getTitle() {
        return this.get(FLD_TITLE);
    }

    public void setTitle(String title) {
        this.set(FLD_TITLE, title);
    }

    public String getNumber() {
        return this.get(FLD_NUMBER);
    }

    public void setNumber(String number) {
        this.set(FLD_NUMBER, number);
    }

    public String getExtField(String name) {
        Map extInfo = this.getMap("ExtInfo");
        return (String)extInfo.get(name);
    }

    public void setExtField(String name, String text) {
        Map extInfo = this.getMap("ExtInfo");
        extInfo.put(name, text);
        this.setMap("ExtInfo", extInfo);
    }

    public static Episode findEpisode(String name) {
        List res = new Query(Episode.class, FLD_TITLE, name).execute();
        if (res.size() == 1) {
            return (Episode)res.get(0);
        }
        return null;
    }
}

