/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.icpc.Episode;
import ch.elexis.icpc.IcpcCode;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionInfo;

public class Encounter
extends PersistentObject {
    private static final String VERSION = "0.2.1";
    private static final String TABLENAME = "CH_ELEXIS_ICPC_ENCOUNTER";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_ICPC_ENCOUNTER (ID\t\t\t\tVARCHAR(25),lastupdate \tBIGINT,deleted\t\tCHAR(1) default '0',KONS\t\t\tVARCHAR(25),EPISODE\t\tVARCHAR(25),RFE\t\t\tCHAR(4),DIAG\t\t\tCHAR(4),PROC\t\t\tCHAR(4),ExtInfo\t\tBLOB);CREATE INDEX CH_ELEXIS_ICPC_ENCOUNTER1 ON CH_ELEXIS_ICPC_ENCOUNTER (KONS);CREATE INDEX CH_ELEXIS_ICPC_ENCOUNTER2 ON CH_ELEXIS_ICPC_ENCOUNTER (EPISODE);INSERT INTO CH_ELEXIS_ICPC_ENCOUNTER (ID,KONS) VALUES ('1'," + JdbcLink.wrap((String)"0.2.1") + ");";

    static {
        Encounter.addMapping((String)TABLENAME, (String[])new String[]{"KonsID=KONS", "EpisodeID=EPISODE", "RFE", "Diag", "Proc", "ExtInfo"});
        Encounter version = Encounter.load("1");
        if (!version.exists()) {
            Encounter.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.get("KonsID"));
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("0.2.0")) {
                    Encounter.getConnection().exec("ALTER TABLE CH_ELEXIS_ICPC_ENCOUNTER ADD deleted CHAR(1) default '0';");
                    version.set("KonsID", VERSION);
                } else if (vi.isOlder(VERSION)) {
                    Encounter.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_ICPC_ENCOUNTER ADD lastupdate BIGINT;");
                    version.set("KonsID", VERSION);
                }
            }
        }
    }

    public Encounter(Konsultation kons, Episode ep) {
        this.create(null);
        this.set(new String[]{"KonsID", "EpisodeID"}, new String[]{kons.getId(), ep.getId()});
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKons().getDatum()).append(": ").append(this.get("RFE")).append(", ").append(this.get("Diag")).append(", ").append(this.get("Proc"));
        return sb.toString();
    }

    public Konsultation getKons() {
        return Konsultation.load((String)this.get("KonsID"));
    }

    public Episode getEpisode() {
        return Episode.load(this.get("EpisodeID"));
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static Encounter load(String id) {
        return new Encounter(id);
    }

    protected Encounter(String id) {
        super(id);
    }

    protected Encounter() {
    }

    public void setRFE(IcpcCode code) {
        this.set("RFE", code.getId());
    }

    public void setDiag(IcpcCode code) {
        this.set("Diag", code.getId());
    }

    public void setProc(IcpcCode code) {
        this.set("Proc", code.getId());
    }

    public IcpcCode getRFE() {
        String rfeID = this.get("RFE");
        return StringTool.isNothing((Object)rfeID) ? null : IcpcCode.load(rfeID);
    }

    public IcpcCode getDiag() {
        String diagID = this.get("Diag");
        return StringTool.isNothing((Object)diagID) ? null : IcpcCode.load(diagID);
    }

    public IcpcCode getProc() {
        String procID = this.get("Proc");
        return StringTool.isNothing((Object)procID) ? null : IcpcCode.load(procID);
    }
}

