/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc;

import ch.elexis.core.data.interfaces.IDataAccess;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.icpc.Encounter;
import ch.elexis.icpc.Episode;
import ch.elexis.icpc.IcpcCode;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataAccessor
implements IDataAccess {
    public String getName() {
        return "ICPC2-Daten";
    }

    public String getDescription() {
        return "Daten aus dem ICPC2-Plugin";
    }

    public List<IDataAccess.Element> getList() {
        return null;
    }

    private String code(IcpcCode ic) {
        return ic == null ? "" : ic.getCode();
    }

    private Result<Object> sucheEncounters(Episode ep, String dates, PersistentObject dep) {
        Query qen = new Query(Encounter.class);
        qen.add("EpisodeID", "LIKE", ep.getId());
        if (dep instanceof Konsultation) {
            Konsultation kons = (Konsultation)dep;
            qen.add("KonsID", "LIKE", kons.getId());
        }
        qen.addPostQueryFilter(new IFilter(){

            public boolean select(Object element) {
                Encounter e = (Encounter)((Object)element);
                return e.getRFE() != null || e.getDiag() != null || e.getProc() != null;
            }
        });
        List result = qen.execute();
        Collections.sort(result, new Comparator<Encounter>(){

            @Override
            public int compare(Encounter e1, Encounter e2) {
                TimeTool tt1 = new TimeTool(e1.getKons().getDatum());
                TimeTool tt2 = new TimeTool(e2.getKons().getDatum());
                return tt1.compareTo((Calendar)tt2);
            }
        });
        return new Result((Object)result);
    }

    private Result<Object> sucheEncounters(List<Episode> eps, Map<Episode, List<Encounter>> encs, PersistentObject dep, String dates) {
        Patient pat;
        if (dep instanceof Konsultation) {
            Konsultation kons = (Konsultation)dep;
            pat = kons.getFall().getPatient();
        } else if (dep instanceof Patient) {
            pat = (Patient)dep;
        } else {
            return new Result(Result.SEVERITY.ERROR, 1, "Ung\u00fcltiger Parameter", (Object)dep, true);
        }
        Query qep = new Query(Episode.class);
        qep.add("PatientID", "LIKE", pat.getId());
        qep.orderBy(false, new String[]{"StartDate"});
        List raw_eps = qep.execute();
        int count = 0;
        for (Episode ep : raw_eps) {
            Result<Object> res = this.sucheEncounters(ep, dates, dep);
            if (!res.isOK()) {
                return res;
            }
            List ep_encs = (List)res.get();
            if (ep_encs.size() <= 0) continue;
            eps.add(ep);
            encs.put(ep, ep_encs);
            count += 1 + ep_encs.size();
        }
        return new Result((Object)count);
    }

    public Result<Object> getObject(String descriptor, PersistentObject dependentObject, String dates, String[] params) {
        if (descriptor.toLowerCase().equals("encounters")) {
            LinkedList<Episode> episodes = new LinkedList<Episode>();
            HashMap<Episode, List<Encounter>> encounters = new HashMap<Episode, List<Encounter>>();
            Result<Object> res = this.sucheEncounters(episodes, encounters, dependentObject, dates);
            if (!res.isOK()) {
                return res;
            }
            int rows = (Integer)res.get() + 1;
            String[][] result = new String[rows][5];
            int i = 0;
            result[i][0] = "Problem";
            result[i][1] = "Datum";
            result[i][2] = "RFE";
            result[i][3] = "Diagnose";
            result[i][4] = "Procedere";
            ++i;
            for (Episode ep : episodes) {
                result[i][0] = ep.getTitle();
                result[i][1] = ep.getStartDate();
                result[i][2] = ep.getStatusText();
                result[i][4] = "";
                result[i][3] = "";
                ++i;
                for (Encounter en : encounters.get(ep)) {
                    result[i][0] = "";
                    result[i][1] = en.getKons().getDatum();
                    result[i][2] = this.code(en.getRFE());
                    result[i][3] = this.code(en.getDiag());
                    result[i][4] = this.code(en.getProc());
                    ++i;
                }
            }
            return new Result((Object)result);
        }
        return new Result(Result.SEVERITY.ERROR, 2, "Ung\u00fcltiger Parameter", (Object)descriptor, true);
    }
}

