/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model.jaxb;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateTimeAdapter
extends XmlAdapter<String, XMLGregorianCalendar> {
    private final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public String marshal(XMLGregorianCalendar calendar) throws Exception {
        if (calendar != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return dateFormat.format(calendar.toGregorianCalendar().getTime());
        }
        return null;
    }

    public XMLGregorianCalendar unmarshal(String dateTimeString) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Date dateTime = dateFormat.parse(dateTimeString);
        GregorianCalendar gCalendar = new GregorianCalendar();
        gCalendar.setTime(dateTime);
        XMLGregorianCalendar xmlCalendar = null;
        try {
            xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gCalendar);
        }
        catch (DatatypeConfigurationException ex) {
            return null;
        }
        return xmlCalendar;
    }
}

