/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.icpc.fire.model;

import ch.elexis.icpc.fire.model.Report;
import ch.rgw.tools.TimeTool;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static final String JAXB_HEADER_KEY = "com.sun.xml.internal.bind.xmlHeaders";
    private static final String DEFAULT_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static Logger logger = LoggerFactory.getLogger(XmlUtil.class);

    public static XMLGregorianCalendar getXmlGregorianCalendar(TimeTool timeTool) throws DatatypeConfigurationException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(timeTool.getTime());
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
    }

    public static boolean marshallFireReport(Report report, OutputStream outStream) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Report.class});
            Marshaller marshaller = XmlUtil.initMarshaller(jaxbContext);
            marshaller.marshal((Object)report, outStream);
            return true;
        }
        catch (JAXBException e) {
            logger.error("Marshalling Report file failed", (Throwable)e);
            return false;
        }
    }

    public static Marshaller initMarshaller(JAXBContext jaxbContext) throws JAXBException {
        Marshaller marshaller = jaxbContext.createMarshaller();
        try {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.schemaLocation", (Object)"/rsc/fireDbDe_20170322.xsd");
            marshaller.setProperty(JAXB_HEADER_KEY, (Object)DEFAULT_HEADER);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            return marshaller;
        }
        catch (PropertyException propE) {
            logger.error("Error setting marshall properties - concerns XML with schema [/rsc/fireDbDe_20170322.xsd]", (Throwable)propE);
            return marshaller;
        }
    }
}

